/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.oblivioussp.spartanweaponry.api.OilEffects;
import com.oblivioussp.spartanweaponry.api.oil.OilEffect;
import com.oblivioussp.spartanweaponry.command.OilInput;
import com.oblivioussp.spartanweaponry.command.OilParser;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;

public class OilArgument
implements ArgumentType<OilInput> {
    private static final Collection<String> EXAMPLES = Arrays.asList("spartanweaponry:undead");

    public static OilArgument oil() {
        return new OilArgument();
    }

    public OilInput parse(StringReader reader) throws CommandSyntaxException {
        OilParser parser = new OilParser(reader).parse();
        return new OilInput(parser.getEffect());
    }

    public static <S> OilInput getOil(CommandContext<S> context, String string) {
        return (OilInput)context.getArgument(string, OilInput.class);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        OilParser parser = new OilParser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(OilEffects.REGISTRY_KEY);
        return parser.fillSuggestions(builder, (IForgeRegistry<OilEffect>)registry);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

