/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.oblivioussp.spartanweaponry.capability.IOilHandler;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import com.oblivioussp.spartanweaponry.util.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.RenderTypeGroup;
import net.minecraftforge.client.model.CompositeModel;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.common.util.LazyOptional;

public class OilCoatingItemBakedModel
extends CompositeModel.Baked {
    private final ImmutableList<BakedModel> coatedLayerModels;

    public OilCoatingItemBakedModel(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ItemTransforms transforms, ItemOverrides overrides, ImmutableMap<String, BakedModel> children, ImmutableList<BakedModel> itemPasses, ImmutableList<BakedModel> coatedLayerModelsIn) {
        super(isGui3d, isSideLit, isAmbientOcclusion, particle, transforms, overrides, children, itemPasses);
        this.coatedLayerModels = coatedLayerModelsIn;
    }

    public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
        LazyOptional lazyHandler = itemStack.getCapability(ModCapabilities.OIL_CAPABILITY);
        return lazyHandler.isPresent() && ((IOilHandler)lazyHandler.resolve().get()).isOiled() ? this.coatedLayerModels : super.getRenderPasses(itemStack, fabulous);
    }

    public static Builder makeBuilder(IGeometryBakingContext contextIn, TextureAtlasSprite particleIn, ItemOverrides overridesIn, ItemTransforms transformsIn) {
        return new Builder(contextIn.getModelName(), contextIn.useAmbientOcclusion(), contextIn.isGui3d(), contextIn.useBlockLight(), particleIn, overridesIn, transformsIn);
    }

    public static class Builder {
        private final String name;
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final List<BakedModel> children = new ArrayList<BakedModel>();
        private final List<BakedQuad> quads = new ArrayList<BakedQuad>();
        private final List<BakedModel> coatedModel = new ArrayList<BakedModel>();
        private final ItemOverrides overrides;
        private final ItemTransforms transforms;
        private TextureAtlasSprite particle;
        private RenderTypeGroup lastRenderType = RenderTypeGroup.EMPTY;

        private Builder(String nameIn, boolean isAmbientOcclusionIn, boolean isGui3dIn, boolean isSideLitIn, TextureAtlasSprite particleIn, ItemOverrides overridesIn, ItemTransforms transformsIn) {
            this.name = nameIn;
            this.isAmbientOcclusion = isAmbientOcclusionIn;
            this.isGui3d = isGui3dIn;
            this.isSideLit = isSideLitIn;
            this.overrides = overridesIn;
            this.transforms = transformsIn;
            this.particle = particleIn;
        }

        private void addChildrenLayer(RenderTypeGroup renderTypeIn, List<BakedQuad> quadsIn) {
            IModelBuilder modelBuilder = IModelBuilder.of((boolean)this.isAmbientOcclusion, (boolean)this.isSideLit, (boolean)this.isGui3d, (ItemTransforms)this.transforms, (ItemOverrides)this.overrides, (TextureAtlasSprite)this.particle, (RenderTypeGroup)renderTypeIn);
            quadsIn.forEach(arg_0 -> ((IModelBuilder)modelBuilder).addUnculledFace(arg_0));
            this.children.add(modelBuilder.build());
        }

        private void addCoatedLayer(RenderTypeGroup renderTypeIn, List<BakedQuad> quadsIn) {
            IModelBuilder modelBuilder = IModelBuilder.of((boolean)this.isAmbientOcclusion, (boolean)this.isSideLit, (boolean)this.isGui3d, (ItemTransforms)this.transforms, (ItemOverrides)this.overrides, (TextureAtlasSprite)this.particle, (RenderTypeGroup)renderTypeIn);
            quadsIn.forEach(arg_0 -> ((IModelBuilder)modelBuilder).addUnculledFace(arg_0));
            this.coatedModel.add(modelBuilder.build());
        }

        private void flushChildrenQuads(RenderTypeGroup renderTypeIn) {
            if (!Objects.equals(renderTypeIn, this.lastRenderType)) {
                if (this.quads.size() > 0) {
                    this.addChildrenLayer(this.lastRenderType, this.quads);
                    this.quads.clear();
                }
                this.lastRenderType = renderTypeIn;
            }
        }

        public Builder addQuads(RenderTypeGroup renderTypeIn, List<BakedQuad> quadsIn) {
            this.flushChildrenQuads(renderTypeIn);
            this.quads.addAll(quadsIn);
            return this;
        }

        public Builder addCoatedQuads(RenderTypeGroup renderTypeIn, List<BakedQuad> quadsIn) {
            if (!this.coatedModel.isEmpty()) {
                Log.error("Failed to add coating quads for model '" + this.name + "'; Coating quads have already been added!");
            } else {
                if (this.quads.size() > 0) {
                    this.addChildrenLayer(this.lastRenderType, this.quads);
                    this.quads.clear();
                }
                this.addCoatedLayer(renderTypeIn, quadsIn);
                this.lastRenderType = renderTypeIn;
            }
            return this;
        }

        public BakedModel build() {
            if (this.coatedModel.isEmpty() && this.quads.size() > 0) {
                this.addChildrenLayer(this.lastRenderType, this.quads);
            }
            ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
            ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
            ImmutableList.Builder coatedModelBuilder = ImmutableList.builder();
            int i = 0;
            for (BakedModel model : this.children) {
                childrenBuilder.put((Object)("model_" + i++), (Object)model);
                itemPassesBuilder.add((Object)model);
            }
            if (!this.coatedModel.isEmpty()) {
                coatedModelBuilder.addAll(this.children);
                coatedModelBuilder.addAll(this.coatedModel);
            }
            return new OilCoatingItemBakedModel(this.isGui3d, this.isSideLit, this.isAmbientOcclusion, this.particle, this.transforms, this.overrides, (ImmutableMap<String, BakedModel>)childrenBuilder.build(), (ImmutableList<BakedModel>)itemPassesBuilder.build(), (ImmutableList<BakedModel>)coatedModelBuilder.build());
        }
    }
}

