/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.client.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.oblivioussp.spartanweaponry.inventory.QuiverArrowMenu;
import com.oblivioussp.spartanweaponry.inventory.QuiverBoltMenu;
import com.oblivioussp.spartanweaponry.inventory.tooltip.QuiverTooltip;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;

public class ClientQuiverTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spartanweaponry", "textures/gui/tooltip/quiver.png");
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 18;
    private static final int BORDER_WIDTH_LEFT = 7;
    private static final int BORDER_WIDTH_RIGHT = 9;
    private static final int BORDER_HEIGHT = 2;
    private static final int MAX_SLOTS_X = 9;
    private static final int TEXTURE_SIZE = 128;
    private static final int BLIT_OFFSET = 0;
    private final NonNullList<ItemStack> items;
    private final int itemsSize;
    private final int prioritySlot;
    private final int slotsX;
    private final boolean isBoltQuiver;

    public ClientQuiverTooltip(QuiverTooltip quiverIn) {
        this.items = quiverIn.getItems();
        this.itemsSize = this.items.size();
        this.prioritySlot = quiverIn.getPrioritySlot();
        this.slotsX = this.itemsSize == 12 ? 6 : 9;
        this.isBoltQuiver = quiverIn.isBoltQuiver();
    }

    public int m_142103_() {
        return this.gridSizeY() * 18 + 2 + 2 + 2;
    }

    public int m_142069_(Font font) {
        return this.gridSizeX() * 18 + 7 + 9;
    }

    private int gridSizeX() {
        return Math.min(this.slotsX, this.itemsSize);
    }

    private int gridSizeY() {
        return Mth.m_14167_((float)((float)this.itemsSize / (float)this.gridSizeX()));
    }

    public void m_183452_(Font fontIn, int posXIn, int posYIn, GuiGraphics guiGraphics) {
        for (int i = 0; i < this.itemsSize; ++i) {
            this.renderSlot(i, fontIn, posXIn, posYIn, guiGraphics);
        }
        boolean drawLongVertBorders = this.itemsSize == 12;
        this.blitPart(guiGraphics, posXIn, posYIn, drawLongVertBorders ? TexturePart.BORDER_LONG_LEFT : TexturePart.BORDER_LEFT);
        for (int i = 0; i < this.gridSizeX(); ++i) {
            this.blitPart(guiGraphics, posXIn + 7 + i * 18, posYIn, TexturePart.BORDER_UP);
            this.blitPart(guiGraphics, posXIn + 7 + i * 18, posYIn + 2 + this.gridSizeY() * 18, TexturePart.BORDER_DOWN);
        }
        this.blitPart(guiGraphics, posXIn + 7 + this.gridSizeX() * 18, posYIn, drawLongVertBorders ? TexturePart.BORDER_LONG_RIGHT : TexturePart.BORDER_RIGHT);
    }

    public void renderSlot(int slotIdxIn, Font fontIn, int posXIn, int posYIn, GuiGraphics guiGraphics) {
        ItemStack stackToDraw = (ItemStack)this.items.get(slotIdxIn);
        int slotX = posXIn + 7 + slotIdxIn % this.gridSizeX() * 18;
        int slotY = posYIn + 2 + Mth.m_14143_((float)((float)slotIdxIn / (float)this.slotsX)) * 18;
        this.blitPart(guiGraphics, slotX, slotY, TexturePart.SLOT);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft mc = Minecraft.m_91087_();
        TextureAtlasSprite sprite = (TextureAtlasSprite)mc.m_91258_(InventoryMenu.f_39692_).apply(this.isBoltQuiver ? QuiverBoltMenu.EMPTY_BOLT_SLOT : QuiverArrowMenu.EMPTY_ARROW_SLOT);
        guiGraphics.m_280159_(slotX + 1, slotY + 1, 0, 16, 16, sprite);
        if (slotIdxIn == this.prioritySlot) {
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(slotX + 1), (int)(slotY + 1), (int)10, (int)-2143240128);
        }
        if (!stackToDraw.m_41619_()) {
            guiGraphics.m_280480_(stackToDraw, slotX + 1, slotY + 1);
            guiGraphics.m_280370_(fontIn, stackToDraw, slotX + 1, slotY + 1);
        }
    }

    protected void blitPart(GuiGraphics guiGraphics, int posXIn, int posYIn, TexturePart partIn) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280398_(TEXTURE, posXIn, posYIn, 0, (float)partIn.x, (float)partIn.y, partIn.width, partIn.height, 128, 128);
    }

    protected static enum TexturePart {
        SLOT(0, 0, 18, 18),
        BORDER_LEFT(0, 25, 7, 22),
        BORDER_RIGHT(9, 25, 9, 22),
        BORDER_LONG_LEFT(0, 48, 7, 40),
        BORDER_LONG_RIGHT(9, 48, 9, 40),
        BORDER_UP(0, 19, 18, 2),
        BORDER_DOWN(0, 22, 18, 2);

        public final int x;
        public final int y;
        public final int width;
        public final int height;

        private TexturePart(int xIn, int yIn, int widthIn, int heightIn) {
            this.x = xIn;
            this.y = yIn;
            this.width = widthIn;
            this.height = heightIn;
        }
    }
}

