/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.capability;

import com.oblivioussp.spartanweaponry.capability.QuiverItemStackHandler;
import com.oblivioussp.spartanweaponry.init.ModCapabilities;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class QuiverCapabilityProvider
implements ICapabilitySerializable<CompoundTag> {
    protected ItemStack quiver;
    protected final LazyOptional<QuiverItemStackHandler> handler;
    protected final int inventorySize;

    public QuiverCapabilityProvider(ItemStack stack, int invSize, CompoundTag nbt) {
        this.quiver = stack;
        this.inventorySize = invSize;
        this.handler = LazyOptional.of(() -> new QuiverItemStackHandler(invSize));
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return ModCapabilities.QUIVER_ITEM_CAPABILITY.orEmpty(cap, this.handler.cast());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = ((QuiverItemStackHandler)this.handler.resolve().get()).serializeNBT();
        this.quiver.m_41784_().m_128365_("Ammo", (Tag)tag);
        return new CompoundTag();
    }

    public void deserializeNBT(CompoundTag nbt) {
        CompoundTag tagCopy = this.quiver.m_41784_().m_128469_("Ammo");
        ((QuiverItemStackHandler)this.handler.resolve().get()).deserializeNBT(tagCopy);
    }
}

