/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.trait;

import com.oblivioussp.spartanweaponry.api.APIConfigValues;
import com.oblivioussp.spartanweaponry.api.WeaponMaterial;
import com.oblivioussp.spartanweaponry.api.trait.MeleeCallbackWeaponTrait;
import com.oblivioussp.spartanweaponry.api.trait.WeaponTrait;
import com.oblivioussp.spartanweaponry.init.ModDamageTypes;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public class DamageBonusWeaponTrait
extends MeleeCallbackWeaponTrait {
    public static final DamageCalculationFunc DAMAGE_DEFAULT = (material, baseDamage, bonusDamage, source, attacker, victim) -> baseDamage;
    public static final DamageCalculationFunc DAMAGE_CHEST = (material, baseDamage, bonusDamage, source, attacker, victim) -> victim.m_6844_(EquipmentSlot.CHEST).m_41619_() && (!APIConfigValues.damageBonusCheckArmorValue || victim.m_21133_(Attributes.f_22284_) <= (double)APIConfigValues.damageBonusMaxArmorValue) ? baseDamage + bonusDamage : baseDamage;
    public static final DamageCalculationFunc DAMAGE_HELMET = (material, baseDamage, bonusDamage, source, attacker, victim) -> victim.m_6844_(EquipmentSlot.HEAD).m_41619_() && (!APIConfigValues.damageBonusCheckArmorValue || victim.m_21133_(Attributes.f_22284_) <= (double)APIConfigValues.damageBonusMaxArmorValue) ? baseDamage + bonusDamage : baseDamage;
    public static final DamageCalculationFunc DAMAGE_UNARMOURED = (material, baseDamage, bonusDamage, source, attacker, victim) -> {
        boolean isUnarmored = victim.m_6844_(EquipmentSlot.HEAD).m_41619_() && victim.m_6844_(EquipmentSlot.CHEST).m_41619_() && victim.m_6844_(EquipmentSlot.LEGS).m_41619_() && victim.m_6844_(EquipmentSlot.FEET).m_41619_();
        return isUnarmored && (!APIConfigValues.damageBonusCheckArmorValue || victim.m_21133_(Attributes.f_22284_) <= (double)APIConfigValues.damageBonusMaxArmorValue) ? baseDamage + bonusDamage : baseDamage;
    };
    public static final DamageCalculationFunc DAMAGE_RIDING = (material, baseDamage, bonusDamage, source, attacker, victim) -> attacker.m_20202_() != null ? baseDamage + bonusDamage : baseDamage;
    public static final DamageCalculationFunc DAMAGE_UNDEAD = (material, baseDamage, bonusDamage, source, attacker, victim) -> victim.m_6336_() == MobType.f_21641_ ? baseDamage + bonusDamage : baseDamage;
    public static final DamageCalculationFunc DAMAGE_BACKSTAB = (material, baseDamage, bonusDamage, source, attacker, victim) -> {
        Entity immediateEntity = source.m_7639_();
        float yaw = source.m_276093_(ModDamageTypes.KEY_THROWN_WEAPON_PLAYER) ? -immediateEntity.f_19859_ : immediateEntity.f_19859_;
        float victimYaw = victim.f_19859_;
        float difference = victimYaw - yaw;
        difference = DamageBonusWeaponTrait.posMod(difference + 180.0f, 360.0f) - 180.0f;
        boolean doBonusDamage = Mth.m_14154_((float)difference) <= 30.0f;
        return doBonusDamage ? baseDamage + bonusDamage : baseDamage;
    };
    private final DamageCalculationFunc damageFunc;

    public DamageBonusWeaponTrait(String typeIn, String modIdIn, DamageCalculationFunc func) {
        super(typeIn, modIdIn, WeaponTrait.TraitQuality.POSITIVE);
        this.damageFunc = func;
        this.isThrowing = true;
    }

    @Override
    protected void addTooltipDescription(ItemStack stack, List<Component> tooltip) {
        if (APIConfigValues.damageBonusCheckArmorValue && (this.type == "extra_damage_chest" || this.type == "extra_damage_unarmoured" || this.type == "extra_damage_helmet")) {
            tooltip.add((Component)DamageBonusWeaponTrait.tooltipIndent().m_7220_((Component)Component.m_237110_((String)String.format("tooltip.%s.trait.%s.desc.armor_points", "spartanweaponry", this.type), (Object[])new Object[]{Float.valueOf((this.magnitude - 1.0f) * 100.0f), Float.valueOf(APIConfigValues.damageBonusMaxArmorValue)}).m_130944_(WeaponTrait.DESCRIPTION_FORMAT)));
        } else {
            tooltip.add((Component)DamageBonusWeaponTrait.tooltipIndent().m_7220_((Component)Component.m_237110_((String)String.format("tooltip.%s.trait.%s.desc", "spartanweaponry", this.type), (Object[])new Object[]{Float.valueOf((this.magnitude - 1.0f) * 100.0f)}).m_130944_(WeaponTrait.DESCRIPTION_FORMAT)));
        }
    }

    @Override
    public float modifyDamageDealt(WeaponMaterial material, float baseDamage, DamageSource source, LivingEntity attacker, LivingEntity victim) {
        if (attacker == null || victim == null) {
            return baseDamage;
        }
        float bonusDamage = (this.getMagnitude() - 1.0f) * baseDamage;
        return this.damageFunc.calculate(material, baseDamage, bonusDamage, source, attacker, victim);
    }

    private static float posMod(float num, float den) {
        return (num % den + den) % den;
    }

    @FunctionalInterface
    public static interface DamageCalculationFunc {
        public float calculate(WeaponMaterial var1, float var2, float var3, DamageSource var4, LivingEntity var5, LivingEntity var6);
    }
}

