/*
 * Decompiled with CFR 0.152.
 */
package com.oblivioussp.spartanweaponry.api.oil;

import com.oblivioussp.spartanweaponry.api.tags.ModEntityTypeTags;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class OilEffect {
    public static final IUsePredicate USE_NOTHING = (baseDamage, effect, level, target, user) -> false;
    public static final IUsePredicate USE_UNDEAD = (baseDamage, effect, level, target, user) -> target.m_6336_() == MobType.f_21641_;
    public static final IUsePredicate USE_ARTHROPOD = (baseDamage, effect, level, target, user) -> target.m_6336_() == MobType.f_21642_;
    public static final IUsePredicate USE_CRYOTIC = (baseDamage, effect, level, target, user) -> target.m_6095_().m_204039_(EntityTypeTags.f_144295_);
    public static final IUsePredicate USE_NECTROTIC = (baseDamage, effect, level, target, user) -> target.m_6095_().m_204039_(ModEntityTypeTags.HUMANOIDS);
    public static final IUsePredicate USE_CREEPER = (baseDamage, effect, level, target, user) -> target.m_6095_().m_204039_(ModEntityTypeTags.CREEPERS);
    public static final IUsePredicate USE_AQUATIC = (baseDamage, effect, level, target, user) -> target.m_6336_() == MobType.f_21644_;
    public static final IUsePredicate USE_ENDER = (baseDamage, effect, level, target, user) -> target.m_6095_().m_204039_(ModEntityTypeTags.ENDER);
    protected final String name;
    protected final OilEffectType type;
    protected final int color;
    protected int maxUses;
    protected float damageModifier;
    protected final IUsePredicate usePredicate;
    protected final boolean isPotionOil;

    public OilEffect(String nameIn, OilEffectType typeIn, int colorIn, int maxUsesIn, float damageModifierIn, IUsePredicate usePredicateIn, boolean isPotionOilIn) {
        this.name = nameIn;
        this.type = typeIn;
        this.color = colorIn;
        this.maxUses = maxUsesIn;
        this.damageModifier = damageModifierIn;
        this.usePredicate = usePredicateIn;
        this.isPotionOil = isPotionOilIn;
    }

    public OilEffect(String nameIn, OilEffectType typeIn, int colorIn, int maxUsesIn, float damageModifierIn, IUsePredicate usePredicateIn) {
        this(nameIn, typeIn, colorIn, maxUsesIn, damageModifierIn, usePredicateIn, false);
    }

    public String getName() {
        return this.name;
    }

    public OilEffectType getType() {
        return this.type;
    }

    public int getColor(ItemStack stackIn) {
        return this.color;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public float getDamageModifier() {
        return this.damageModifier;
    }

    public void updateFromConfig(int maxUsesIn, float damageModifierIn) {
        this.maxUses = maxUsesIn;
        this.damageModifier = damageModifierIn;
    }

    public float onUse(float baseDamageIn, Level levelIn, LivingEntity targetEntityIn, LivingEntity userEntityIn, ItemStack oilStackIn) {
        return this.usePredicate.test(baseDamageIn, this, levelIn, targetEntityIn, userEntityIn) ? baseDamageIn + baseDamageIn * this.getDamageModifier() : baseDamageIn;
    }

    public void getTooltip(ItemStack stackIn, List<Component> tooltipListIn) {
        tooltipListIn.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
        tooltipListIn.add((Component)Component.m_237110_((String)("tooltip.spartanweaponry.weapon_oil.applied." + this.getName()), (Object[])new Object[]{Float.valueOf(this.getDamageModifier() * 100.0f)}).m_130940_(ChatFormatting.BLUE));
    }

    public static enum OilEffectType {
        NONE,
        STANDARD,
        SUSTAINED,
        POTENT,
        EFFECT_ONLY;

    }

    @FunctionalInterface
    public static interface IUsePredicate {
        public boolean test(float var1, OilEffect var2, Level var3, LivingEntity var4, LivingEntity var5);
    }
}

