/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.inventory.ISlotTracker;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;

public class ContentsFilteredItemHandler
implements ITrackedContentsItemHandler {
    private final Supplier<ITrackedContentsItemHandler> itemHandlerGetter;
    private final Supplier<ISlotTracker> slotTrackerGetter;
    private final Supplier<MemorySettingsCategory> memorySettingsGetter;

    public ContentsFilteredItemHandler(Supplier<ITrackedContentsItemHandler> itemHandlerGetter, Supplier<ISlotTracker> slotTrackerGetter, Supplier<MemorySettingsCategory> memorySettingsGetter) {
        this.itemHandlerGetter = itemHandlerGetter;
        this.slotTrackerGetter = slotTrackerGetter;
        this.memorySettingsGetter = memorySettingsGetter;
    }

    public int getSlots() {
        return this.itemHandlerGetter.get().getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandlerGetter.get().getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.matchesContents(stack)) {
            return this.itemHandlerGetter.get().insertItem(slot, stack, simulate);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.itemHandlerGetter.get().extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.itemHandlerGetter.get().getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.matchesContents(stack) && this.itemHandlerGetter.get().isItemValid(slot, stack);
    }

    private boolean matchesContents(ItemStack stack) {
        return this.slotTrackerGetter.get().getItems().contains(stack.m_41720_()) || this.memorySettingsGetter.get().matchesFilter(stack);
    }

    public ItemStack insertItem(ItemStack stack, boolean simulate) {
        if (this.matchesContents(stack)) {
            return this.itemHandlerGetter.get().insertItem(stack, simulate);
        }
        return stack;
    }

    public Set<ItemStackKey> getTrackedStacks() {
        return this.itemHandlerGetter.get().getTrackedStacks();
    }

    public void registerTrackingListeners(Consumer<ItemStackKey> onAddStackKey, Consumer<ItemStackKey> onRemoveStackKey, Runnable onAddFirstEmptySlot, Runnable onRemoveLastEmptySlot) {
        this.itemHandlerGetter.get().registerTrackingListeners(onAddStackKey, onRemoveStackKey, onAddFirstEmptySlot, onRemoveLastEmptySlot);
    }

    public void unregisterStackKeyListeners() {
        this.itemHandlerGetter.get().unregisterStackKeyListeners();
    }

    public boolean hasEmptySlots() {
        return this.itemHandlerGetter.get().hasEmptySlots();
    }

    public int getInternalSlotLimit(int slot) {
        return this.itemHandlerGetter.get().getInternalSlotLimit(slot);
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        this.itemHandlerGetter.get().setStackInSlot(slot, stack);
    }
}

