/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.spells.ender;

import com.gametechbc.traveloptics.api.particle.CircleParticleManager;
import com.gametechbc.traveloptics.api.particle.ParticleDirection;
import com.gametechbc.traveloptics.effects.VortexPunchEffect;
import com.gametechbc.traveloptics.init.TravelopticsEffects;
import com.gametechbc.traveloptics.spells.TravelopticsSpellAnimations;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.effect.Void_Vortex_Entity;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.TargetEntityCastData;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class VortexPunchSpell
extends AbstractSpell {
    private final ResourceLocation spellId = new ResourceLocation("traveloptics", "vortex_punch");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(3).setCooldownSeconds(18.0).build();

    public VortexPunchSpell() {
        this.manaCostPerLevel = 70;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 15;
        this.baseManaCost = 70;
    }

    public CastType getCastType() {
        return CastType.LONG;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.ELDRITCH_BLAST.get());
    }

    public AnimationHolder getCastStartAnimation() {
        return TravelopticsSpellAnimations.VORTEX_PUNCH_CHARGE;
    }

    public AnimationHolder getCastFinishAnimation() {
        return TravelopticsSpellAnimations.VORTEX_PUNCH;
    }

    public boolean canBeInterrupted(@Nullable Player player) {
        return false;
    }

    public int getEffectiveCastTime(int spellLevel, @Nullable LivingEntity entity) {
        return this.getCastTime(spellLevel);
    }

    public void onServerCastTick(Level level, int spellLevel, LivingEntity entity, @Nullable MagicData playerMagicData) {
        CircleParticleManager.spawnParticles(level, entity, 30, ParticleHelper.UNSTABLE_ENDER, ParticleDirection.INWARD, 3.0, false);
    }

    public boolean checkPreCastConditions(Level level, int spellLevel, LivingEntity caster, MagicData playerMagicData) {
        return Utils.preCastTargetHelper((Level)level, (LivingEntity)caster, (MagicData)playerMagicData, (AbstractSpell)this, (int)20, (float)0.2f);
    }

    public void onCast(Level level, int spellLevel, LivingEntity caster, CastSource castSource, MagicData playerMagicData) {
        TargetEntityCastData targetData;
        LivingEntity targetEntity;
        ICastData iCastData = playerMagicData.getAdditionalCastData();
        if (iCastData instanceof TargetEntityCastData && (targetEntity = (targetData = (TargetEntityCastData)iCastData).getTarget((ServerLevel)level)) != null) {
            Void_Vortex_Entity vortexEntity = new Void_Vortex_Entity(level, targetEntity.m_20185_(), targetEntity.m_20186_(), targetEntity.m_20189_(), caster.m_146908_(), caster, this.getDuration() + 10);
            vortexEntity.setOwner(caster);
            level.m_7967_((Entity)vortexEntity);
            double pullRadius = 3.5;
            List nearbyEntities = level.m_6249_((Entity)targetEntity, targetEntity.m_20191_().m_82400_(pullRadius), arg_0 -> VortexPunchSpell.lambda$onCast$0((Entity)targetEntity, arg_0));
            for (Entity nearbyEntity : nearbyEntities) {
                Vec3 direction = targetEntity.m_20182_().m_82546_(nearbyEntity.m_20182_()).m_82541_().m_82490_(1.0);
                nearbyEntity.m_20256_(nearbyEntity.m_20184_().m_82549_(direction));
            }
            CircleParticleManager.spawnParticles(level, caster, 50, (ParticleOptions)ParticleTypes.f_123777_, ParticleDirection.OUTWARD, 3.0, false);
            ScreenShake_Entity.ScreenShake((Level)level, (Vec3)caster.m_20182_(), (float)15.0f, (float)0.02f, (int)10, (int)20);
            int duration = this.getDuration();
            int amplifier = 24;
            VortexPunchEffect effect = (VortexPunchEffect)((Object)TravelopticsEffects.VORTEX_PUNCH.get());
            effect.setDamage(this.getDamage(spellLevel, caster));
            caster.m_7292_(new MobEffectInstance((MobEffect)effect, duration, amplifier, false, false, false));
        }
        super.onCast(level, spellLevel, caster, castSource, playerMagicData);
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.m_237110_((String)"ui.traveloptics.aoe_damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.m_237110_((String)"ui.traveloptics.range", (Object[])new Object[]{Utils.stringTruncation((double)20.0, (int)2)}), Component.m_237113_((String)"\u00a79T.O Magic 'n Extras"));
    }

    public int getDuration() {
        return 25;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return 10.0f + this.getSpellPower(spellLevel, (Entity)caster) * 10.0f;
    }

    private static /* synthetic */ boolean lambda$onCast$0(Entity targetEntity, Entity entity) {
        return entity instanceof LivingEntity && entity != targetEntity;
    }
}

