/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.projectiles.dragon_spirit_spell_entity;

import com.gametechbc.traveloptics.entity.projectiles.StellarTrailAoeEntity;
import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DragonSpiritSpellEntity
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private float hpBasedDamagePercent = 0.0f;
    private int age;
    private final RawAnimation ANIMATION_LOOP = RawAnimation.begin().thenLoop("dragon_spirit_projectile_move_1");
    private final AnimationController<DragonSpiritSpellEntity> controller = new AnimationController((GeoAnimatable)this, "dragon_controller", 0, this::animationPredicate);

    public DragonSpiritSpellEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
        this.f_19811_ = true;
    }

    public DragonSpiritSpellEntity(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)TravelopticsEntities.DRAGON_SPIRIT_SPELL_ENTITY.get()), pLevel);
        this.m_5602_((Entity)pShooter);
        this.f_19811_ = true;
    }

    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("HpBonusPercent", this.hpBasedDamagePercent);
        tag.m_128405_("Age", this.age);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.hpBasedDamagePercent = tag.m_128457_("HpBonusPercent");
        this.age = tag.m_128451_("Age");
    }

    public void setHpBasedDamagePercent(float percent) {
        this.hpBasedDamagePercent = percent;
    }

    public float getHpBasedDamagePercent() {
        return this.hpBasedDamagePercent;
    }

    public void shoot(Vec3 rotation) {
        this.m_20256_(rotation.m_82490_(0.27));
    }

    public void m_8119_() {
        float pitch;
        super.m_8119_();
        ++this.age;
        if (this.age == 1) {
            this.m_5496_((SoundEvent)TravelopticsSounds.DRAGON_SPIRIT_AMBIENT.get(), 2.0f, 1.0f);
        }
        if (this.age == 100) {
            pitch = 0.9f + this.f_19796_.m_188501_() * 0.3f;
            this.m_5496_((SoundEvent)TravelopticsSounds.DRAGON_SPIRIT_SPAWN.get(), 2.0f, pitch);
        }
        if (this.age == 199) {
            pitch = 0.9f + this.f_19796_.m_188501_() * 0.3f;
            this.m_5496_((SoundEvent)TravelopticsSounds.DRAGON_SPIRIT_AMBIENT.get(), 3.0f, pitch);
            if (!this.m_9236_().f_46443_) {
                MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)TravelopticsParticleHelper.ABYSS_SPIKE_PARTICLE, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)100, (double)0.5, (double)0.5, (double)0.5, (double)0.02, (boolean)true);
            }
        }
        if (!this.m_9236_().f_46443_ && this.age % 30 == 0) {
            CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(30, this.m_20182_(), 15.0f));
        }
        if (this.age >= 200) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ % 6 == 0) {
                HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
                if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                    this.m_8060_((BlockHitResult)hitresult);
                }
                for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_())) {
                    LivingEntity target;
                    if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity) == this.m_19749_()) continue;
                    float baseDamage = this.damage;
                    float bonusDamage = target.m_21233_() * this.getHpBasedDamagePercent();
                    float totalDamage = baseDamage + bonusDamage;
                    DamageSources.applyDamage((Entity)target, (float)totalDamage, (DamageSource)((AbstractSpell)TravelopticsSpells.SHEAR_OF_THE_STARS_SPELL.get()).getDamageSource((Entity)this, this.m_19749_()));
                    DamageSources.ignoreNextKnockback((LivingEntity)target);
                }
            }
            if (this.f_19797_ % 10 == 0) {
                AABB box = this.m_20191_();
                double randomX = box.f_82288_ + this.f_19796_.m_188500_() * (box.f_82291_ - box.f_82288_);
                double randomY = box.f_82289_ + this.f_19796_.m_188500_() * (box.f_82292_ - box.f_82289_);
                double randomZ = box.f_82290_ + this.f_19796_.m_188500_() * (box.f_82293_ - box.f_82290_);
                StellarTrailAoeEntity stellarTrail = new StellarTrailAoeEntity(this.m_9236_());
                stellarTrail.m_6034_(randomX, randomY, randomZ);
                stellarTrail.m_5602_(this.m_19749_());
                stellarTrail.setDamage(this.damage * 0.25f);
                stellarTrail.setRadius(4.0f);
                stellarTrail.setDuration(200);
                this.m_9236_().m_7967_((Entity)stellarTrail);
            }
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public void trailParticles() {
    }

    public void impactParticles(double x, double y, double z) {
    }

    public float getSpeed() {
        return 0.9f;
    }

    public Optional<SoundEvent> getImpactSound() {
        return Optional.empty();
    }

    private PlayState animationPredicate(AnimationState<DragonSpiritSpellEntity> event) {
        AnimationController controller = event.getController();
        controller.setAnimation(this.ANIMATION_LOOP);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

