/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.projectiles.dragon_spirit;

import com.gametechbc.traveloptics.init.TravelopticsEntities;
import com.gametechbc.traveloptics.init.TravelopticsSounds;
import com.gametechbc.traveloptics.init.TravelopticsSpells;
import com.gametechbc.traveloptics.util.TravelopticsParticleHelper;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.spells.AbstractMagicProjectile;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DragonSpiritEntity
extends AbstractMagicProjectile
implements GeoEntity {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> MAGIC_DAMAGE_MODE = SynchedEntityData.m_135353_(DragonSpiritEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private float hpBasedDamagePercent = 0.0f;
    private int age;
    private final RawAnimation ANIMATION_LOOP = RawAnimation.begin().thenLoop("dragon_spirit_projectile_move_1");
    private final AnimationController<DragonSpiritEntity> controller = new AnimationController((GeoAnimatable)this, "dragon_controller", 0, this::animationPredicate);

    public DragonSpiritEntity(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_20242_(true);
        this.f_19811_ = true;
    }

    public DragonSpiritEntity(Level pLevel, LivingEntity pShooter) {
        this((EntityType<? extends Projectile>)((EntityType)TravelopticsEntities.DRAGON_SPIRIT_ENTITY.get()), pLevel);
        this.m_5602_((Entity)pShooter);
        this.f_19811_ = true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MAGIC_DAMAGE_MODE, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("HpBonusPercent", this.hpBasedDamagePercent);
        tag.m_128405_("Age", this.age);
        tag.m_128379_("MagicDamageMode", this.isMagicDamageMode());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.hpBasedDamagePercent = tag.m_128457_("HpBonusPercent");
        this.age = tag.m_128451_("Age");
        if (tag.m_128441_("MagicDamageMode")) {
            this.setMagicDamageMode(tag.m_128471_("MagicDamageMode"));
        }
    }

    public boolean isMagicDamageMode() {
        return (Boolean)this.f_19804_.m_135370_(MAGIC_DAMAGE_MODE);
    }

    public void setMagicDamageMode(boolean value) {
        this.f_19804_.m_135381_(MAGIC_DAMAGE_MODE, (Object)value);
    }

    public void setHpBasedDamagePercent(float percent) {
        this.hpBasedDamagePercent = percent;
    }

    public float getHpBasedDamagePercent() {
        return this.hpBasedDamagePercent;
    }

    public void shoot(Vec3 rotation) {
        this.m_20256_(rotation.m_82490_(0.3));
    }

    public void m_8119_() {
        float pitch;
        super.m_8119_();
        ++this.age;
        if (this.age == 1) {
            this.m_5496_((SoundEvent)TravelopticsSounds.DRAGON_SPIRIT_AMBIENT.get(), 5.0f, 1.0f);
        }
        if (this.age == 100) {
            pitch = 0.9f + this.f_19796_.m_188501_() * 0.3f;
            this.m_5496_((SoundEvent)TravelopticsSounds.DRAGON_SPIRIT_SPAWN.get(), 3.0f, pitch);
        }
        if (this.age == 199) {
            pitch = 0.9f + this.f_19796_.m_188501_() * 0.3f;
            this.m_5496_((SoundEvent)TravelopticsSounds.DRAGON_SPIRIT_AMBIENT.get(), 3.0f, pitch);
            if (!this.m_9236_().f_46443_) {
                MagicManager.spawnParticles((Level)this.m_9236_(), (ParticleOptions)TravelopticsParticleHelper.ABYSS_SPIKE_PARTICLE, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (int)100, (double)0.5, (double)0.5, (double)0.5, (double)0.02, (boolean)true);
            }
        }
        if (!this.m_9236_().f_46443_ && this.age % 30 == 0) {
            CameraShakeManager.addCameraShake((CameraShakeData)new CameraShakeData(30, this.m_20182_(), 26.0f));
        }
        if (this.age >= 200) {
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 6 == 0) {
            HitResult hitresult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
            if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                this.m_8060_((BlockHitResult)hitresult);
            }
            for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_())) {
                LivingEntity target;
                if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity) == this.m_19749_()) continue;
                float baseDamage = this.damage;
                float bonusDamage = target.m_21233_() * this.getHpBasedDamagePercent();
                float totalDamage = baseDamage + bonusDamage;
                DamageSource source = this.isMagicDamageMode() ? (this.m_19749_() != null ? this.m_269291_().m_269104_((Entity)this, this.m_19749_()) : this.m_269291_().m_269425_()) : ((AbstractSpell)TravelopticsSpells.SHEAR_OF_THE_STARS_SPELL.get()).getDamageSource((Entity)this, this.m_19749_());
                DamageSources.applyDamage((Entity)target, (float)totalDamage, (DamageSource)source);
                DamageSources.ignoreNextKnockback((LivingEntity)target);
            }
        }
        if (this.m_9236_().f_46443_) {
            AABB box = this.m_20191_();
            int particleCount = 38;
            for (int i = 0; i < particleCount; ++i) {
                double x = box.f_82288_ + this.f_19796_.m_188500_() * (box.f_82291_ - box.f_82288_);
                double y = box.f_82289_ + this.f_19796_.m_188500_() * (box.f_82292_ - box.f_82289_);
                double z = box.f_82290_ + this.f_19796_.m_188500_() * (box.f_82293_ - box.f_82290_);
                Vec3 motion = this.m_20184_().m_82490_(-0.01);
                if (this.f_19796_.m_188501_() < 0.5f) {
                    this.m_9236_().m_6485_(TravelopticsParticleHelper.DRAGON_SPIRIT_LIGHT_PURPLE_GLOWING_ENCHANT, true, x, y, z, motion.f_82479_, motion.f_82480_, motion.f_82481_);
                    continue;
                }
                this.m_9236_().m_6485_(TravelopticsParticleHelper.ABYSS_SPIKE_PARTICLE, true, x, y, z, motion.f_82479_, motion.f_82480_, motion.f_82481_);
            }
        }
    }

    protected void m_8060_(BlockHitResult blockHitResult) {
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public void trailParticles() {
    }

    public void onAntiMagic(MagicData playerMagicData) {
    }

    public void impactParticles(double x, double y, double z) {
    }

    public float getSpeed() {
        return 0.9f;
    }

    public Optional<SoundEvent> getImpactSound() {
        return Optional.empty();
    }

    private PlayState animationPredicate(AnimationState<DragonSpiritEntity> event) {
        AnimationController controller = event.getController();
        controller.setAnimation(this.ANIMATION_LOOP);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{this.controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

