/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.item;

import com.gametechbc.traveloptics.api.item.curio.HeavyAttributeCurio;
import com.gametechbc.traveloptics.config.CommonConfig;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import top.theillusivec4.curios.api.SlotContext;

public abstract class AbstractWildAugment
extends HeavyAttributeCurio {
    private static final int EXPERIENCE_COST = (Integer)CommonConfig.wildExperienceCost.get();

    public AbstractWildAugment(Item.Properties properties) {
        super(properties.m_41487_(1), Map.of());
    }

    protected abstract List<AttributeEntry> getPositiveAttributeEntries();

    protected abstract List<AttributeEntry> getNegativeAttributeEntries();

    protected abstract List<AttributeEntry> getChanceAttributeEntries();

    protected abstract double getGlobalChance();

    protected abstract SoundEvent getAssignSound();

    protected abstract Component getInitialHoverText();

    protected abstract Component getAssignedHoverText();

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag itemTag = stack.m_41784_();
        if (itemTag.m_128471_("attributesAssigned")) {
            tooltip.add(this.getAssignedHoverText());
        } else {
            tooltip.add(this.getInitialHoverText());
        }
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        CompoundTag itemTag = stack.m_41784_();
        return this.getAttributesFromNBT(itemTag, uuid);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag itemTag = stack.m_41784_();
        if (!itemTag.m_128471_("attributesAssigned")) {
            if (player.f_36079_ >= EXPERIENCE_COST) {
                this.assignRandomAttributes(stack);
                itemTag.m_128379_("attributesAssigned", true);
                player.m_6756_(-EXPERIENCE_COST);
                this.playSound(level, player, this.getAssignSound());
                if (!level.f_46443_) {
                    player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.augment_wild.assigned.success"), true);
                }
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            if (!level.f_46443_) {
                player.m_5661_((Component)Component.m_237115_((String)"item.traveloptics.augment_wild.assigned.failed"), true);
            }
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    private void assignRandomAttributes(ItemStack stack) {
        Random random;
        List<AttributeEntry> possiblePositiveAttributes = this.getPositiveAttributeEntries();
        List<AttributeEntry> possibleNegativeAttributes = this.getNegativeAttributeEntries();
        List<AttributeEntry> possibleChanceAttributes = this.getChanceAttributeEntries();
        if (!possiblePositiveAttributes.isEmpty()) {
            AttributeEntry selectedPositiveEntry = this.selectRandomAttributeEntry(possiblePositiveAttributes);
            double positiveValue = this.selectRandomValue(selectedPositiveEntry.getMinValue(), selectedPositiveEntry.getMaxValue());
            this.saveAttributeToNBT(stack, selectedPositiveEntry.getAttribute(), selectedPositiveEntry.getOperation(), positiveValue, "positiveAttribute");
        }
        if (!possibleNegativeAttributes.isEmpty()) {
            AttributeEntry selectedNegativeEntry = this.selectRandomAttributeEntry(possibleNegativeAttributes);
            double negativeValue = this.selectRandomValue(selectedNegativeEntry.getMinValue(), selectedNegativeEntry.getMaxValue());
            this.saveAttributeToNBT(stack, selectedNegativeEntry.getAttribute(), selectedNegativeEntry.getOperation(), negativeValue, "negativeAttribute");
        }
        if ((random = new Random()).nextDouble() <= this.getGlobalChance() && !possibleChanceAttributes.isEmpty()) {
            AttributeEntry selectedChanceEntry = this.selectRandomAttributeEntry(possibleChanceAttributes);
            double chanceValue = this.selectRandomValue(selectedChanceEntry.getMinValue(), selectedChanceEntry.getMaxValue());
            this.saveAttributeToNBT(stack, selectedChanceEntry.getAttribute(), selectedChanceEntry.getOperation(), chanceValue, "chanceAttribute");
        }
    }

    private AttributeEntry selectRandomAttributeEntry(List<AttributeEntry> possibleAttributes) {
        double totalWeight = possibleAttributes.stream().mapToDouble(AttributeEntry::getWeight).sum();
        double randomValue = new Random().nextDouble() * totalWeight;
        for (AttributeEntry entry : possibleAttributes) {
            if (!((randomValue -= entry.getWeight()) <= 0.0)) continue;
            return entry;
        }
        return possibleAttributes.get(possibleAttributes.size() - 1);
    }

    private double selectRandomValue(double minValue, double maxValue) {
        Random random = new Random();
        return minValue + (maxValue - minValue) * random.nextDouble();
    }

    private void saveAttributeToNBT(ItemStack stack, Attribute attribute, AttributeModifier.Operation operation, double value, String tagPrefix) {
        CompoundTag tag = stack.m_41784_();
        CompoundTag attributeTag = new CompoundTag();
        attributeTag.m_128359_("attribute", ForgeRegistries.ATTRIBUTES.getKey((Object)attribute).toString());
        attributeTag.m_128359_("operation", operation.name());
        attributeTag.m_128347_("value", value);
        tag.m_128365_(tagPrefix, (Tag)attributeTag);
    }

    private Multimap<Attribute, AttributeModifier> getAttributesFromNBT(CompoundTag tag, UUID uuid) {
        ImmutableMultimap.Builder attributeBuilder = new ImmutableMultimap.Builder();
        if (tag.m_128441_("positiveAttribute")) {
            CompoundTag positiveTag = tag.m_128469_("positiveAttribute");
            this.addAttributeFromNBT((ImmutableMultimap.Builder<Attribute, AttributeModifier>)attributeBuilder, positiveTag, uuid);
        }
        if (tag.m_128441_("negativeAttribute")) {
            CompoundTag negativeTag = tag.m_128469_("negativeAttribute");
            this.addAttributeFromNBT((ImmutableMultimap.Builder<Attribute, AttributeModifier>)attributeBuilder, negativeTag, uuid);
        }
        if (tag.m_128441_("chanceAttribute")) {
            CompoundTag chanceTag = tag.m_128469_("chanceAttribute");
            this.addAttributeFromNBT((ImmutableMultimap.Builder<Attribute, AttributeModifier>)attributeBuilder, chanceTag, uuid);
        }
        return attributeBuilder.build();
    }

    private void addAttributeFromNBT(ImmutableMultimap.Builder<Attribute, AttributeModifier> attributeBuilder, CompoundTag tag, UUID uuid) {
        Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(tag.m_128461_("attribute")));
        try {
            AttributeModifier.Operation operation = AttributeModifier.Operation.valueOf((String)tag.m_128461_("operation"));
            if (attribute != null) {
                AttributeModifier modifier = new AttributeModifier(uuid, attribute.m_22087_(), tag.m_128459_("value"), operation);
                attributeBuilder.put((Object)attribute, (Object)modifier);
            }
        }
        catch (IllegalArgumentException e) {
            System.err.println("Invalid attribute modifier operation: " + tag.m_128461_("operation"));
        }
    }

    private void playSound(Level level, Player player, SoundEvent soundEvent) {
        if (!level.f_46443_ && soundEvent != null) {
            level.m_5594_(null, player.m_20183_(), soundEvent, player.m_5720_(), 1.0f, 1.0f);
        }
    }

    public Component m_7626_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128471_("attributesAssigned")) {
            return Component.m_237115_((String)(stack.m_41720_().m_5671_(stack) + ".assigned"));
        }
        return Component.m_237115_((String)(stack.m_41720_().m_5671_(stack) + ".unassigned"));
    }

    public static class AttributeEntry {
        private final Attribute attribute;
        private final AttributeModifier.Operation operation;
        private final double minValue;
        private final double maxValue;
        private final double weight;

        public AttributeEntry(Attribute attribute, AttributeModifier.Operation operation, double minValue, double maxValue, double weight) {
            this.attribute = attribute;
            this.operation = operation;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.weight = weight;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public AttributeModifier.Operation getOperation() {
            return this.operation;
        }

        public double getMinValue() {
            return this.minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }

        public double getWeight() {
            return this.weight;
        }
    }
}

