/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.hurts.sskirillss.relics.client.models.items.CurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedCurioModel;
import it.hurts.sskirillss.relics.client.models.items.SidedFPRCurioModel;
import it.hurts.sskirillss.relics.items.relics.base.IRenderableCurio;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class EnderHandItem
extends RelicItem
implements IRenderableCurio {
    @Override
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder("neutrality").maxLevel(0).build()).ability(AbilityData.builder("swap").maxLevel(10).active(CastData.builder().type(CastType.INSTANTANEOUS).castPredicate("target", (player, stack) -> {
            EntityHitResult result = EntityUtils.rayTraceEntity((Entity)player, entity -> !entity.m_5833_() && entity.m_6087_(), this.getAbilityValue((ItemStack)stack, "swap", "distance"));
            return result != null && result.m_82443_() instanceof LivingEntity;
        }).build()).stat(StatData.builder("distance").initialValue(16.0, 32.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.END).build()).build();
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (ability.equals("swap")) {
            Entity entity2;
            if (player.m_36335_().m_41519_(stack.m_41720_())) {
                return;
            }
            Level level = player.m_9236_();
            EntityHitResult result = EntityUtils.rayTraceEntity((Entity)player, entity -> !entity.m_5833_() && entity.m_6087_(), this.getAbilityValue(stack, "swap", "distance"));
            if (result == null || !((entity2 = result.m_82443_()) instanceof LivingEntity)) {
                return;
            }
            LivingEntity entity3 = (LivingEntity)entity2;
            Vec3 targetPos = player.m_20182_();
            Vec3 currentPos = entity3.m_20182_();
            player.m_6021_(currentPos.m_7096_(), currentPos.m_7098_(), currentPos.m_7094_());
            level.m_6263_(null, currentPos.m_7096_(), currentPos.m_7098_(), currentPos.m_7094_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            entity3.m_6021_(targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_());
            level.m_6263_(null, targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_(), SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            int distance = (int)Math.round(targetPos.m_82554_(currentPos));
            this.spreadExperience((LivingEntity)player, stack, 1 + Math.round((float)distance * 0.1f));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public CurioModel getModel(ItemStack stack) {
        return new SidedFPRCurioModel(stack.m_41720_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        CurioModel model = this.getModel(stack);
        if (!(model instanceof SidedCurioModel)) {
            return;
        }
        SidedCurioModel sidedModel = (SidedCurioModel)model;
        sidedModel.setSlot(slotContext.index());
        matrixStack.m_85836_();
        LivingEntity entity = slotContext.entity();
        sidedModel.m_6839_(entity, limbSwing, limbSwingAmount, partialTicks);
        sidedModel.m_6973_(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        ICurioRenderer.followBodyRotations((LivingEntity)entity, (HumanoidModel[])new HumanoidModel[]{sidedModel});
        VertexConsumer vertexconsumer = ItemRenderer.m_115184_((MultiBufferSource)renderTypeBuffer, (RenderType)RenderType.m_110431_((ResourceLocation)this.getTexture(stack)), (boolean)false, (boolean)stack.m_41790_());
        matrixStack.m_252880_(0.0f, 0.0f, -0.025f);
        sidedModel.m_7695_(matrixStack, vertexconsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStack.m_85849_();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LayerDefinition constructLayerDefinition() {
        MeshDefinition mesh = HumanoidModel.m_170681_((CubeDeformation)new CubeDeformation(0.4f), (float)0.0f);
        mesh.m_171576_().m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(-4.0f, 6.0f, -2.5f, 3.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 13).m_171480_().m_171488_(-1.0f, 6.0f, -2.5f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 0).m_171480_().m_171488_(-4.5f, 8.0f, -0.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)2.0f, (float)-0.5f));
        mesh.m_171576_().m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 6.0f, -2.5f, 3.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 13).m_171488_(-2.0f, 6.0f, -2.5f, 3.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(3.5f, 8.0f, -0.5f, 1.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)-0.5f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)32, (int)32);
    }

    @Override
    public List<String> bodyParts() {
        return Lists.newArrayList((Object[])new String[]{"right_arm", "left_arm"});
    }
}

