/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.hurts.sskirillss.relics.client.screen.base.IAutoScaledScreen;
import it.hurts.sskirillss.relics.client.screen.base.IHoverableWidget;
import it.hurts.sskirillss.relics.client.screen.base.IRelicScreenProvider;
import it.hurts.sskirillss.relics.client.screen.description.data.ExperienceParticleData;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionTextures;
import it.hurts.sskirillss.relics.client.screen.description.misc.DescriptionUtils;
import it.hurts.sskirillss.relics.client.screen.description.widgets.general.PointsPlateWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.AbilityCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.BigRelicCardWidget;
import it.hurts.sskirillss.relics.client.screen.description.widgets.relic.RelicExperienceWidget;
import it.hurts.sskirillss.relics.client.screen.utils.ParticleStorage;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class RelicDescriptionScreen
extends Screen
implements IAutoScaledScreen,
IRelicScreenProvider {
    public final Screen screen;
    public final int container;
    public final int slot;
    public ItemStack stack;
    private final int backgroundHeight = 256;
    private final int backgroundWidth = 418;

    public RelicDescriptionScreen(Player player, int container, int slot, Screen screen) {
        super((Component)Component.m_237119_());
        this.container = container;
        this.slot = slot;
        this.screen = screen;
        this.stack = DescriptionUtils.gatherRelicStack(player, slot);
    }

    protected void m_7856_() {
        Item item;
        if (this.stack == null || !((item = this.stack.m_41720_()) instanceof IRelicItem)) {
            return;
        }
        IRelicItem relic = (IRelicItem)item;
        int x = (this.f_96543_ - 418) / 2;
        int y = (this.f_96544_ - 256) / 2;
        this.m_142416_((GuiEventListener)new BigRelicCardWidget(x + 60, y + 47, this));
        this.m_142416_((GuiEventListener)new PointsPlateWidget(x + 313, y + 57, this));
        this.m_142416_((GuiEventListener)new RelicExperienceWidget(x + 127, y + 121, this));
        Set<String> abilities = relic.getRelicData().getAbilities().getAbilities().keySet();
        int cardWidth = 32;
        int containerWidth = 209;
        int count = Math.min(5, abilities.size());
        int spacing = cardWidth + 8 + 3 * (5 - count);
        int xOffset = containerWidth / 2 - (cardWidth * count + (spacing - cardWidth) * Math.max(count - 1, 0)) / 2;
        for (String ability : abilities) {
            this.m_142416_((GuiEventListener)new AbilityCardWidget(x + 77 + xOffset, y + 153, this, ability));
            xOffset += spacing;
        }
    }

    public void m_86600_() {
        super.m_86600_();
        this.stack = DescriptionUtils.gatherRelicStack((Player)this.f_96541_.f_91074_, this.slot);
        LocalPlayer player = this.f_96541_.f_91074_;
        if (player == null || this.stack == null || !(this.stack.m_41720_() instanceof IRelicItem)) {
            return;
        }
        RandomSource random = player.m_217043_();
        int x = (this.f_96543_ - 418) / 2;
        int y = (this.f_96544_ - 256) / 2;
        if (player.f_19797_ % 3 == 0) {
            ParticleStorage.addParticle(this, new ExperienceParticleData(new Color(140, random.m_188503_(50), 255), x + 73 + random.m_188503_(20), y + 73 + random.m_188503_(20), 1.5f + random.m_188501_() * 0.5f, 100 + random.m_188503_(50)));
        }
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        IRelicItem relic;
        LocalPlayer player;
        float pPartialTick;
        block8: {
            block7: {
                Item item;
                super.m_280273_(guiGraphics);
                pPartialTick = Minecraft.m_91087_().m_91296_();
                player = this.f_96541_.f_91074_;
                if (this.stack == null || !((item = this.stack.m_41720_()) instanceof IRelicItem)) break block7;
                relic = (IRelicItem)item;
                if (player != null) break block8;
            }
            return;
        }
        RelicData relicData = relic.getRelicData();
        if (relicData == null) {
            return;
        }
        int level = relic.getLevel(this.stack);
        PoseStack poseStack = guiGraphics.m_280168_();
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)DescriptionTextures.SPACE_BACKGROUND);
        int x = (this.f_96543_ - 418) / 2;
        int y = (this.f_96544_ - 256) / 2;
        int yOff = 0;
        int xOff = 0;
        RenderUtils.renderAnimatedTextureFromCenter(poseStack, (float)x + 209.0f, (float)y + 128.0f, 418.0f, 4096.0f, 418.0f, 256.0f, 1.0f, AnimationData.builder().frame(0, 2).frame(1, 2).frame(2, 2).frame(3, 2).frame(4, 2).frame(5, 2).frame(6, 2).frame(7, 2).frame(8, 2).frame(9, 2).frame(10, 2).frame(11, 2).frame(12, 2).frame(13, 2).frame(14, 2).frame(15, 2));
        RenderSystem.disableBlend();
        guiGraphics.m_280163_(DescriptionTextures.RELIC_BACKGROUND, x + 60, y + 47, 0.0f, 0.0f, 243, 90, 243, 90);
        poseStack.m_85836_();
        int quality = relic.getRelicQuality(this.stack);
        boolean isAliquot = quality % 2 == 1;
        int i = 0;
        while ((double)i < Math.floor((double)quality / 2.0)) {
            guiGraphics.m_280163_(DescriptionTextures.BIG_STAR_ACTIVE, x + xOff + 64, y + 110, 0.0f, 0.0f, 8, 7, 8, 7);
            xOff += 8;
            ++i;
        }
        if (isAliquot) {
            guiGraphics.m_280163_(DescriptionTextures.BIG_STAR_ACTIVE, x + xOff + 64, y + 110, 0.0f, 0.0f, 4, 7, 8, 7);
        }
        poseStack.m_85849_();
        poseStack.m_85836_();
        float scale = 1.75f;
        poseStack.m_85837_((double)(x + 70), (double)(y + 69) + Math.sin(((float)player.f_19797_ + pPartialTick) * 0.15f), 0.0);
        poseStack.m_85841_(scale, scale, scale);
        guiGraphics.m_280480_(this.stack, 0, 0);
        poseStack.m_85849_();
        poseStack.m_85836_();
        MutableComponent levelComponent = Component.m_237113_((String)String.valueOf(level)).m_130940_(ChatFormatting.BOLD);
        poseStack.m_85841_(0.75f, 0.75f, 1.0f);
        guiGraphics.m_280614_(this.f_96541_.f_91062_, (Component)levelComponent, (int)(((float)x + 85.5f) * 1.33f - (float)this.f_96541_.f_91062_.m_92852_((FormattedText)levelComponent) / 2.0f), (int)((float)(y + 51) * 1.33f), 16769656, true);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        guiGraphics.m_280614_(this.f_96541_.f_91062_, (Component)Component.m_237113_((String)this.stack.m_41611_().getString().replace("[", "").replace("]", "")).m_130940_(ChatFormatting.BOLD), (int)((float)(x + 113) * 1.33f), (int)((float)(y + 66) * 1.33f), 6696723, false);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        yOff = 9;
        for (FormattedCharSequence line : this.f_96541_.f_91062_.m_92923_((FormattedText)Component.m_237115_((String)("tooltip.relics." + ForgeRegistries.ITEMS.getKey((Object)this.stack.m_41720_()).m_135815_() + ".description")), 340)) {
            guiGraphics.m_280649_(this.f_96541_.f_91062_, line, (x + 112) * 2, (y + 73) * 2 + yOff, 6696723, false);
            yOff += 9;
        }
        poseStack.m_85849_();
        guiGraphics.m_280163_(DescriptionTextures.ABILITIES_BACKGROUND, x + 60, y + 133, 0.0f, 0.0f, 243, 88, 243, 88);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        for (GuiEventListener listener : this.m_6702_()) {
            AbstractButton button;
            if (!(listener instanceof AbstractButton) || !(button = (AbstractButton)listener).m_274382_() || !(button instanceof IHoverableWidget)) continue;
            IHoverableWidget widget = (IHoverableWidget)button;
            widget.onHovered(guiGraphics, pMouseX, pMouseY);
        }
    }

    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(InputConstants.m_84827_((int)pKeyCode, (int)pScanCode))) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.screen);
    }

    public boolean m_7043_() {
        return false;
    }

    @Override
    public int getAutoScale() {
        return 0;
    }

    @Override
    public int getContainer() {
        return this.container;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }
}

