/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;

public class IntBox {
    public final class_2338 l;
    public final class_2338 h;

    public IntBox(class_2338 l, class_2338 h) {
        this.l = Helper.min(l, h);
        this.h = Helper.max(l, h);
    }

    @Deprecated
    public static IntBox getBoxByBasePointAndSize(class_2338 areaSize, class_2338 blockPos) {
        return IntBox.fromBasePointAndSize(blockPos, areaSize);
    }

    public static IntBox fromBasePointAndSize(class_2338 blockPos, class_2338 areaSize) {
        return new IntBox(blockPos, blockPos.method_10081((class_2382)areaSize).method_10069(-1, -1, -1));
    }

    public IntBox expandOrShrink(class_2382 offset) {
        return new IntBox(this.l.method_10059(offset), this.h.method_10081(offset));
    }

    public IntBox getExpanded(class_2350.class_2351 axis, int n) {
        return this.expandOrShrink((class_2382)Helper.scale(class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis).method_10163(), n));
    }

    public IntBox getExpanded(class_2350 direction, int n) {
        if (direction.method_10171() == class_2350.class_2352.field_11056) {
            return new IntBox(this.l, this.h.method_10081((class_2382)Helper.scale(direction.method_10163(), n)));
        }
        return new IntBox(this.l.method_10081((class_2382)Helper.scale(direction.method_10163(), n)), this.h);
    }

    public Stream<class_2338> stream() {
        return IntStream.range(this.l.method_10263(), this.h.method_10263() + 1).boxed().flatMap(x -> IntStream.range(this.l.method_10264(), this.h.method_10264() + 1).boxed().flatMap(y -> IntStream.range(this.l.method_10260(), this.h.method_10260() + 1).boxed().map(z -> new class_2338(x.intValue(), y.intValue(), z.intValue()))));
    }

    public Stream<class_2338> fastStream() {
        return class_2338.method_20437((class_2338)this.l, (class_2338)this.h);
    }

    public class_2338 getSize() {
        return this.h.method_10069(1, 1, 1).method_10059((class_2382)this.l);
    }

    public IntBox getSurfaceLayer(class_2350.class_2351 axis, class_2350.class_2352 axisDirection) {
        if (axisDirection == class_2350.class_2352.field_11060) {
            IntBox result = new IntBox(this.l, new class_2338((axis == class_2350.class_2351.field_11048 ? this.l : this.h).method_10263(), (axis == class_2350.class_2351.field_11052 ? this.l : this.h).method_10264(), (axis == class_2350.class_2351.field_11051 ? this.l : this.h).method_10260()));
            return result;
        }
        IntBox result = new IntBox(new class_2338((axis == class_2350.class_2351.field_11048 ? this.h : this.l).method_10263(), (axis == class_2350.class_2351.field_11052 ? this.h : this.l).method_10264(), (axis == class_2350.class_2351.field_11051 ? this.h : this.l).method_10260()), this.h);
        return result;
    }

    public IntBox getSurfaceLayer(class_2350 facing) {
        return this.getSurfaceLayer(facing.method_10166(), facing.method_10171());
    }

    @Nullable
    public static IntBox getIntersect(IntBox a, IntBox b) {
        class_2338 l = Helper.max(a.l, b.l);
        class_2338 h = Helper.min(a.h, b.h);
        if (l.method_10263() > h.method_10263()) {
            return null;
        }
        if (l.method_10264() > h.method_10264()) {
            return null;
        }
        if (l.method_10260() > h.method_10260()) {
            return null;
        }
        return new IntBox(l, h);
    }

    public IntBox map(Function<class_2338, class_2338> func1, Function<class_2338, class_2338> func2) {
        return new IntBox(func1.apply(this.l), func2.apply(this.h));
    }

    public class_2338 getCenter() {
        return Helper.divide((class_2382)this.l.method_10081((class_2382)this.h), 2);
    }

    public class_243 getCenterVec() {
        return new class_243((double)(this.l.method_10263() + this.h.method_10263() + 1) / 2.0, (double)(this.l.method_10264() + this.h.method_10264() + 1) / 2.0, (double)(this.l.method_10260() + this.h.method_10260() + 1) / 2.0);
    }

    public IntBox getAdjusted(int dxa, int dya, int dza, int dxb, int dyb, int dzb) {
        return new IntBox(this.l.method_10069(dxa, dya, dza), this.h.method_10069(dxb, dyb, dzb));
    }

    public Stream<class_2338> forSixSurfaces(Function<Stream<IntBox>, Stream<IntBox>> mapper) {
        IntBox[] array = new IntBox[]{this.getSurfaceLayer(class_2350.field_11033), this.getSurfaceLayer(class_2350.field_11043).getAdjusted(0, 1, 0, 0, 0, 0), this.getSurfaceLayer(class_2350.field_11035).getAdjusted(0, 1, 0, 0, 0, 0), this.getSurfaceLayer(class_2350.field_11039).getAdjusted(0, 1, 1, 0, 0, -1), this.getSurfaceLayer(class_2350.field_11034).getAdjusted(0, 1, 1, 0, 0, -1), this.getSurfaceLayer(class_2350.field_11036).getAdjusted(1, 0, 1, -1, 0, -1)};
        return mapper.apply(Arrays.stream(array).filter(intBox -> true)).flatMap(IntBox::stream);
    }

    public IntBox getMoved(class_2382 offset) {
        return new IntBox(this.l.method_10081(offset), this.h.method_10081(offset));
    }

    public static IntBox getContainingBox(IntBox box1, IntBox box2) {
        return new IntBox(Helper.min(box1.l, box2.l), Helper.max(box1.h, box2.h));
    }

    public IntBox getSubBoxInCenter(class_2338 subBoxSize) {
        class_2338 thisSize = this.getSize();
        Validate.isTrue((thisSize.method_10263() >= subBoxSize.method_10263() ? 1 : 0) != 0);
        Validate.isTrue((thisSize.method_10264() >= subBoxSize.method_10264() ? 1 : 0) != 0);
        Validate.isTrue((thisSize.method_10260() >= subBoxSize.method_10260() ? 1 : 0) != 0);
        return IntBox.fromBasePointAndSize(Helper.divide((class_2382)thisSize.method_10059((class_2382)subBoxSize), 2).method_10081((class_2382)this.l), subBoxSize);
    }

    public class_2338[] getEightVertices() {
        return new class_2338[]{new class_2338(this.l.method_10263(), this.l.method_10264(), this.l.method_10260()), new class_2338(this.l.method_10263(), this.l.method_10264(), this.h.method_10260()), new class_2338(this.l.method_10263(), this.h.method_10264(), this.l.method_10260()), new class_2338(this.l.method_10263(), this.h.method_10264(), this.h.method_10260()), new class_2338(this.h.method_10263(), this.l.method_10264(), this.l.method_10260()), new class_2338(this.h.method_10263(), this.l.method_10264(), this.h.method_10260()), new class_2338(this.h.method_10263(), this.h.method_10264(), this.l.method_10260()), new class_2338(this.h.method_10263(), this.h.method_10264(), this.h.method_10260())};
    }

    public class_238 toRealNumberBox() {
        return new class_238((double)this.l.method_10263(), (double)this.l.method_10264(), (double)this.l.method_10260(), (double)(this.h.method_10263() + 1), (double)(this.h.method_10264() + 1), (double)(this.h.method_10260() + 1));
    }

    public IntBox getExpanded(class_2338 newPoint) {
        return new IntBox(Helper.min(this.l, newPoint), Helper.max(this.h, newPoint));
    }

    public boolean contains(class_2338 pos) {
        return pos.method_10263() >= this.l.method_10263() && pos.method_10263() <= this.h.method_10263() && pos.method_10264() >= this.l.method_10264() && pos.method_10264() <= this.h.method_10264() && pos.method_10260() >= this.l.method_10260() && pos.method_10260() <= this.h.method_10260();
    }

    public class_2338 selectCoordinateFromBox(boolean high) {
        return high ? this.h : this.l;
    }

    public IntBox[] get12Edges() {
        return new IntBox[]{new IntBox(this.selectCoordinateFromBox(false, false, false), this.selectCoordinateFromBox(false, false, true)), new IntBox(this.selectCoordinateFromBox(false, true, false), this.selectCoordinateFromBox(false, true, true)), new IntBox(this.selectCoordinateFromBox(true, false, false), this.selectCoordinateFromBox(true, false, true)), new IntBox(this.selectCoordinateFromBox(true, true, false), this.selectCoordinateFromBox(true, true, true)), new IntBox(this.selectCoordinateFromBox(false, false, false), this.selectCoordinateFromBox(false, true, false)), new IntBox(this.selectCoordinateFromBox(false, false, true), this.selectCoordinateFromBox(false, true, true)), new IntBox(this.selectCoordinateFromBox(true, false, false), this.selectCoordinateFromBox(true, true, false)), new IntBox(this.selectCoordinateFromBox(true, false, true), this.selectCoordinateFromBox(true, true, true)), new IntBox(this.selectCoordinateFromBox(false, false, false), this.selectCoordinateFromBox(true, false, false)), new IntBox(this.selectCoordinateFromBox(false, false, true), this.selectCoordinateFromBox(true, false, true)), new IntBox(this.selectCoordinateFromBox(false, true, false), this.selectCoordinateFromBox(true, true, false)), new IntBox(this.selectCoordinateFromBox(false, true, true), this.selectCoordinateFromBox(true, true, true))};
    }

    public class_2338 selectCoordinateFromBox(boolean xUp, boolean yUp, boolean zUp) {
        return new class_2338(this.selectCoordinateFromBox(xUp).method_10263(), this.selectCoordinateFromBox(yUp).method_10264(), this.selectCoordinateFromBox(zUp).method_10260());
    }

    public static IntBox getBoxByPosAndSignedSize(class_2338 basePos, class_2338 signedSize) {
        return new IntBox(basePos, new class_2338(IntBox.getEndCoordWithSignedSize(basePos.method_10263(), signedSize.method_10263()), IntBox.getEndCoordWithSignedSize(basePos.method_10264(), signedSize.method_10264()), IntBox.getEndCoordWithSignedSize(basePos.method_10260(), signedSize.method_10260())));
    }

    private static int getEndCoordWithSignedSize(int base, int signedSize) {
        if (signedSize > 0) {
            return base + signedSize - 1;
        }
        if (signedSize < 0) {
            return base + signedSize + 1;
        }
        throw new IllegalArgumentException("Signed size cannot be zero");
    }

    public boolean isOnSurface(class_2338 pos) {
        boolean xOnEnd = pos.method_10263() == this.l.method_10263() || pos.method_10263() == this.h.method_10263();
        boolean yOnEnd = pos.method_10264() == this.l.method_10264() || pos.method_10264() == this.h.method_10264();
        boolean zOnEnd = pos.method_10260() == this.l.method_10260() || pos.method_10260() == this.h.method_10260();
        return xOnEnd || yOnEnd || zOnEnd;
    }

    public boolean isOnEdge(class_2338 pos) {
        boolean xOnEnd = pos.method_10263() == this.l.method_10263() || pos.method_10263() == this.h.method_10263();
        boolean yOnEnd = pos.method_10264() == this.l.method_10264() || pos.method_10264() == this.h.method_10264();
        boolean zOnEnd = pos.method_10260() == this.l.method_10260() || pos.method_10260() == this.h.method_10260();
        return xOnEnd && yOnEnd || yOnEnd && zOnEnd || zOnEnd && xOnEnd;
    }

    public boolean isOnVertex(class_2338 pos) {
        boolean xOnEnd = pos.method_10263() == this.l.method_10263() || pos.method_10263() == this.h.method_10263();
        boolean yOnEnd = pos.method_10264() == this.l.method_10264() || pos.method_10264() == this.h.method_10264();
        boolean zOnEnd = pos.method_10260() == this.l.method_10260() || pos.method_10260() == this.h.method_10260();
        return xOnEnd && yOnEnd && zOnEnd;
    }

    public class_2487 toTag() {
        class_2487 tag = new class_2487();
        tag.method_10569("lX", this.l.method_10263());
        tag.method_10569("lY", this.l.method_10264());
        tag.method_10569("lZ", this.l.method_10260());
        tag.method_10569("hX", this.h.method_10263());
        tag.method_10569("hY", this.h.method_10264());
        tag.method_10569("hZ", this.h.method_10260());
        return tag;
    }

    public static IntBox fromTag(class_2487 tag) {
        return new IntBox(new class_2338(tag.method_10550("lX"), tag.method_10550("lY"), tag.method_10550("lZ")), new class_2338(tag.method_10550("hX"), tag.method_10550("hY"), tag.method_10550("hZ")));
    }

    public String toString() {
        return String.format("(%d %d %d)-(%d %d %d)", this.l.method_10263(), this.l.method_10264(), this.l.method_10260(), this.h.method_10263(), this.h.method_10264(), this.h.method_10260());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntBox intBox = (IntBox)o;
        return this.l.equals((Object)intBox.l) && this.h.equals((Object)intBox.h);
    }

    public int hashCode() {
        return Objects.hash(this.l, this.h);
    }
}

