/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Validate;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;

public class ExtraDimensionStorage {
    public static void init() {
        DimensionAPI.serverDimensionsLoadEvent.register(ExtraDimensionStorage::loadExtraDimensions);
    }

    private static void loadExtraDimensions(class_5285 worldOptions, class_5455 registryAccess) {
        MinecraftServer server = MiscHelper.getServer();
        if (server != null && server.method_3806()) {
            class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
            class_2378 dimensionRegistry = registryAccess.method_30530(class_7924.field_41224);
            Path extraStorageFolderPath = ExtraDimensionStorage.getExtraStorageFolderPath();
            File[] subFiles = extraStorageFolderPath.toFile().listFiles();
            if (subFiles != null) {
                for (File nameSpace : subFiles) {
                    if (!nameSpace.isDirectory()) continue;
                    for (File file : nameSpace.listFiles()) {
                        class_2960 id = new class_2960(nameSpace.getName(), FilenameUtils.getBaseName((String)file.getName()));
                        ExtraDimensionStorage.readFile((class_6903<JsonElement>)ops, (class_2378<class_5363>)dimensionRegistry, file, id);
                    }
                }
            }
        }
    }

    private static void readFile(class_6903<JsonElement> ops, class_2378<class_5363> dimensionRegistry, File file, class_2960 id) {
        try {
            JsonElement jsonElement;
            try (FileReader fileReader = new FileReader(file);){
                jsonElement = JsonParser.parseReader((Reader)fileReader);
            }
            DataResult r = class_5363.field_25411.decode(ops, (Object)jsonElement);
            Either either = r.get();
            if (either.left().isPresent()) {
                class_5363 levelStem = (class_5363)((Pair)either.left().get()).getFirst();
                DimensionAPI.addDimension(dimensionRegistry, id, (class_6880<class_2874>)levelStem.comp_1012(), levelStem.comp_1013());
            } else {
                Helper.err("Cannot deserialize extra dimension");
                Helper.err(either.right());
            }
        }
        catch (Throwable e) {
            Helper.err("Error loading extra dimension " + id);
            e.printStackTrace();
        }
    }

    private static Path getExtraStorageFolderPath() {
        Path savingDirectory = MiscHelper.getWorldSavingDirectory();
        return savingDirectory.resolve("q_dimension_configs");
    }

    private static File getExtraStorageFile(class_2960 location) {
        Path filePath = ExtraDimensionStorage.getExtraStorageFolderPath().resolve(location.method_12836()).resolve(location.method_12832() + ".json");
        return filePath.toFile();
    }

    public static void saveDimensionIntoExtraStorage(class_5321<class_1937> dimension) {
        MinecraftServer server = MiscHelper.getServer();
        class_5455.class_6890 registryAccess = server.method_30611();
        class_3218 world = server.method_3847(dimension);
        Validate.notNull((Object)world);
        class_5363 levelStem = new class_5363(world.method_40134(), world.method_14178().method_12129());
        File file = ExtraDimensionStorage.getExtraStorageFile(dimension.method_29177());
        try {
            if (!file.exists()) {
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
            }
            try (FileWriter fileWriter = new FileWriter(file);){
                class_6903 ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)registryAccess);
                DataResult r = class_5363.field_25411.encode((Object)levelStem, (DynamicOps)ops, (Object)new JsonObject());
                Either either = r.get();
                JsonElement result = either.left().orElse(null);
                if (result != null) {
                    Helper.gson.toJson(result, (Appendable)fileWriter);
                } else {
                    Helper.err("Cannot serialize extra dimension");
                    Helper.err(either.right().map(DataResult.PartialResult::toString).orElse(""));
                }
            }
        }
        catch (IOException e) {
            Helper.err("Cannot save extra dimension");
            e.printStackTrace();
        }
    }

    public static boolean removeDimensionFromExtraStorage(class_5321<class_1937> dimension) {
        File file = ExtraDimensionStorage.getExtraStorageFile(dimension.method_29177());
        if (file.exists()) {
            file.delete();
            return true;
        }
        return false;
    }
}

