/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Lifecycle;
import java.io.IOException;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_27;
import net.minecraft.class_2780;
import net.minecraft.class_2784;
import net.minecraft.class_2806;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3949;
import net.minecraft.class_4543;
import net.minecraft.class_5219;
import net.minecraft.class_5268;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscGlobals;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.MiscNetworking;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.dimension.DimensionIdManagement;
import qouteall.q_misc_util.ducks.IEMappedRegistry2;
import qouteall.q_misc_util.ducks.IEMinecraftServer_Misc;
import qouteall.q_misc_util.mixin.dimension.IEMappedRegistry;
import qouteall.q_misc_util.mixin.dimension.IEWorldBorder;
import qouteall.q_misc_util.my_util.MyTaskList;
import qouteall.q_misc_util.my_util.SignalArged;

public class DynamicDimensionsImpl {
    public static final SignalArged<class_5321<class_1937>> beforeRemovingDimensionSignal = new SignalArged();
    public static boolean isRemovingDimension = false;

    public static void init() {
    }

    public static void addDimensionDynamically(class_2960 dimensionId, class_5363 levelStem) {
        MinecraftServer server = MiscHelper.getServer();
        class_5321<class_1937> dimensionResourceKey = DimId.idToKey(dimensionId);
        Validate.isTrue((boolean)server.method_18854());
        if (server.method_3847(dimensionResourceKey) != null) {
            throw new RuntimeException("Dimension " + dimensionId + " already exists.");
        }
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        class_2784 worldBorder = overworld.method_8621();
        Validate.notNull((Object)worldBorder);
        class_5219 worldData = server.method_27728();
        class_5268 serverLevelData = worldData.method_27859();
        long seed = worldData.method_28057().method_28028();
        long obfuscatedSeed = class_4543.method_27984((long)seed);
        class_27 derivedLevelData = new class_27(worldData, serverLevelData);
        class_3218 newWorld = new class_3218(server, ((IEMinecraftServer_Misc)server).ip_getExecutor(), ((IEMinecraftServer_Misc)server).ip_getStorageSource(), (class_5268)derivedLevelData, dimensionResourceKey, levelStem, (class_3949)new DummyProgressListener(), false, obfuscatedSeed, (List)ImmutableList.of(), false, overworld.method_52168());
        worldBorder.method_11983((class_2780)new class_2780.class_3976(newWorld.method_8621()));
        ((IEMinecraftServer_Misc)server).ip_addDimensionToWorldMap(dimensionResourceKey, newWorld);
        class_2378 levelStemRegistry = server.method_30611().method_30530(class_7924.field_41224);
        ((IEMappedRegistry)levelStemRegistry).ip_setIsFrozen(false);
        ((class_2370)levelStemRegistry).method_10272(class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)dimensionId), (Object)levelStem, Lifecycle.stable());
        ((IEMappedRegistry)levelStemRegistry).ip_setIsFrozen(true);
        worldBorder.method_17905(serverLevelData.method_27422());
        Helper.log("Added Dimension " + dimensionId);
        DimensionIdManagement.updateAndSaveServerDimIdRecord();
        class_2596 dimSyncPacket = MiscNetworking.createDimSyncPacket();
        for (class_3222 player : server.method_3760().method_14571()) {
            player.field_13987.method_14364(dimSyncPacket);
        }
        ((DimensionAPI.DynamicUpdateListener)DimensionAPI.serverDimensionDynamicUpdateEvent.invoker()).run(server.method_29435());
    }

    public static void removeDimensionDynamically(class_3218 world) {
        MinecraftServer server = MiscHelper.getServer();
        Validate.isTrue((boolean)server.method_18854());
        class_5321 dimension = world.method_27983();
        if (dimension == class_1937.field_25179 || dimension == class_1937.field_25180 || dimension == class_1937.field_25181) {
            throw new RuntimeException();
        }
        Helper.log("Started Removing Dimension " + dimension.method_29177());
        MiscGlobals.serverTaskList.addTask(MyTaskList.oneShotTask(() -> {
            beforeRemovingDimensionSignal.emit((class_5321<class_1937>)dimension);
            DynamicDimensionsImpl.evacuatePlayersFromDimension(world);
            long startTime = System.nanoTime();
            long lastLogTime = System.nanoTime();
            isRemovingDimension = true;
            ((IEMinecraftServer_Misc)server).ip_removeDimensionFromWorldMap((class_5321<class_1937>)dimension);
            try {
                while (world.method_14178().field_17254.method_39992()) {
                    world.method_14178().method_39997();
                    world.method_14178().method_12127(() -> true, false);
                    world.method_14178().method_19492();
                    server.method_16075();
                    if (System.nanoTime() - lastLogTime > Helper.secondToNano(1.0)) {
                        lastLogTime = System.nanoTime();
                        Helper.log("waiting for chunk tasks to finish");
                    }
                    if (System.nanoTime() - startTime > Helper.secondToNano(15.0)) {
                        Helper.err("Waited too long for chunk tasks");
                        break;
                    }
                    ((IEMinecraftServer_Misc)server).ip_waitUntilNextTick();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            isRemovingDimension = false;
            Helper.log("Finished chunk tasks in %f seconds".formatted(Helper.nanoToSecond(System.nanoTime() - startTime)));
            Helper.log("Chunk num:%d Has entities:%s".formatted(world.method_14178().field_17254.method_17260(), world.method_27909().iterator().hasNext()));
            server.method_3723(false, true, false);
            try {
                world.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DynamicDimensionsImpl.resetWorldBorderListener(server);
            class_2378 levelStemRegistry = server.method_30611().method_30530(class_7924.field_41224);
            ((IEMappedRegistry2)levelStemRegistry).ip_forceRemove(dimension.method_29177());
            Helper.log("Successfully Removed Dimension " + dimension.method_29177());
            class_2596 dimSyncPacket = MiscNetworking.createDimSyncPacket();
            for (class_3222 player : server.method_3760().method_14571()) {
                player.field_13987.method_14364(dimSyncPacket);
            }
            ((DimensionAPI.DynamicUpdateListener)DimensionAPI.serverDimensionDynamicUpdateEvent.invoker()).run(server.method_29435());
        }));
    }

    private static void resetWorldBorderListener(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        class_2784 worldBorder = overworld.method_8621();
        List<class_2780> borderChangeListeners = ((IEWorldBorder)worldBorder).ip_getListeners();
        borderChangeListeners.clear();
        for (class_3218 serverWorld : server.method_3738()) {
            if (serverWorld == overworld) continue;
            worldBorder.method_11983((class_2780)new class_2780.class_3976(serverWorld.method_8621()));
        }
        server.method_3760().method_14591(overworld);
    }

    private static void evacuatePlayersFromDimension(class_3218 world) {
        MinecraftServer server = MiscHelper.getServer();
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        List players = world.method_18766(p -> true);
        class_2338 sharedSpawnPos = overworld.method_43126();
        for (class_3222 player : players) {
            player.method_14251(overworld, (double)sharedSpawnPos.method_10263(), (double)sharedSpawnPos.method_10264(), (double)sharedSpawnPos.method_10260(), 0.0f, 0.0f);
            player.method_43496((class_2561)class_2561.method_43470((String)"Teleported to spawn pos because dimension %s had been removed".formatted(world.method_27983().method_29177())));
        }
    }

    private static class DummyProgressListener
    implements class_3949 {
        private DummyProgressListener() {
        }

        public void method_17669(class_1923 center) {
        }

        public void method_17670(class_1923 chunkPosition, @Nullable class_2806 newStatus) {
        }

        public void method_17675() {
        }

        public void method_17671() {
        }
    }
}

