/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.common.collect.Streams;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7134;
import net.minecraft.class_7924;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimId;

public class DimensionTypeSync {
    @Environment(value=EnvType.CLIENT)
    public static Map<class_5321<class_1937>, class_5321<class_2874>> clientTypeMap;
    @Environment(value=EnvType.CLIENT)
    private static class_5455 currentDimensionTypeTracker;

    @Environment(value=EnvType.CLIENT)
    public static void onGameJoinPacketReceived(class_5455 tracker) {
        currentDimensionTypeTracker = tracker;
    }

    @Environment(value=EnvType.CLIENT)
    private static Map<class_5321<class_1937>, class_5321<class_2874>> typeMapFromTag(class_2487 tag) {
        HashMap<class_5321<class_1937>, class_5321<class_2874>> result = new HashMap<class_5321<class_1937>, class_5321<class_2874>>();
        tag.method_10541().forEach(key -> {
            class_5321<class_1937> worldKey = DimId.idToKey(key);
            String val = tag.method_10558(key);
            class_5321 typeKey = class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)new class_2960(val));
            result.put(worldKey, typeKey);
        });
        return result;
    }

    @Environment(value=EnvType.CLIENT)
    public static void acceptTypeMapData(class_2487 tag) {
        clientTypeMap = DimensionTypeSync.typeMapFromTag(tag);
        Helper.log("Received Dimension Type Sync");
        Helper.log("\n" + Helper.myToString(clientTypeMap.entrySet().stream().map(e -> ((class_5321)e.getKey()).method_29177().toString() + " -> " + ((class_5321)e.getValue()).method_29177())));
    }

    public static class_2487 createTagFromServerWorldInfo() {
        class_5455.class_6890 registryManager = MiscHelper.getServer().method_30611();
        class_2378 dimensionTypes = registryManager.method_30530(class_7924.field_41241);
        return DimensionTypeSync.typeMapToTag(Streams.stream((Iterable)MiscHelper.getServer().method_3738()).collect(Collectors.toMap(class_1937::method_27983, w -> {
            class_2874 dimensionType = w.method_8597();
            class_2960 id = dimensionTypes.method_10221((Object)dimensionType);
            if (id == null) {
                Helper.err("Missing dim type id for " + w.method_27983());
                Helper.err("Registered dimension types " + Helper.myToString(dimensionTypes.method_10235().stream()));
                return class_7134.field_37666;
            }
            return DimensionTypeSync.idToDimType(id);
        })));
    }

    public static class_5321<class_2874> idToDimType(class_2960 id) {
        return class_5321.method_29179((class_5321)class_7924.field_41241, (class_2960)id);
    }

    private static class_2487 typeMapToTag(Map<class_5321<class_1937>, class_5321<class_2874>> data) {
        class_2487 tag = new class_2487();
        data.forEach((worldKey, typeKey) -> tag.method_10566(worldKey.method_29177().toString(), (class_2520)class_2519.method_23256((String)typeKey.method_29177().toString())));
        return tag;
    }

    @Environment(value=EnvType.CLIENT)
    public static class_5321<class_2874> getDimensionTypeKey(class_5321<class_1937> worldKey) {
        class_5321<class_2874> obj = clientTypeMap.get(worldKey);
        if (obj == null) {
            Helper.err("Missing Dimension Type For " + worldKey.method_29177());
            return class_7134.field_37666;
        }
        return obj;
    }

    @Environment(value=EnvType.CLIENT)
    public static class_2874 getDimensionType(class_5321<class_2874> registryKey) {
        return (class_2874)currentDimensionTypeTracker.method_30530(class_7924.field_41241).method_29107(registryKey);
    }
}

