/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.dimension.DimId;

public class DimensionIdRecord {
    public static DimensionIdRecord clientRecord;
    public static DimensionIdRecord serverRecord;
    final BiMap<class_5321<class_1937>, Integer> idMap;
    final BiMap<Integer, class_5321<class_1937>> inverseMap;

    public DimensionIdRecord(BiMap<class_5321<class_1937>, Integer> data) {
        this.idMap = data;
        this.inverseMap = data.inverse();
    }

    public class_5321<class_1937> getDim(int integerId) {
        class_5321 result = (class_5321)this.inverseMap.get((Object)integerId);
        if (result == null) {
            throw new RuntimeException("Missing Dimension " + integerId);
        }
        return result;
    }

    @Nullable
    public class_5321<class_1937> getDimFromIntOptional(int integerId) {
        return (class_5321)this.inverseMap.get((Object)integerId);
    }

    public int getIntId(class_5321<class_1937> dim) {
        Integer result = (Integer)this.idMap.get(dim);
        if (result == null) {
            throw new RuntimeException("Missing Dimension " + dim.method_29177());
        }
        return result;
    }

    public String toString() {
        return this.idMap.entrySet().stream().sorted(Comparator.comparingInt(e -> (Integer)e.getValue())).map(e -> ((class_5321)e.getKey()).method_29177().toString() + " -> " + e.getValue()).collect(Collectors.joining("\n"));
    }

    public static DimensionIdRecord tagToRecord(class_2487 tag) {
        class_2487 intids = tag.method_10562("intids");
        if (intids == null) {
            return null;
        }
        HashBiMap bimap = HashBiMap.create();
        intids.method_10541().forEach(dim -> {
            if (intids.method_10545(dim)) {
                int intid = intids.method_10550(dim);
                bimap.put(DimId.idToKey(dim), (Object)intid);
            }
        });
        return new DimensionIdRecord((BiMap<class_5321<class_1937>, Integer>)bimap);
    }

    public static class_2487 recordToTag(DimensionIdRecord record, Predicate<class_5321<class_1937>> filter) {
        class_2487 intids = new class_2487();
        record.idMap.forEach((key, intid) -> {
            if (filter.test((class_5321<class_1937>)key)) {
                intids.method_10566(key.method_29177().toString(), (class_2520)class_2497.method_23247((int)intid));
            }
        });
        class_2487 result = new class_2487();
        result.method_10566("intids", (class_2520)intids);
        return result;
    }

    public Set<class_5321<class_1937>> getDimIdSet() {
        return new HashSet<class_5321<class_1937>>(this.idMap.keySet());
    }
}

