/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.dimension;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_5321;
import qouteall.q_misc_util.Helper;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.dimension.DimensionIdRecord;

public class DimensionIdManagement {
    public static void onServerStarted() {
        DimensionIdRecord ipRecord = DimensionIdManagement.readIPDimensionRegistry();
        if (ipRecord == null) {
            Helper.log("Immersive Portals' dimension id record is missing");
            DimensionIdRecord.serverRecord = null;
        } else {
            DimensionIdRecord.serverRecord = ipRecord;
            Helper.log("Successfully read IP's dimension id record");
        }
        DimensionIdManagement.updateAndSaveServerDimIdRecord();
    }

    public static void updateAndSaveServerDimIdRecord() {
        DimensionIdManagement.completeServerIdRecord();
        try {
            File file = DimensionIdManagement.getIPDimIdFile();
            FileOutputStream fileInputStream = new FileOutputStream(file);
            class_2487 tag = DimensionIdRecord.recordToTag(DimensionIdRecord.serverRecord, dim -> true);
            class_2507.method_10634((class_2487)tag, (OutputStream)fileInputStream);
            Helper.log("Dimension Id Info Saved to File");
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot Save Immersive Portals Dimension Id Info", e);
        }
    }

    private static DimensionIdRecord readIPDimensionRegistry() {
        File dataFile = DimensionIdManagement.getIPDimIdFile();
        if (!dataFile.exists()) {
            Helper.log("Immersive Portals' Dimension Id Record File Does Not Exist");
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(dataFile);
            class_2487 tag = class_2507.method_10629((InputStream)fileInputStream);
            fileInputStream.close();
            return DimensionIdRecord.tagToRecord(tag);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static File getIPDimIdFile() {
        Path saveDir = MiscHelper.getWorldSavingDirectory();
        return new File(new File(saveDir.toFile(), "data"), "imm_ptl_dim_reg.dat");
    }

    private static void completeServerIdRecord() {
        if (DimensionIdRecord.serverRecord == null) {
            Helper.log("Dimension Id Record is Missing");
            DimensionIdRecord.serverRecord = new DimensionIdRecord((BiMap<class_5321<class_1937>, Integer>)HashBiMap.create());
        }
        Helper.log("Start Completing Dimension Id Record");
        Helper.log("Before:\n" + DimensionIdRecord.serverRecord);
        Set keys = MiscHelper.getServer().method_29435();
        BiMap<class_5321<class_1937>, Integer> bimap = DimensionIdRecord.serverRecord.idMap;
        if (!bimap.containsKey((Object)class_1937.field_25179)) {
            bimap.put((Object)class_1937.field_25179, (Object)0);
        }
        if (!bimap.containsKey((Object)class_1937.field_25180)) {
            bimap.put((Object)class_1937.field_25180, (Object)-1);
        }
        if (!bimap.containsKey((Object)class_1937.field_25181)) {
            bimap.put((Object)class_1937.field_25181, (Object)1);
        }
        ArrayList<class_5321> keysList = new ArrayList<class_5321>(keys);
        keysList.sort(Comparator.comparing(class_5321::toString));
        Helper.log("Server Loaded Dimensions:\n" + Helper.myToString(keysList.stream().map(class_5321::method_29177)));
        keysList.forEach(dim -> {
            if (!bimap.containsKey(dim)) {
                int newid = bimap.values().stream().mapToInt(i -> i).max().orElse(1) + 1;
                bimap.put(dim, (Object)newid);
            }
        });
        Helper.log("After:\n" + DimensionIdRecord.serverRecord);
    }
}

