/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.api;

import com.mojang.serialization.Lifecycle;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7780;
import net.minecraft.class_7924;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.q_misc_util.dimension.DynamicDimensionsImpl;
import qouteall.q_misc_util.dimension.ExtraDimensionStorage;
import qouteall.q_misc_util.mixin.dimension.IELayeredRegistryAccess;
import qouteall.q_misc_util.mixin.dimension.IEMappedRegistry;

public class DimensionAPI {
    private static final Logger logger = LogManager.getLogger();
    public static final Event<ServerDimensionsLoadCallback> serverDimensionsLoadEvent = EventFactory.createArrayBacked(ServerDimensionsLoadCallback.class, listeners -> (worldOptions, registryManager) -> {
        class_2378 levelStems = registryManager.method_30530(class_7924.field_41224);
        for (ServerDimensionsLoadCallback listener : listeners) {
            try {
                listener.run(worldOptions, registryManager);
            }
            catch (Exception e) {
                logger.error("Error registering custom dimension", (Throwable)e);
            }
        }
    });
    public static final Event<DynamicUpdateListener> serverDimensionDynamicUpdateEvent = EventFactory.createArrayBacked(DynamicUpdateListener.class, arr -> set -> {
        for (DynamicUpdateListener runnable : arr) {
            runnable.run(set);
        }
    });
    public static final Event<DynamicUpdateListener> clientDimensionUpdateEvent = EventFactory.createArrayBacked(DynamicUpdateListener.class, arr -> set -> {
        for (DynamicUpdateListener runnable : arr) {
            runnable.run(set);
        }
    });

    public static void addDimension(class_2378<class_5363> levelStemRegistry, class_2960 dimensionId, class_6880<class_2874> dimensionTypeHolder, class_2794 chunkGenerator) {
        DimensionAPI.addDimension(levelStemRegistry, dimensionId, new class_5363(dimensionTypeHolder, chunkGenerator));
    }

    private static void addDimension(class_2378<class_5363> levelStemRegistry, class_2960 dimensionId, class_5363 levelStem) {
        if (!(levelStemRegistry instanceof class_2370)) {
            throw new RuntimeException("Failed to register the dimension");
        }
        class_2370 mapped = (class_2370)levelStemRegistry;
        if (!mapped.method_10235().contains(dimensionId)) {
            boolean oldIsFrozen = ((IEMappedRegistry)mapped).ip_getIsFrozen();
            ((IEMappedRegistry)mapped).ip_setIsFrozen(false);
            mapped.method_10272(class_5321.method_29179((class_5321)class_7924.field_41224, (class_2960)dimensionId), (Object)levelStem, Lifecycle.stable());
            ((IEMappedRegistry)mapped).ip_setIsFrozen(oldIsFrozen);
        }
    }

    public static void addDimensionDynamically(class_2960 dimensionId, class_5363 levelStem) {
        DynamicDimensionsImpl.addDimensionDynamically(dimensionId, levelStem);
    }

    public static void removeDimensionDynamically(class_3218 world) {
        DynamicDimensionsImpl.removeDimensionDynamically(world);
    }

    public static void saveDimensionConfiguration(class_5321<class_1937> dimension) {
        Validate.isTrue((!dimension.method_29177().method_12836().equals("minecraft") ? 1 : 0) != 0, (String)"cannot save a vanilla dimension", (Object[])new Object[0]);
        ExtraDimensionStorage.saveDimensionIntoExtraStorage(dimension);
    }

    public static boolean deleteDimensionConfiguration(class_5321<class_1937> dimension) {
        return ExtraDimensionStorage.removeDimensionFromExtraStorage(dimension);
    }

    public static class_2370<class_5363> collectCustomDimensions(class_5455.class_6890 worldGenLoadContext, class_5285 options) {
        class_2370 subDimensionRegistry = new class_2370(class_7924.field_41224, Lifecycle.stable());
        class_5455.class_6890 subRegistryAccess = new class_5455.class_6891(List.of(subDimensionRegistry)).method_40316();
        class_7780<Integer> wrappedLayeredRegistryAccess = IELayeredRegistryAccess.ip_init(List.of(Integer.valueOf(1), Integer.valueOf(2)), List.of(worldGenLoadContext, subRegistryAccess));
        class_5455.class_6890 wrappedRegistryAccess = wrappedLayeredRegistryAccess.method_45926();
        ((ServerDimensionsLoadCallback)serverDimensionsLoadEvent.invoker()).run(options, (class_5455)wrappedRegistryAccess);
        return subDimensionRegistry;
    }

    public static interface ServerDimensionsLoadCallback {
        public void run(class_5285 var1, class_5455 var2);
    }

    public static interface DynamicUpdateListener {
        public void run(Set<class_5321<class_1937>> var1);
    }
}

