/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiPredicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2370;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.q_misc_util.MiscGlobals;
import qouteall.q_misc_util.dimension.DimId;
import qouteall.q_misc_util.ducks.IEMinecraftServer_Misc;
import qouteall.q_misc_util.mixin.IELevelStorageAccess_Misc;

public class MiscHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final Gson gson;

    public static <T> class_2370<T> filterAndCopyRegistry(class_2370<T> registry, BiPredicate<class_5321<T>, T> predicate) {
        class_2370 newRegistry = new class_2370(registry.method_30517(), registry.method_31138());
        for (Map.Entry entry : registry.method_29722()) {
            Object object = entry.getValue();
            class_5321 key = (class_5321)entry.getKey();
            if (!predicate.test((class_5321<class_5321>)key, (class_5321)object)) continue;
            newRegistry.method_10272(key, object, registry.method_31139(object));
        }
        return newRegistry;
    }

    @Environment(value=EnvType.CLIENT)
    public static void executeOnRenderThread(Runnable runnable) {
        class_310 client = class_310.method_1551();
        if (client.method_18854()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.error("Processing task on render thread", (Throwable)e);
            }
        } else {
            client.execute(runnable);
        }
    }

    public static MinecraftServer getServer() {
        return (MinecraftServer)MiscGlobals.refMinecraftServer.get();
    }

    public static void executeOnServerThread(Runnable runnable) {
        MinecraftServer server = MiscHelper.getServer();
        if (server.method_18854()) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                LOGGER.error("Processing task on server thread", (Throwable)e);
            }
        } else {
            server.execute(runnable);
        }
    }

    public static boolean isDedicatedServer() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.SERVER;
    }

    public static Path getWorldSavingDirectory() {
        MinecraftServer server = MiscHelper.getServer();
        Validate.notNull((Object)server);
        Path saveDir = ((IELevelStorageAccess_Misc)((IEMinecraftServer_Misc)server).ip_getStorageSource()).ip_getLevelPath().comp_732();
        return saveDir;
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.registerTypeAdapter(new TypeToken<class_5321<class_1937>>(){}.getType(), (Object)new DimensionIDJsonAdapter());
        gson = gsonBuilder.create();
    }

    private static class DimensionIDJsonAdapter
    implements JsonSerializer<class_5321<class_1937>>,
    JsonDeserializer<class_5321<class_1937>> {
        private DimensionIDJsonAdapter() {
        }

        public class_5321<class_1937> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String str = json.getAsString();
            return DimId.idToKey(str);
        }

        public JsonElement serialize(class_5321<class_1937> src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.method_29177().toString());
        }
    }
}

