/*
 * Decompiled with CFR 0.152.
 */
package com.jiggo.editenchanting.common.util;

import com.google.common.collect.Lists;
import com.jiggo.editenchanting.common.config.DisenchantmentTableConfig;
import com.jiggo.editenchanting.common.enums.EnumError;
import com.jiggo.editenchanting.common.enums.EnumPower;
import com.jiggo.editenchanting.common.util.EnchantmentUtils;
import com.jiggo.editenchanting.common.util.ExpressionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public final class TextComponentUtils {
    public static final MutableComponent EMPTY = TextComponentUtils.translatable("desc.editenchanting.empty");
    public static final MutableComponent ERROR = TextComponentUtils.literal("Game Error").m_130940_(ChatFormatting.RED);

    public static MutableComponent translatable(String key) {
        return Component.m_237115_((String)key);
    }

    public static MutableComponent translatable(String key, Object ... values) {
        return Component.m_237110_((String)key, (Object[])values);
    }

    public static MutableComponent literal(String text) {
        return MutableComponent.m_237204_((ComponentContents)new LiteralContents(text));
    }

    public static List<Component> getToolTip(MutableComponent text, int value) {
        ArrayList lines = Lists.newArrayList();
        EnumPower power = (EnumPower)((Object)DisenchantmentTableConfig.POWER.get());
        lines.add(0, text.m_130940_(ChatFormatting.GRAY));
        switch (power) {
            case ITEM: {
                String name = DisenchantmentTableConfig.getCostName();
                lines.add(1, TextComponentUtils.space(TextComponentUtils.translatable("desc.editenchanting.item", value, name)).m_130940_(ChatFormatting.BLUE));
                break;
            }
            case EXPERIENCE: {
                lines.add(1, TextComponentUtils.space(TextComponentUtils.translatable("desc.editenchanting.experience", value)).m_130940_(ChatFormatting.GREEN));
            }
        }
        lines.add(2, Component.m_237119_());
        return lines;
    }

    public static MutableComponent getItem(ItemStack stack) {
        MutableComponent formattable = TextComponentUtils.literal("").m_7220_(stack.m_41786_()).m_130940_(stack.m_41791_().f_43022_);
        if (stack.m_41788_()) {
            formattable.m_130940_(ChatFormatting.ITALIC);
        }
        return formattable;
    }

    public static MutableComponent getExportCost(ItemStack stack) {
        Map maps = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (!maps.isEmpty()) {
            int value = (int)Math.floor(ExpressionUtils.getCost(maps, stack.m_41610_()));
            EnumPower power = (EnumPower)((Object)DisenchantmentTableConfig.POWER.get());
            switch (power) {
                case ITEM: {
                    String name = DisenchantmentTableConfig.getCostName();
                    return TextComponentUtils.translatable("desc.editenchanting.item", value, name).m_130940_(ChatFormatting.BLUE);
                }
                case EXPERIENCE: {
                    return TextComponentUtils.translatable("desc.editenchanting.experience", value).m_130940_(ChatFormatting.GREEN);
                }
            }
        }
        return ERROR;
    }

    public static MutableComponent getCost(ItemStack stack) {
        if (!EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty() && !stack.m_41619_()) {
            int value = (int)Math.floor(ExpressionUtils.getCost(stack));
            EnumPower power = (EnumPower)((Object)DisenchantmentTableConfig.POWER.get());
            switch (power) {
                case ITEM: {
                    String name = DisenchantmentTableConfig.getCostName();
                    return TextComponentUtils.translatable("desc.editenchanting.item", value, name).m_130940_(ChatFormatting.BLUE);
                }
                case EXPERIENCE: {
                    return TextComponentUtils.translatable("desc.editenchanting.experience", value).m_130940_(ChatFormatting.GREEN);
                }
            }
        }
        return ERROR;
    }

    public static List<MutableComponent> getEnchantTexts(ItemStack stack) {
        Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
        ArrayList list = Lists.newArrayList();
        map.forEach((key, value) -> {
            ChatFormatting formatting = key.m_6589_() ? ChatFormatting.RED : ChatFormatting.AQUA;
            list.add(((MutableComponent)key.m_44700_(value.intValue())).m_130940_(formatting));
        });
        return list;
    }

    public static MutableComponent getEnchant(ItemStack stack) {
        if (!stack.m_41619_() && !EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty()) {
            Tuple<Enchantment, Integer> tuple = EnchantmentUtils.getEnchantmentAttribute(stack);
            ChatFormatting formatting = ((Enchantment)tuple.m_14418_()).m_6589_() ? ChatFormatting.RED : ChatFormatting.AQUA;
            return ((MutableComponent)((Enchantment)tuple.m_14418_()).m_44700_(((Integer)tuple.m_14419_()).intValue())).m_130940_(formatting);
        }
        return ERROR;
    }

    public static MutableComponent getRequire() {
        String key = DisenchantmentTableConfig.POWER.get() == EnumPower.ITEM ? DisenchantmentTableConfig.getCostName() : "desc.editenchanting.exp";
        String cost = TextComponentUtils.translatable(key).getString();
        return TextComponentUtils.translatable("desc.editenchanting.require", cost).m_130940_(ChatFormatting.RED);
    }

    public static List<Component> getRequire(EnumError error, ItemStack stack) {
        ArrayList lines = Lists.newArrayList();
        switch (error) {
            case DISENCHANT: {
                lines.add(TextComponentUtils.translatable("desc.editenchanting.cost").m_130940_(ChatFormatting.RED));
                lines.add(TextComponentUtils.getCost(stack).m_130940_(ChatFormatting.RED));
                break;
            }
            case EDIT: {
                lines.add(TextComponentUtils.translatable("desc.editenchanting.edit").m_130940_(ChatFormatting.RED));
                lines.add(TextComponentUtils.getCost(stack).m_130940_(ChatFormatting.RED));
                break;
            }
            case EXPORT: {
                lines.add(TextComponentUtils.translatable("desc.editenchanting.export").m_130940_(ChatFormatting.RED));
                lines.add(TextComponentUtils.getExportCost(stack).m_130940_(ChatFormatting.RED));
            }
        }
        return lines;
    }

    public static MutableComponent space(MutableComponent component) {
        return TextComponentUtils.literal(" ").m_7220_((Component)component);
    }
}

