/*
 * Decompiled with CFR 0.152.
 */
package com.jiggo.editenchanting.common.util;

import com.jiggo.editenchanting.DisenchantmentEditTable;
import com.jiggo.editenchanting.common.config.DisenchantmentTableConfig;
import com.jiggo.editenchanting.common.enums.EnumPower;
import com.jiggo.editenchanting.common.inventory.DisenchantmentMenu;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.apache.logging.log4j.Logger;

public final class ExpressionUtils {
    private static final Logger LOGGER = DisenchantmentEditTable.getLogger();
    private static final EnumPower POWER = (EnumPower)((Object)DisenchantmentTableConfig.POWER.get());

    public static double getCost(ItemStack stack) {
        Map maps = EnchantmentHelper.m_44831_((ItemStack)stack);
        int level = maps.values().stream().mapToInt(Integer::intValue).sum();
        int count = maps.size();
        int repair = stack.m_41610_();
        return ExpressionUtils.getCost(level, count, repair);
    }

    public static double getCost(int level, int count, int repair) {
        String expression = (String)DisenchantmentTableConfig.POWER_EXPRESSION.get();
        expression = expression.replaceAll("level", String.valueOf(level));
        expression = expression.replaceAll("count", String.valueOf(count));
        expression = expression.replaceAll("repair", String.valueOf(repair));
        return ExpressionUtils.evaluateAndPrintResult(expression);
    }

    public static double getCost(Map<Enchantment, Integer> maps, int repair) {
        String expression = (String)DisenchantmentTableConfig.REPORT_EXPRESSION.get();
        int level = maps.values().stream().mapToInt(Integer::intValue).sum();
        int count = maps.size();
        expression = expression.replaceAll("level", String.valueOf(level));
        expression = expression.replaceAll("count", String.valueOf(count));
        expression = expression.replaceAll("repair", String.valueOf(repair));
        return ExpressionUtils.evaluateAndPrintResult(expression);
    }

    public static boolean canUse(Player player) {
        return player.m_7500_() || DisenchantmentTableConfig.POWER.get() == EnumPower.NONE;
    }

    public static boolean canUse(Player player, ItemStack stack) {
        if (ExpressionUtils.canUse(player)) {
            return true;
        }
        if (!EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty() && POWER != EnumPower.NONE) {
            int value = (int)Math.floor(ExpressionUtils.getCost(stack));
            return ExpressionUtils.canUse(player, value);
        }
        return false;
    }

    public static boolean canUse(Player player, int value) {
        try {
            switch (POWER) {
                case ITEM: {
                    return ((DisenchantmentMenu)player.f_36096_).getCostCount() >= value;
                }
                case EXPERIENCE: {
                    return player.f_36078_ >= value;
                }
            }
        }
        catch (NullPointerException exception) {
            LOGGER.error(exception.getMessage());
        }
        return false;
    }

    public static boolean canReport(Player player, ItemStack stack) {
        Map maps;
        boolean empty = EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty();
        if (ExpressionUtils.canUse(player) && !empty) {
            return true;
        }
        if (!empty && POWER != EnumPower.NONE && !(maps = EnchantmentHelper.m_44831_((ItemStack)stack)).isEmpty()) {
            int cost = stack.m_41610_();
            int value = (int)Math.floor(ExpressionUtils.getCost(maps, cost));
            return ExpressionUtils.canUse(player, value);
        }
        return false;
    }

    public static void setSlotItem(DisenchantmentMenu container, Slot slot, ItemStack stack) {
        if (!container.getPlayer().m_7500_() && !EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty()) {
            int value = (int)Math.floor(ExpressionUtils.getCost(stack));
            switch ((EnumPower)((Object)DisenchantmentTableConfig.POWER.get())) {
                case ITEM: {
                    container.getCostInventory().getCost().m_41774_(value);
                    break;
                }
                case EXPERIENCE: {
                    container.getPlayer().m_7408_(stack, value);
                }
            }
        }
        container.playSound();
        slot.m_5852_(stack);
    }

    public static double evaluateAndPrintResult(String expression) {
        String[] str = expression.split("\\s+");
        LinkedList<String> queue = new LinkedList<String>();
        queue.addAll(Arrays.asList(str));
        Stack<String> ops = new Stack<String>();
        Stack<Double> values = new Stack<Double>();
        while (!queue.isEmpty()) {
            String token = (String)queue.poll();
            if (token.equals("(")) continue;
            if (token.equals("+")) {
                ops.push(token);
                continue;
            }
            if (token.equals("-")) {
                ops.push(token);
                continue;
            }
            if (token.equals("*")) {
                ops.push(token);
                continue;
            }
            if (token.equals("/")) {
                ops.push(token);
                continue;
            }
            if (token.equals("sqrt")) {
                ops.push(token);
                continue;
            }
            if (token.equals(")")) {
                double v = (Double)values.pop();
                String op = (String)ops.pop();
                if (op.equals("+")) {
                    v = (Double)values.pop() + v;
                } else if (op.equals("-")) {
                    v = (Double)values.pop() - v;
                } else if (op.equals("*")) {
                    v = (Double)values.pop() * v;
                } else if (op.equals("/")) {
                    v = (Double)values.pop() / v;
                } else if (op.equals("sqrt")) {
                    v = Math.sqrt(v);
                }
                values.push(v);
                continue;
            }
            values.push(Double.parseDouble(token));
        }
        return (Double)values.pop();
    }
}

