/*
 * Decompiled with CFR 0.152.
 */
package com.jiggo.editenchanting.common.inventory;

import com.jiggo.editenchanting.common.block.ModBlocks;
import com.jiggo.editenchanting.common.config.DisenchantmentTableConfig;
import com.jiggo.editenchanting.common.control.EnchantedBookLogic;
import com.jiggo.editenchanting.common.enums.EnumError;
import com.jiggo.editenchanting.common.enums.EnumPower;
import com.jiggo.editenchanting.common.inventory.ItemStackHandlerBook;
import com.jiggo.editenchanting.common.inventory.ItemStackHandlerBooks;
import com.jiggo.editenchanting.common.inventory.ItemStackHandlerCost;
import com.jiggo.editenchanting.common.inventory.ItemStackHandlerEnchant;
import com.jiggo.editenchanting.common.inventory.SlotBook;
import com.jiggo.editenchanting.common.inventory.SlotCost;
import com.jiggo.editenchanting.common.inventory.SlotEnchant;
import com.jiggo.editenchanting.common.sound.ModSounds;
import com.jiggo.editenchanting.common.util.ExpressionUtils;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class DisenchantmentMenu
extends AbstractContainerMenu {
    private final Player player;
    private final ItemStackHandlerEnchant tableInventory;
    private final ItemStackHandlerBook bookInventory;
    private final ItemStackHandlerBooks bookArrayInventory;
    private final ItemStackHandlerCost costInventory;
    private final EnchantedBookLogic logic;
    private final ContainerLevelAccess access;
    private EnumError error = EnumError.NONE;
    private ItemStack errorStack = ItemStack.f_41583_;

    public DisenchantmentMenu(int windowId, Inventory inventory) {
        this(windowId, inventory, ContainerLevelAccess.f_39287_);
    }

    public DisenchantmentMenu(int windowId, Inventory inventory, ContainerLevelAccess access) {
        super((MenuType)ModBlocks.CONTAINER.get(), windowId);
        this.player = inventory.f_35978_;
        this.access = access;
        this.tableInventory = new ItemStackHandlerEnchant(this);
        this.bookInventory = new ItemStackHandlerBook(this);
        this.bookArrayInventory = new ItemStackHandlerBooks(this);
        this.costInventory = new ItemStackHandlerCost(this);
        this.m_38897_((Slot)new SlotEnchant((IItemHandler)this.tableInventory, 0, 13, 26));
        this.m_38897_((Slot)new SlotEnchant((IItemHandler)this.bookInventory, 0, 53, 26){

            @Override
            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        this.addBookArrayInventory(this.bookArrayInventory);
        this.addPlayerInventory(inventory);
        if (DisenchantmentTableConfig.POWER.get() == EnumPower.ITEM) {
            this.m_38897_((Slot)new SlotCost((IItemHandler)this.costInventory, 0, 170, 84));
        }
        this.logic = new EnchantedBookLogic(this);
    }

    private void addBookArrayInventory(ItemStackHandlerBooks inventory) {
        int index = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 6; ++j) {
                this.m_38897_((Slot)new SlotBook((IItemHandler)inventory, this, index++, 80 + j * 18, 15 + i * 18));
            }
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)playerInventory, k, 8 + k * 18, 142));
        }
    }

    public boolean m_6875_(Player player) {
        return DisenchantmentMenu.m_38889_((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.TABLE.get()));
    }

    public void onContentsChanged(ItemStackHandler inventory) {
        this.getAccess().m_39292_((world, pos) -> {
            if (!world.f_46443_) {
                if (inventory instanceof ItemStackHandlerEnchant) {
                    ItemStack itemStack = this.tableInventory.getEnchantingStack();
                    if (!itemStack.m_41619_()) {
                        this.logic.update();
                    } else {
                        this.logic.close();
                    }
                } else if (inventory instanceof ItemStackHandlerBooks) {
                    this.logic.bookArray();
                }
            }
        });
    }

    public void previous() {
        if (((Boolean)DisenchantmentTableConfig.PAGE_TURN.get()).booleanValue()) {
            this.logic.previous();
        }
    }

    public void next() {
        if (((Boolean)DisenchantmentTableConfig.PAGE_TURN.get()).booleanValue()) {
            this.logic.next();
        }
    }

    public void take() {
        this.disenchantCost(this.getEnchantingStack(), (EnumPower)((Object)DisenchantmentTableConfig.POWER.get()), this.player);
        this.logic.take();
        this.getAccess().m_39292_((world, pos) -> world.m_5594_(null, pos, (SoundEvent)ModSounds.DISENCHANTMENT_TABLE_USE.get(), SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.1f + 0.9f));
    }

    public void disenchantCost(ItemStack stack, EnumPower power, Player player) {
        Map<Enchantment, Integer> maps;
        if (!EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty() && !(maps = this.getLogic().getEnchantments(stack)).isEmpty()) {
            int value = (int)Math.floor(ExpressionUtils.getCost(maps, stack.m_41610_()));
            switch (power) {
                case ITEM: {
                    this.getCostInventory().getCost().m_41774_(value);
                    break;
                }
                case EXPERIENCE: {
                    player.m_7408_(stack, value);
                }
            }
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.access.m_39292_((world, pos) -> {
            if (!world.f_46443_) {
                if (!player.m_6084_() || player instanceof ServerPlayer && ((ServerPlayer)player).m_9232_()) {
                    player.m_36176_(this.tableInventory.getStackInSlot(0), false);
                    player.m_36176_(this.bookInventory.getStackInSlot(0), false);
                    if (DisenchantmentTableConfig.POWER.get() == EnumPower.ITEM) {
                        player.m_36176_(this.costInventory.getStackInSlot(0), false);
                    }
                } else {
                    player.m_150109_().m_150079_(this.tableInventory.getStackInSlot(0));
                    player.m_150109_().m_150079_(this.bookInventory.getStackInSlot(0));
                    if (DisenchantmentTableConfig.POWER.get() == EnumPower.ITEM) {
                        player.m_150109_().m_150079_(this.costInventory.getStackInSlot(0));
                    }
                }
            }
        });
    }

    public ItemStack m_7648_(Player player, int slot) {
        Slot transferSlot = (Slot)this.f_38839_.get(slot);
        if (transferSlot == null || !transferSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack transferStack = transferSlot.m_7993_();
        ItemStack copyItem = transferStack.m_41777_();
        if (slot <= 1) {
            if (!this.m_38903_(transferStack, 20, 56, true)) {
                return ItemStack.f_41583_;
            }
            transferSlot.m_40234_(transferStack, copyItem);
        } else if (slot >= 20 && slot < 47 ? !this.m_38903_(transferStack, 0, 1, false) && !this.m_38903_(transferStack, 47, 56, false) : (slot >= 47 && slot < 56 ? !this.m_38903_(transferStack, 0, 1, false) && !this.m_38903_(transferStack, 20, 47, false) : !this.m_38903_(transferStack, 20, 56, false))) {
            return ItemStack.f_41583_;
        }
        if (transferStack.m_41613_() == 0) {
            transferSlot.m_5852_(ItemStack.f_41583_);
        } else {
            transferSlot.m_6654_();
        }
        if (transferStack.m_41613_() == copyItem.m_41613_()) {
            return ItemStack.f_41583_;
        }
        transferSlot.m_142406_(player, transferStack);
        return transferStack;
    }

    protected boolean m_38903_(ItemStack stack, int start, int end, boolean direction) {
        Slot slot;
        boolean flag = false;
        int i = start;
        if (direction) {
            i = end - 1;
        }
        if (stack.m_41753_()) {
            while (!stack.m_41619_() && !(!direction ? i >= end : i < start)) {
                slot = (Slot)this.f_38839_.get(i);
                ItemStack same = slot.m_7993_();
                if (!same.m_41619_() && ItemStack.m_150942_((ItemStack)stack, (ItemStack)same)) {
                    int maxSize;
                    int j = same.m_41613_() + stack.m_41613_();
                    if (j <= (maxSize = Math.min(slot.m_6641_(), stack.m_41741_()))) {
                        stack.m_41764_(0);
                        same.m_41764_(j);
                        slot.m_6654_();
                        flag = true;
                    } else if (same.m_41613_() < maxSize) {
                        stack.m_41774_(maxSize - same.m_41613_());
                        same.m_41764_(maxSize);
                        slot.m_6654_();
                        flag = true;
                    }
                }
                if (direction) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.m_41619_()) {
            i = direction ? end - 1 : start;
            while (!(!direction ? i >= end : i < start)) {
                slot = (Slot)this.f_38839_.get(i);
                ItemStack empty = slot.m_7993_();
                if (empty.m_41619_() && slot.m_5857_(stack)) {
                    if (stack.m_41720_() instanceof EnchantedBookItem && this.bookArrayInventory.contains(stack)) {
                        if (stack.m_41613_() > slot.m_6641_()) {
                            ExpressionUtils.setSlotItem(this, slot, stack.m_41620_(slot.m_6641_()));
                        } else {
                            ExpressionUtils.setSlotItem(this, slot, stack.m_41620_(stack.m_41613_()));
                        }
                    } else if (stack.m_41613_() > slot.m_6641_()) {
                        slot.m_5852_(stack.m_41620_(slot.m_6641_()));
                    } else {
                        slot.m_5852_(stack.m_41620_(stack.m_41613_()));
                    }
                    slot.m_6654_();
                    flag = true;
                    break;
                }
                if (direction) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void playSound() {
        this.getAccess().m_39292_((world, pos) -> {
            if (!world.m_5776_()) {
                world.m_5594_(null, pos, (SoundEvent)ModSounds.DISENCHANTMENT_TABLE_USE.get(), SoundSource.BLOCKS, 1.0f, world.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        });
    }

    public ItemStackHandlerEnchant getTableInventory() {
        return this.tableInventory;
    }

    public ItemStackHandlerBook getBookInventory() {
        return this.bookInventory;
    }

    public ItemStackHandlerBooks getBookArrayInventory() {
        return this.bookArrayInventory;
    }

    public ItemStackHandlerCost getCostInventory() {
        return this.costInventory;
    }

    public Player getPlayer() {
        return this.player;
    }

    public ContainerLevelAccess getAccess() {
        return this.access;
    }

    public EnchantedBookLogic getLogic() {
        return this.logic;
    }

    public ItemStack getEnchantingStack() {
        return this.tableInventory.getEnchantingStack();
    }

    public int getCostCount() {
        ItemStack cost = this.getCostInventory().getCost();
        return cost.m_41619_() ? 0 : cost.m_41613_();
    }

    public EnumError getError() {
        return this.error;
    }

    public void setError(EnumError error) {
        this.error = error;
    }

    public ItemStack getErrorStack() {
        return this.errorStack;
    }

    public void setErrorStack(ItemStack stack) {
        this.errorStack = stack;
    }
}

