/*
 * Decompiled with CFR 0.152.
 */
package com.jiggo.editenchanting.common.control;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.jiggo.editenchanting.common.enums.EnumBookStatus;
import com.jiggo.editenchanting.common.enums.EnumMode;
import com.jiggo.editenchanting.common.inventory.DisenchantmentMenu;
import com.jiggo.editenchanting.common.inventory.ItemStackHandlerBook;
import com.jiggo.editenchanting.common.inventory.ItemStackHandlerBooks;
import com.jiggo.editenchanting.common.inventory.ItemStackHandlerEnchant;
import com.jiggo.editenchanting.common.util.EnchantmentUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class EnchantedBookLogic {
    private final DisenchantmentMenu container;
    private final ItemStackHandlerEnchant tableInventory;
    private final ItemStackHandlerBook bookInventory;
    private final ItemStackHandlerBooks bookArrayInventory;
    private Map<Enchantment, Integer> enchantments = Maps.newLinkedHashMap();
    private static final Integer PAGE_SIZE = 18;
    private Integer index = 1;
    private EnumMode mode = EnumMode.DEFAULT;
    private EnumBookStatus status = EnumBookStatus.OPEN;
    private boolean edit = false;
    private boolean size = false;
    private boolean update = false;

    public EnchantedBookLogic(DisenchantmentMenu container) {
        this.container = container;
        this.tableInventory = container.getTableInventory();
        this.bookInventory = container.getBookInventory();
        this.bookArrayInventory = container.getBookArrayInventory();
    }

    public void update() {
        ItemStack stack = this.getEnchantingStack();
        switch (this.mode) {
            case DEFAULT: 
            case NULL: {
                if (this.enchantments.isEmpty()) {
                    this.enchantments = this.getEnchantments(stack);
                    this.index = 1;
                }
                if (this.enchantments.size() == 1 && stack.m_41720_() == Items.f_42690_) {
                    this.mode = EnumMode.BOOK_EDIT;
                }
                if (!this.enchantments.isEmpty()) {
                    if (this.mode != EnumMode.BOOK_EDIT) {
                        this.mode = stack.m_41720_() != Items.f_42690_ ? EnumMode.ENCHANT : EnumMode.BOOK;
                    }
                    if (this.mode == EnumMode.ENCHANT || this.mode == EnumMode.BOOK) {
                        this.status = EnumBookStatus.CLOSE;
                        this.updateBookArrayStack();
                        this.status = EnumBookStatus.OPEN;
                        break;
                    }
                    this.status = EnumBookStatus.CLOSE;
                    this.updateBookArrayStack(true);
                    this.status = EnumBookStatus.OPEN;
                    break;
                }
                if (stack.m_41720_() == Items.f_42690_) break;
                this.mode = EnumMode.NULL;
                break;
            }
            default: {
                this.enchantments = this.getEnchantments(stack);
                this.index = 1;
                this.status = EnumBookStatus.CLOSE;
                this.clearBookArrayStack();
                this.status = EnumBookStatus.OPEN;
                this.mode = EnumMode.DEFAULT;
                this.update();
            }
        }
    }

    public void close() {
        if (!this.enchantments.isEmpty()) {
            this.status = EnumBookStatus.CLOSE;
            this.enchantments = Maps.newLinkedHashMap();
            this.clearBookArrayStack();
            this.mode = EnumMode.DEFAULT;
            this.status = EnumBookStatus.OPEN;
        }
    }

    public void bookArray() {
        if (this.edit || this.size || this.status == EnumBookStatus.CLOSE) {
            return;
        }
        if (this.mode != EnumMode.DEFAULT) {
            if (this.mode != EnumMode.BOOK_EDIT) {
                this.updateEnchantments();
                this.updateEnchantingStack();
                if (this.mode == EnumMode.NULL) {
                    this.mode = EnumMode.ENCHANT;
                }
                if (this.size) {
                    this.updateBookArrayStack();
                }
                this.size = false;
            } else if (this.isUpdate()) {
                this.updateSimpleEnchantments();
                this.updateEnchantingStack();
                this.update = false;
            }
        }
    }

    public boolean isUpdate() {
        return !this.update;
    }

    public void previous() {
        if (this.enchantments.size() - 1 <= PAGE_SIZE - 2) {
            return;
        }
        this.status = EnumBookStatus.CLOSE;
        int i = this.index - 1;
        this.index = i == 0 ? (int)Math.ceil(((float)this.enchantments.size() + 2.0f) / (float)PAGE_SIZE.intValue()) : i;
        this.updateBookArrayStack();
        this.status = EnumBookStatus.OPEN;
    }

    public void next() {
        if (this.enchantments.size() - 1 <= PAGE_SIZE - 2) {
            return;
        }
        this.status = EnumBookStatus.CLOSE;
        int last = (int)Math.ceil(((float)this.enchantments.size() + 2.0f) / (float)PAGE_SIZE.intValue());
        int i = this.index + 1;
        this.index = i == last + 1 ? 1 : i;
        this.updateBookArrayStack();
        this.status = EnumBookStatus.OPEN;
    }

    public void take() {
        this.updateBookStack();
        this.enchantments = Maps.newLinkedHashMap();
        this.clearBookArrayStack();
        this.updateEnchantingStack();
        this.mode = EnumMode.NULL;
    }

    public void updateEnchantments() {
        ItemStackHandlerBooks inventory = this.bookArrayInventory;
        int count = 1;
        int start = this.index * PAGE_SIZE - PAGE_SIZE + 1;
        int limit = this.index * PAGE_SIZE;
        LinkedHashMap map1 = Maps.newLinkedHashMap();
        LinkedHashMap map2 = Maps.newLinkedHashMap();
        LinkedHashMap map3 = Maps.newLinkedHashMap();
        int length = inventory.getSlots();
        for (int i = 0; i < length; ++i) {
            if (inventory.getStackInSlot(i) == ItemStack.f_41583_) continue;
            ItemStack stack = inventory.getStackInSlot(i);
            Map map = EnchantmentHelper.m_44831_((ItemStack)stack);
            if (map.size() > 1) {
                this.size = true;
            } else {
                Enchantment enchantment = EnchantmentUtils.getFirstEnchantment(map);
                if (map2.containsKey(enchantment)) {
                    map2.replace(enchantment, (Integer)map2.get(enchantment) + (Integer)map.get(enchantment));
                    this.size = true;
                    continue;
                }
            }
            map2.putAll(map);
        }
        for (Map.Entry<Enchantment, Integer> entry : this.enchantments.entrySet()) {
            Enchantment key = entry.getKey();
            Integer value = entry.getValue();
            if (count < start) {
                map1.put(key, value);
            } else if (count > limit) {
                map3.put(key, value);
            }
            ++count;
        }
        LinkedHashMap enchantments = Maps.newLinkedHashMap();
        enchantments.putAll(map1);
        enchantments.putAll(map2);
        enchantments.putAll(map3);
        this.enchantments = enchantments;
    }

    public void updateSimpleEnchantments() {
        if (this.enchantments.isEmpty() && this.mode != EnumMode.BOOK_EDIT) {
            return;
        }
        this.update = true;
        ArrayList integers = Lists.newArrayList();
        ArrayList slots = Lists.newArrayList();
        ItemStackHandlerBooks inventory = this.bookArrayInventory;
        int length = inventory.getSlots();
        for (int i = 0; i < length; ++i) {
            if (inventory.getStackInSlot(i) == ItemStack.f_41583_) continue;
            integers.add(this.getEnchantments(inventory.getStackInSlot(i)).entrySet().iterator().next().getValue());
            slots.add(i);
        }
        if (this.enchantments.isEmpty()) {
            return;
        }
        Map.Entry<Enchantment, Integer> entry = this.enchantments.entrySet().iterator().next();
        Enchantment key = entry.getKey();
        int level = entry.getValue();
        if (this.getFirstEnchantments(this.tableInventory.getEnchantingStack()).getValue() != level) {
            return;
        }
        if (level > integers.size()) {
            int num = 0;
            for (int j = 1; j <= level; ++j) {
                if (integers.contains(j)) continue;
                num = j;
            }
            if (level - num != 0) {
                this.enchantments.replace(key, level - num);
                this.updateBookArrayStack(true);
            } else {
                this.enchantments.remove(key);
                this.clearBookArrayStack();
            }
            this.updateBookArrayStack(true);
        } else if (level <= integers.size()) {
            for (int j = 0; j < length; ++j) {
                Map.Entry<Enchantment, Integer> e;
                if (inventory.getStackInSlot(j) == ItemStack.f_41583_ || (e = this.getEnchantments(inventory.getStackInSlot(j)).entrySet().iterator().next()).getKey().m_44704_().equals(key.m_44704_())) continue;
                this.enchantments.put(e.getKey(), e.getValue());
            }
            int num = 0;
            if (level == integers.size()) {
                for (int k = 1; k <= level; ++k) {
                    if (integers.contains(k)) continue;
                    Iterator iterator = slots.iterator();
                    while (iterator.hasNext()) {
                        int slot = (Integer)iterator.next();
                        Map.Entry<Enchantment, Integer> e = this.getEnchantments(inventory.getStackInSlot(slot)).entrySet().iterator().next();
                        if (e.getValue() != k || !key.m_44704_().equals(e.getKey().m_44704_())) continue;
                        num = k;
                        break;
                    }
                    if (num != 0) break;
                }
                this.enchantments.replace(key, level - num);
            }
            if (num == 0 && this.enchantments.size() == 1) {
                int all = 0;
                int count = 0;
                for (int k = 1; k <= level; ++k) {
                    count += k;
                }
                Iterator k = integers.iterator();
                while (k.hasNext()) {
                    int m = (Integer)k.next();
                    all += m;
                }
                int abs = level + all - count;
                if (key.m_6586_() >= abs) {
                    this.enchantments.replace(key, abs);
                    this.edit = true;
                    this.updateBookArrayStack(true);
                    this.edit = false;
                }
                return;
            }
            this.edit = true;
            this.updateEnchantingStack();
            if (this.enchantments.size() > 1) {
                this.updateBookArrayStack();
                this.mode = EnumMode.BOOK;
            }
            this.edit = false;
        }
    }

    public void updateEnchantingStack() {
        ItemStack stack = this.getEnchantingStack();
        ServerPlayer player = (ServerPlayer)this.container.getPlayer();
        boolean flag = true;
        if (stack.m_41720_() instanceof EnchantedBookItem && this.enchantments.isEmpty()) {
            flag = false;
            this.tableInventory.setStackInSlot(0, ItemStack.f_41583_);
            player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.container.f_38840_, this.container.m_182425_(), 0, ItemStack.f_41583_));
        }
        if (flag) {
            EnchantmentUtils.setEnchantedItemStack(this.enchantments, stack);
            player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.container.f_38840_, this.container.m_182425_(), 0, stack));
        }
    }

    public void updateBookStack() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42690_);
        ServerPlayer player = (ServerPlayer)this.container.getPlayer();
        EnchantmentUtils.setEnchantedItemStack(this.enchantments, stack);
        this.bookInventory.setStackInSlot(0, stack);
        player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(this.container.f_38840_, this.container.m_182425_(), 1, stack));
    }

    public void updateBookArrayStack() {
        this.updateBookArrayStack(false);
    }

    public void updateBookArrayStack(boolean flag) {
        int length;
        List<Object> stacks = Lists.newArrayList();
        ServerPlayer player = (ServerPlayer)this.container.getPlayer();
        int containerId = this.container.f_38840_;
        if (flag) {
            if (this.enchantments.isEmpty()) {
                return;
            }
            Enchantment key = this.getFirstEnchantment();
            int level = this.enchantments.get(key);
            for (int i = 1; i <= level; ++i) {
                stacks.add(EnchantmentUtils.getEnchantedItemStack(key, i));
            }
        } else {
            stacks = this.getBookStack();
        }
        if ((length = this.bookArrayInventory.getSlots()) != 0) {
            for (int i = 0; i < length; ++i) {
                ItemStack stack = ItemStack.f_41583_;
                if (i < stacks.size()) {
                    stack = (ItemStack)stacks.get(i);
                }
                this.bookArrayInventory.setStackInSlot(i, stack);
                int slotId = i + 2;
                player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(containerId, this.container.m_182425_(), slotId, stack));
            }
        }
    }

    public void clearBookArrayStack() {
        ItemStackHandlerBooks inventory = this.bookArrayInventory;
        ServerPlayer player = (ServerPlayer)this.container.getPlayer();
        int length = inventory.getSlots();
        int containerId = this.container.f_38840_;
        for (int i = 0; i < length; ++i) {
            if (inventory.getStackInSlot(i).m_41619_() && i != length - 1) continue;
            inventory.setStackInSlot(i, ItemStack.f_41583_);
            int slotId = i + 2;
            player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(containerId, this.container.m_182425_(), slotId, ItemStack.f_41583_));
        }
    }

    public List<ItemStack> getBookStack() {
        LinkedHashMap map = Maps.newLinkedHashMap();
        int count = 1;
        int start = this.index * PAGE_SIZE - PAGE_SIZE + 1;
        int limit = this.index * PAGE_SIZE;
        for (Map.Entry<Enchantment, Integer> entry : this.enchantments.entrySet()) {
            if (count >= start && count <= limit) {
                Enchantment key = entry.getKey();
                Integer value = entry.getValue();
                map.put(key, value);
            }
            ++count;
        }
        return EnchantmentUtils.getEnchantedItemStackList(map);
    }

    public ItemStack getEnchantingStack() {
        return this.tableInventory.getEnchantingStack();
    }

    public Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        return EnchantmentHelper.m_44831_((ItemStack)stack);
    }

    public Map.Entry<Enchantment, Integer> getFirstEnchantments(ItemStack stack) {
        return EnchantmentHelper.m_44831_((ItemStack)stack).entrySet().iterator().next();
    }

    public Enchantment getFirstEnchantment() {
        return this.enchantments.entrySet().iterator().next().getKey();
    }

    public EnumMode getMode() {
        return this.mode;
    }

    public EnumBookStatus getStatus() {
        return this.status;
    }

    public boolean isEmpty() {
        return this.enchantments.isEmpty();
    }
}

