/*
 * Decompiled with CFR 0.152.
 */
package com.jiggo.editenchanting.common.config;

import com.jiggo.editenchanting.common.enums.EnumPower;
import com.jiggo.editenchanting.common.enums.EnumType;
import com.jiggo.editenchanting.common.util.TextComponentUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.ForgeRegistries;

public class DisenchantmentTableConfig {
    public static ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.BooleanValue CREATIVE_MODE;
    public static ForgeConfigSpec.EnumValue<EnumPower> POWER;
    public static ForgeConfigSpec.ConfigValue<String> POWER_EXPRESSION;
    public static ForgeConfigSpec.ConfigValue<String> REPORT_EXPRESSION;
    public static ForgeConfigSpec.ConfigValue<String> BOOK_EXPRESSION;
    public static ForgeConfigSpec.ConfigValue<String> COST;
    public static ForgeConfigSpec.EnumValue<EnumType> TYPE;
    public static ForgeConfigSpec.BooleanValue PAGE_TURN;
    public static ForgeConfigSpec.BooleanValue STRICT_MODE;

    public static Item getCostItem() {
        ResourceLocation location = new ResourceLocation((String)COST.get());
        return (Item)ForgeRegistries.ITEMS.getValue(location);
    }

    public static String getCostName() {
        return TextComponentUtils.translatable(DisenchantmentTableConfig.getCostItem().m_5524_()).getString();
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("General settings").push("general");
        CREATIVE_MODE = builder.comment("True if item verification needs to be deactivated").define("creative_mode", false);
        POWER = builder.comment("What consumables to use").defineEnum("power", (Enum)EnumPower.NONE);
        POWER_EXPRESSION = builder.comment(new String[]{"Enchant and Edit the computed expressions", "level = Enchant Level, count = Enchant Quantity\uff0crepair = Item Repair Cost", "https://www.programmersought.com/article/37855909509", "Use the format like:", "level", "( level + repair )", "( level * 3 )", "10", "( ( level / 3 ) + 1 )", "count", "( level + count )"}).define("power_expression", (Object)"level");
        REPORT_EXPRESSION = builder.comment(new String[]{"Report the computed expressions", "Use the format power_expression describe"}).define("report_expression", (Object)"count");
        COST = builder.comment(new String[]{"Item cost when disenchant.", "Use the format like \"minecraft:emerald\" or \"minecraft:diamond\""}).define("cost", (Object)"minecraft:emerald");
        TYPE = builder.comment("Disenchant type will not be editable").defineEnum("type", (Enum)EnumType.DEFAULT);
        PAGE_TURN = builder.comment("True if page turn is allowed").define("page_turn", true);
        STRICT_MODE = builder.comment("True if allow enchant are incompatible").define("strict_mode", false);
        builder.pop();
        CONFIG = builder.build();
    }
}

