/*
 * Decompiled with CFR 0.152.
 */
package com.jiggo.editenchanting.client.handler;

import com.jiggo.editenchanting.common.config.DisenchantmentTableConfig;
import com.jiggo.editenchanting.common.enums.EnumPower;
import com.jiggo.editenchanting.common.enums.EnumType;
import com.jiggo.editenchanting.common.inventory.DisenchantmentMenu;
import com.jiggo.editenchanting.common.util.ExpressionUtils;
import com.jiggo.editenchanting.common.util.TextComponentUtils;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class TooltipHandler {
    @SubscribeEvent
    public void onDisenchantmentContainer(ItemTooltipEvent event) {
        EnumPower power = (EnumPower)((Object)DisenchantmentTableConfig.POWER.get());
        if (power == EnumPower.NONE) {
            return;
        }
        Player player = event.getEntity();
        if (player == null) {
            return;
        }
        if (player.f_36096_ instanceof DisenchantmentMenu) {
            DisenchantmentMenu container = (DisenchantmentMenu)player.f_36096_;
            ItemStack stack = event.getItemStack();
            List lines = event.getToolTip();
            if (stack == container.getEnchantingStack()) {
                Map<Enchantment, Integer> maps = container.getLogic().getEnchantments(stack);
                if (!maps.isEmpty()) {
                    int value = (int)Math.floor(ExpressionUtils.getCost(maps, stack.m_41610_()));
                    lines.addAll(1, TextComponentUtils.getToolTip(TextComponentUtils.translatable("desc.editenchanting.export"), value));
                }
            } else if (this.contains(player, stack)) {
                if (DisenchantmentTableConfig.TYPE.get() == EnumType.DISENCHANT) {
                    return;
                }
                if (stack.m_41720_() instanceof EnchantedBookItem && !EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty() && !container.getEnchantingStack().m_41619_()) {
                    int value = (int)Math.floor(ExpressionUtils.getCost(stack));
                    lines.addAll(1, TextComponentUtils.getToolTip(TextComponentUtils.translatable("desc.editenchanting.edit"), value));
                }
            } else if (this.contains(container, stack) && !EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty()) {
                int value = (int)Math.floor(ExpressionUtils.getCost(stack));
                lines.addAll(1, TextComponentUtils.getToolTip(TextComponentUtils.translatable("desc.editenchanting.cost"), value));
            }
        }
    }

    @SubscribeEvent
    public void onGatherComponents(RenderTooltipEvent.GatherComponents event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        AbstractContainerMenu menu = Minecraft.m_91087_().f_91074_.f_36096_;
        if (menu instanceof DisenchantmentMenu && event.getItemStack() == ItemStack.f_41583_) {
            int width = Integer.parseInt(I18n.m_118938_((String)"config.editenchanting.max_text_width", (Object[])new Object[0]));
            event.setMaxWidth(width);
        }
    }

    private boolean contains(Player player, ItemStack stack) {
        return player.m_150109_().f_35974_.contains((Object)stack);
    }

    private boolean contains(DisenchantmentMenu container, ItemStack stack) {
        return container.getBookArrayInventory().contains(stack);
    }
}

