/*
 * Decompiled with CFR 0.152.
 */
package com.jiggo.editenchanting.client.gui;

import com.google.common.collect.Lists;
import com.jiggo.editenchanting.client.gui.ChangePageButton;
import com.jiggo.editenchanting.common.config.DisenchantmentTableConfig;
import com.jiggo.editenchanting.common.enums.EnumDisplay;
import com.jiggo.editenchanting.common.enums.EnumError;
import com.jiggo.editenchanting.common.enums.EnumPower;
import com.jiggo.editenchanting.common.inventory.DisenchantmentMenu;
import com.jiggo.editenchanting.common.inventory.SlotBook;
import com.jiggo.editenchanting.common.inventory.SlotEnchant;
import com.jiggo.editenchanting.common.network.PacketChannel;
import com.jiggo.editenchanting.common.network.PacketClickButton;
import com.jiggo.editenchanting.common.util.EnchantmentUtils;
import com.jiggo.editenchanting.common.util.ExpressionUtils;
import com.jiggo.editenchanting.common.util.TextComponentUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DisenchantmentScreen
extends AbstractContainerScreen<DisenchantmentMenu> {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("editenchanting:textures/gui/container/enchantment_edit_table.png"), new ResourceLocation("editenchanting:textures/gui/container/enchantment_edit_table2.png")};
    private static final int BUTTON_UP = 0;
    private static final int BUTTON_DOWN = 1;
    private static final int BUTTON_OK = 2;
    private EnumDisplay display = EnumDisplay.NONE;

    public DisenchantmentScreen(DisenchantmentMenu container, Inventory inventory, Component title) {
        super((AbstractContainerMenu)container, inventory, title);
        this.f_97726_ = 194;
        this.f_97727_ = 166;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new ChangePageButton(this.f_97735_ + 12, this.f_97736_ + 50, 18, 18, 0, this.f_97727_ + 1, 18, TEXTURES[0], button -> DisenchantmentScreen.send(0)));
        this.m_142416_((GuiEventListener)new ChangePageButton(this.f_97735_ + 32, this.f_97736_ + 50, 18, 18, 18, this.f_97727_ + 1, 18, TEXTURES[0], button -> DisenchantmentScreen.send(1)));
        this.m_142416_((GuiEventListener)new ChangePageButton(this.f_97735_ + 52, this.f_97736_ + 50, 18, 18, 36, this.f_97727_ + 1, 18, TEXTURES[0], button -> {
            DisenchantmentMenu container = (DisenchantmentMenu)this.f_97732_;
            Player player = container.getPlayer();
            if (ExpressionUtils.canReport(player, container.getEnchantingStack())) {
                container.setError(EnumError.NONE);
                DisenchantmentScreen.send(2);
            } else if (!EnchantmentUtils.isEmpty(container.getEnchantingStack())) {
                container.setError(EnumError.EXPORT);
                container.setErrorStack(container.getEnchantingStack().m_41777_());
            }
        }));
    }

    public static void send(int type) {
        PacketChannel.INSTANCE.sendToServer((Object)new PacketClickButton(type));
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        RenderSystem.disableBlend();
        this.m_280072_(graphics, mouseX, mouseY);
        this.renderDetails(graphics);
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        ResourceLocation texture = TEXTURES[DisenchantmentTableConfig.POWER.get() != EnumPower.ITEM ? 0 : 1];
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(texture, x, y, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics graphics, int p_282681_, int p_283686_) {
        String title = I18n.m_118938_((String)"tile.container.disenchant", (Object[])new Object[0]);
        graphics.drawString(this.f_96547_, title, (float)(this.f_97726_ / 5 - this.f_96547_.m_92895_(title) / 2 + 3), 5.0f, 0x404040, false);
        graphics.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 96 + 2, 0x404040, false);
    }

    protected void renderDetails(GuiGraphics graphics) {
        if (!((DisenchantmentMenu)this.f_97732_).getEnchantingStack().m_41619_() && DisenchantmentTableConfig.POWER.get() != EnumPower.NONE) {
            int leftPos = (this.f_96543_ - this.f_97726_) / 2;
            int topPos = (this.f_96544_ - this.f_97727_) / 2;
            int position = Integer.parseInt(I18n.m_118938_((String)"config.editenchanting.position", (Object[])new Object[0]));
            List<Component> components = this.getTextLines();
            int offset = components.size() == 1 ? 30 : 15;
            graphics.m_280677_(this.f_96547_, components, Optional.empty(), leftPos - position, topPos + offset);
        }
    }

    public List<Component> getTextLines() {
        DisenchantmentMenu container = (DisenchantmentMenu)this.f_97732_;
        Player player = (Player)Objects.requireNonNull(Minecraft.m_91087_().f_91074_);
        ArrayList lines = Lists.newArrayList();
        this.display = ((DisenchantmentMenu)this.f_97732_).m_142621_().m_41619_() ? (this.f_97734_ != null && this.f_97734_.m_6657_() ? (this.f_97734_ instanceof SlotBook ? EnumDisplay.BOOK : (this.f_97734_ instanceof SlotEnchant ? EnumDisplay.DISENCHANT : (this.f_97734_.m_7993_().m_41720_() instanceof EnchantedBookItem && player.m_150109_().f_35974_.contains((Object)this.f_97734_.m_7993_()) ? EnumDisplay.PLAYER : EnumDisplay.DISENCHANT))) : (!container.getEnchantingStack().m_41619_() ? EnumDisplay.DISENCHANT : EnumDisplay.NONE)) : (!container.getEnchantingStack().m_41619_() ? EnumDisplay.DISENCHANT : EnumDisplay.NONE);
        switch (this.display) {
            case DISENCHANT: {
                ItemStack enchanting = container.getEnchantingStack();
                lines.add(TextComponentUtils.translatable("desc.editenchanting.enchant_slot").m_130940_(ChatFormatting.GRAY));
                lines.add(TextComponentUtils.getItem(enchanting));
                lines.add(TextComponentUtils.EMPTY);
                if (EnchantmentUtils.isEmpty(enchanting)) break;
                lines.add(TextComponentUtils.translatable("desc.editenchanting.export").m_130940_(ChatFormatting.GRAY));
                lines.add(TextComponentUtils.getExportCost(enchanting));
                lines.add(TextComponentUtils.EMPTY);
                break;
            }
            case BOOK: {
                ItemStack book = this.f_97734_.m_7993_();
                lines.add(TextComponentUtils.translatable("desc.editenchanting.book_slot").m_130940_(ChatFormatting.GRAY));
                lines.add(TextComponentUtils.getEnchant(book));
                lines.add(TextComponentUtils.EMPTY);
                lines.add(TextComponentUtils.translatable("desc.editenchanting.cost").m_130940_(ChatFormatting.GRAY));
                lines.add(TextComponentUtils.getCost(book));
                lines.add(TextComponentUtils.EMPTY);
                break;
            }
            case PLAYER: {
                ItemStack stack = this.f_97734_.m_7993_();
                lines.add(TextComponentUtils.translatable("desc.editenchanting.book_slot").m_130940_(ChatFormatting.GRAY));
                int size = EnchantmentHelper.m_44831_((ItemStack)stack).size();
                if (size > 1) {
                    if (this.isShift()) {
                        lines.addAll(TextComponentUtils.getEnchantTexts(stack));
                    } else {
                        lines.add(TextComponentUtils.translatable("desc.editenchanting.shift").m_130940_(ChatFormatting.DARK_GRAY));
                    }
                } else {
                    lines.add(TextComponentUtils.getEnchant(stack));
                }
                lines.add(TextComponentUtils.EMPTY);
                if (size != 1 && (size <= 1 || this.isShift())) break;
                lines.add(TextComponentUtils.translatable("desc.editenchanting.edit").m_130940_(ChatFormatting.GRAY));
                lines.add(TextComponentUtils.getCost(stack));
                lines.add(TextComponentUtils.EMPTY);
            }
        }
        if (container.getError() != EnumError.NONE) {
            lines.add(TextComponentUtils.translatable("desc.editenchanting.tip").m_130940_(ChatFormatting.YELLOW));
            lines.add(TextComponentUtils.getRequire());
            lines.add(TextComponentUtils.EMPTY);
            lines.addAll(TextComponentUtils.getRequire(container.getError(), container.getErrorStack()));
            lines.add(TextComponentUtils.EMPTY);
        }
        return lines;
    }

    private boolean isShift() {
        return Screen.m_96638_();
    }
}

