/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public record UpdateBuildingToolPacket(boolean toServer, InteractionHand hand, Optional<BuildingToolMode> mode, Map<ToolModeProperty<?>, Object> properties, Optional<BlockPos> posA, Optional<BlockPos> posB, boolean clearPoses, Optional<WeightedRandomList<WeightedEntry.Wrapper<BlockState>>> pallete, Optional<Integer> reachDistanceModifier, Optional<Float> cornerReachDistance) {
    public static Builder builder() {
        return new Builder();
    }

    public static void encoder(UpdateBuildingToolPacket packet, FriendlyByteBuf buff) {
        buff.writeBoolean(packet.toServer);
        buff.writeBoolean(packet.hand == InteractionHand.MAIN_HAND);
        UpdateBuildingToolPacket.writeOptional(buff, packet.mode.map(BuildingToolMode::getName), arg_0 -> ((FriendlyByteBuf)buff).m_130085_(arg_0));
        buff.writeInt(packet.properties.size());
        for (Map.Entry<ToolModeProperty<?>, Object> entry : packet.properties.entrySet()) {
            ToolModeProperty<?> property = entry.getKey();
            buff.m_130070_(property.getKey());
            buff.m_130070_(property.write(entry.getValue()));
        }
        UpdateBuildingToolPacket.writeOptional(buff, packet.posA, arg_0 -> ((FriendlyByteBuf)buff).m_130064_(arg_0));
        UpdateBuildingToolPacket.writeOptional(buff, packet.posB, arg_0 -> ((FriendlyByteBuf)buff).m_130064_(arg_0));
        buff.writeBoolean(packet.clearPoses);
        UpdateBuildingToolPacket.writeOptional(buff, packet.pallete, states -> {
            List list = states.m_146338_();
            buff.writeInt(list.size());
            for (WeightedEntry.Wrapper state : list) {
                buff.m_130079_(NbtUtils.m_129202_((BlockState)((BlockState)state.m_146310_())));
                buff.writeInt(state.m_142631_().m_146281_());
            }
        });
        UpdateBuildingToolPacket.writeOptional(buff, packet.reachDistanceModifier, arg_0 -> ((FriendlyByteBuf)buff).writeInt(arg_0));
        UpdateBuildingToolPacket.writeOptional(buff, packet.cornerReachDistance, arg_0 -> ((FriendlyByteBuf)buff).writeFloat(arg_0));
    }

    private static <T> void writeOptional(FriendlyByteBuf buff, Optional<T> optional, Consumer<T> write) {
        buff.writeBoolean(optional.isPresent());
        if (optional.isPresent()) {
            write.accept(optional.get());
        }
    }

    public static UpdateBuildingToolPacket decoder(FriendlyByteBuf buff) {
        boolean toServer = buff.readBoolean();
        InteractionHand hand = buff.readBoolean() ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        Optional<BuildingToolMode> mode = UpdateBuildingToolPacket.readOptional(buff, () -> ((FriendlyByteBuf)buff).m_130281_(), () -> null).map(BuildingToolModes.REGISTRY::get);
        HashMap properties = new HashMap();
        int propertiesSize = buff.readInt();
        if (!mode.isPresent() && propertiesSize > 0) {
            StructureGelMod.LOGGER.warn("Can't read building tool properties from packet because no mode was sent", new Object[0]);
        } else {
            for (int i = 0; i < propertiesSize; ++i) {
                String k = buff.m_130277_();
                String v = buff.m_130277_();
                ToolModeProperty<?> property = mode.get().getProperties().get(k);
                properties.put(property, property.read(v));
            }
        }
        Optional<BlockPos> posA = UpdateBuildingToolPacket.readOptional(buff, () -> ((FriendlyByteBuf)buff).m_130135_(), () -> null);
        Optional<BlockPos> posB = UpdateBuildingToolPacket.readOptional(buff, () -> ((FriendlyByteBuf)buff).m_130135_(), () -> null);
        boolean clearPoses = buff.readBoolean();
        Optional<WeightedRandomList<WeightedEntry.Wrapper<BlockState>>> pallete = UpdateBuildingToolPacket.readOptional(buff, () -> {
            SimpleWeightedRandomList.Builder palleteBuilder = SimpleWeightedRandomList.m_146263_();
            int size = buff.readInt();
            for (int i = 0; i < size; ++i) {
                BlockState state = NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)buff.m_130260_());
                int weight = buff.readInt();
                palleteBuilder.m_146271_((Object)state, weight);
            }
            return palleteBuilder.m_146270_();
        }, () -> null);
        Optional<Integer> reachDistanceModifier = UpdateBuildingToolPacket.readOptional(buff, () -> ((FriendlyByteBuf)buff).readInt(), () -> 0);
        Optional<Float> cornerReachDistance = UpdateBuildingToolPacket.readOptional(buff, () -> ((FriendlyByteBuf)buff).readFloat(), () -> Float.valueOf(0.0f));
        return new UpdateBuildingToolPacket(toServer, hand, mode, properties, posA, posB, clearPoses, pallete, reachDistanceModifier, cornerReachDistance);
    }

    private static <T> Optional<T> readOptional(FriendlyByteBuf buff, Supplier<T> read, Supplier<T> defaultVal) {
        boolean isPresent = buff.readBoolean();
        return Optional.ofNullable(isPresent ? read.get() : defaultVal.get());
    }

    public static void handler(UpdateBuildingToolPacket packet, Supplier<NetworkEvent.Context> context) {
        if (packet.toServer) {
            context.get().enqueueWork(() -> UpdateBuildingToolPacket.handle(packet, (Player)((NetworkEvent.Context)context.get()).getSender()));
        } else {
            context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> UpdateBuildingToolPacket.handleClient(packet)));
        }
        context.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClient(UpdateBuildingToolPacket packet) {
        UpdateBuildingToolPacket.handle(packet, (Player)Minecraft.m_91087_().f_91074_);
    }

    private static void handle(UpdateBuildingToolPacket packet, Player player) {
        InteractionHand hand = packet.hand;
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
            int reach;
            if (packet.mode.isPresent()) {
                BuildingToolMode mode = packet.mode.get();
                BuildingToolItem.setMode(stack, mode);
                mode.onSelect(stack, player.m_9236_(), player);
                if (mode instanceof BuildingToolMode.ForCorners) {
                    BuildingToolMode.ForCorners forCorners = (BuildingToolMode.ForCorners)mode;
                    if (packet.posA.isPresent()) {
                        forCorners.setPositionA(player, packet.posA.get(), stack, false);
                    }
                    if (packet.posB.isPresent()) {
                        forCorners.setPositionB(player, packet.posB.get(), stack, false);
                    }
                }
                if (packet.clearPoses) {
                    mode.clearPoses(stack, player);
                }
            }
            for (Map.Entry entry : packet.properties.entrySet()) {
                ToolModeProperty prop = (ToolModeProperty)entry.getKey();
                BuildingToolItem.setProperty(stack, prop, entry.getValue());
            }
            if (packet.pallete.isPresent()) {
                BuildingToolItem.setPallete(stack, packet.pallete.get());
            }
            if (packet.reachDistanceModifier.isPresent() && ToolModeProperty.REACH_DISTANCE.isValid(reach = packet.reachDistanceModifier.get().intValue()) && reach != BuildingToolItem.getReachDistanceModifier(stack)) {
                BuildingToolItem.setReachDistanceModifier(stack, reach);
            }
            if (packet.cornerReachDistance.isPresent()) {
                BuildingToolItem.setSelectedCornerDistance(stack, packet.cornerReachDistance.get().floatValue());
            }
            player.m_6674_(hand);
        }
    }

    public static class Builder {
        boolean toServer = true;
        InteractionHand hand = InteractionHand.MAIN_HAND;
        Optional<BuildingToolMode> mode = Optional.empty();
        Map<ToolModeProperty<?>, Object> properties = Map.of();
        Optional<BlockPos> posA = Optional.empty();
        Optional<BlockPos> posB = Optional.empty();
        boolean clearPoses = false;
        Optional<WeightedRandomList<WeightedEntry.Wrapper<BlockState>>> pallete = Optional.empty();
        Optional<Integer> reachDistanceModifier = Optional.empty();
        Optional<Float> cornerReachDistance = Optional.empty();

        private Builder() {
        }

        public Builder toClient() {
            this.toServer = false;
            return this;
        }

        public Builder toServer() {
            this.toServer = true;
            return this;
        }

        public Builder hand(InteractionHand hand) {
            this.hand = hand;
            return this;
        }

        public Builder mode(BuildingToolMode mode) {
            this.mode = Optional.ofNullable(mode);
            return this;
        }

        public Builder properties(Map<ToolModeProperty<?>, Object> properties) {
            this.properties = properties;
            return this;
        }

        public Builder posA(Optional<BlockPos> posA) {
            this.posA = posA;
            return this;
        }

        public Builder posB(Optional<BlockPos> posB) {
            this.posB = posB;
            return this;
        }

        public Builder clearPoses(boolean clearPoses) {
            this.clearPoses = clearPoses;
            return this;
        }

        public Builder pallete(WeightedRandomList<WeightedEntry.Wrapper<BlockState>> states) {
            this.pallete = Optional.ofNullable(states);
            return this;
        }

        public Builder reachDistance(int reachDistance) {
            this.reachDistanceModifier = Optional.of(reachDistance);
            return this;
        }

        public Builder cornerReachDistance(float cornerReachDistance) {
            this.cornerReachDistance = Optional.of(Float.valueOf(cornerReachDistance));
            return this;
        }

        public UpdateBuildingToolPacket build() {
            return new UpdateBuildingToolPacket(this.toServer, this.hand, this.mode, this.properties, this.posA, this.posB, this.clearPoses, this.pallete, this.reachDistanceModifier, this.cornerReachDistance);
        }
    }
}

