/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data_handler.handlers;

import com.legacy.structure_gel.api.block_entity.IRotatable;
import com.legacy.structure_gel.api.data_handler.DataHandlerType;
import com.legacy.structure_gel.api.data_handler.handlers.ProbabilityDataHandler;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;

public class BlockStateHandler
extends ProbabilityDataHandler<BlockStateHandler> {
    private static final DataParser PARSER = DataParser.of(DataHandlerType.BLOCK_STATE, parser -> {
        parser.add("block_state", Blocks.f_50016_.m_49966_());
        parser.add("tag", new CompoundTag());
        parser.add("generation_chance", 1.0f, 0.0f, 1.0f);
    });
    private final BlockState blockState;
    private final CompoundTag tag;

    public BlockStateHandler(DataMap data) {
        super(data, "generation_chance");
        this.blockState = data.get("block_state", BlockState.class);
        this.tag = data.get("tag", CompoundTag.class);
    }

    public static DataParser parser() {
        return PARSER;
    }

    @Override
    protected void handle(BlockState dataHandler, BlockPos pos, WorldGenLevel level, RandomSource rand, BoundingBox bounds, StructurePiece piece) {
        BlockState state = this.createState(dataHandler, this.blockState);
        level.m_7731_(pos, state, 18);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.m_142466_(this.tag);
            if (blockEntity instanceof IRotatable) {
                IRotatable r = (IRotatable)blockEntity;
                r.transform(piece.m_163587_(), piece.m_6830_());
            }
            blockEntity.m_6596_();
        }
        if (level instanceof ServerLevel) {
            BlockState updatedState = level.m_8055_(pos);
            ((ServerLevel)level).m_7260_(pos, updatedState, updatedState, 3);
        }
    }
}

