/*
 * Decompiled with CFR 0.152.
 */
package com.jkdr.abyssalascentdimensionpatcher.util;

import com.jkdr.abyssalascentdimensionpatcher.util.FormattingCore;
import com.jkdr.abyssalascentdimensionpatcher.util.ModInternalConfig;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerMessages {
    public static final SoundEvent BLOCKBREAKSOUND = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ModInternalConfig.blockBreakFailSoundLocation);
    private static Optional<Holder<SoundEvent>> optionalHolder = ForgeRegistries.SOUND_EVENTS.getHolder((Object)BLOCKBREAKSOUND);

    public static void welcome(ServerPlayer player) {
        player.m_213846_(FormattingCore.serverTranslate("message.abyssalascentdimensionpatcher.welcome", FormattingCore.createPrefixWithFormatting(), "discord", FormattingCore.createCommandClickableComponent("discord")));
    }

    public static void discord(ServerPlayer player) {
        player.m_213846_(FormattingCore.serverTranslate("message.abyssalascentdimensionpatcher.discordnotice", FormattingCore.createPrefixWithFormatting(), FormattingCore.createExternalLinkClickableComponent("https://discord.com/invite/Z35BDKFEXu", true)));
    }

    public static void spawnStructureNew(ServerPlayer player, BlockPos pos) {
        player.m_213846_(FormattingCore.serverTranslate("message.abyssalascentdimensionpatcher.structurepos", FormattingCore.createPrefixWithFormatting(), pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
    }

    public static void pickaxeWeak(ServerPlayer player, BlockPos sourceBlock) {
        if (BLOCKBREAKSOUND != null) {
            player.m_9236_().m_6263_(null, (double)sourceBlock.m_123341_() + 0.5, (double)sourceBlock.m_123342_() + 0.5, (double)sourceBlock.m_123343_() + 0.5, BLOCKBREAKSOUND, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        player.m_240418_(FormattingCore.serverTranslate("message.abyssalascentdimensionpatcher.failedBlockBreak", ChatFormatting.RED, new Object[0]), true);
    }

    public static void invalidSourceMine(Level level, BlockPos sourceBlock) {
        if (BLOCKBREAKSOUND != null) {
            level.m_6263_(null, (double)sourceBlock.m_123341_() + 0.5, (double)sourceBlock.m_123342_() + 0.5, (double)sourceBlock.m_123343_() + 0.5, BLOCKBREAKSOUND, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

