/*
 * Decompiled with CFR 0.152.
 */
package com.jkdr.abyssalascentdimensionpatcher.util;

import com.jkdr.abyssalascentdimensionpatcher.util.IDimStackCacheAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackEntry;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackInfo;
import qouteall.imm_ptl.peripheral.dim_stack.DimStackManagement;

public class ServerDimStackLevelLoaded {
    private static List<ServerLevel> dimensionLevels = List.of();
    private static int listLength = 0;
    private static final byte TICK_UNKNOWN = 0;
    private static final byte TICK_TRUE = 1;
    private static final byte TICK_FALSE = 2;
    private static byte[] dimensionTickStatus = new byte[0];

    public static void initDimensionStackKeysinitDimensionStackKeys(MinecraftServer server) {
        DimStackInfo info = DimStackManagement.getDimStackPreset();
        List entries = info == null || info.entries == null ? List.of() : info.entries.stream().filter(Objects::nonNull).toList();
        ArrayList<ServerLevel> mutableLevels = new ArrayList<ServerLevel>();
        for (int i = 0; i < entries.size(); ++i) {
            DimStackEntry e = (DimStackEntry)entries.get(i);
            String idStr = e.dimensionIdStr;
            if (idStr == null) continue;
            try {
                ResourceLocation rl = new ResourceLocation(idStr);
                ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)rl);
                ServerLevel lvl = server.m_129880_(key);
                if (lvl == null) continue;
                ((IDimStackCacheAccessor)lvl).setIndexForImmersivePortalsDimstackCache(i);
                mutableLevels.add(lvl);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        dimensionLevels = List.copyOf(mutableLevels);
        listLength = dimensionLevels.size();
        dimensionTickStatus = new byte[listLength];
        Arrays.fill(dimensionTickStatus, (byte)0);
    }

    public static void resetDimensionTickingFlags() {
        if (dimensionTickStatus == null || dimensionTickStatus.length != listLength) {
            dimensionTickStatus = new byte[listLength];
        }
        Arrays.fill(dimensionTickStatus, (byte)0);
    }

    public static boolean shouldDimensionBeTicking(ServerLevel level) {
        ServerLevel aboveLvl;
        ServerLevel belowLvl;
        int idx = ((IDimStackCacheAccessor)level).getIndexForImmersivePortalsDimstackCache();
        if (idx == -1) {
            return !level.m_6907_().isEmpty();
        }
        if (idx < 0 || idx >= listLength) {
            return !level.m_6907_().isEmpty();
        }
        byte cached = dimensionTickStatus[idx];
        if (cached != 0) {
            return cached == 1;
        }
        if (!level.m_6907_().isEmpty()) {
            ServerDimStackLevelLoaded.dimensionTickStatus[idx] = 1;
            return true;
        }
        int below = idx - 1;
        if (below >= 0 && !(belowLvl = dimensionLevels.get(below)).m_6907_().isEmpty()) {
            ServerDimStackLevelLoaded.dimensionTickStatus[idx] = 1;
            return true;
        }
        int above = idx + 1;
        if (above < listLength && !(aboveLvl = dimensionLevels.get(above)).m_6907_().isEmpty()) {
            ServerDimStackLevelLoaded.dimensionTickStatus[idx] = 1;
            return true;
        }
        ServerDimStackLevelLoaded.dimensionTickStatus[idx] = 2;
        return false;
    }
}

