/*
 * Decompiled with CFR 0.152.
 */
package com.jkdr.abyssalascentdimensionpatcher.mixins.patch.spawn;

import com.jkdr.abyssalascentdimensionpatcher.events.playerSpawnServerEvents;
import com.jkdr.abyssalascentdimensionpatcher.util.ModInternalConfig;
import com.mojang.logging.LogUtils;
import io.redspace.ironsspellbooks.spells.ender.RecallSpell;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RecallSpell.class}, priority=2000)
public abstract class MixinRecallSpell {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Inject(method={"findSpawnPosition"}, at={@At(value="RETURN")}, cancellable=true, remap=false)
    private static void onFindSpawnPositionReturn(ServerLevel level, ServerPlayer player, CallbackInfoReturnable<Optional<Vec3>> cir) {
        Optional original = (Optional)cir.getReturnValue();
        if (original.isEmpty() && player.m_8963_() != null) {
            cir.setReturnValue(Optional.of(MixinRecallSpell.getRespawnPosition(player)));
            cir.cancel();
        }
    }

    private static Vec3 getRespawnPosition(ServerPlayer player) {
        if (player.m_8961_() == null) {
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return Vec3.f_82478_;
            }
            ServerLevel undergardenLevel = server.m_129880_(ModInternalConfig.playerSpawnDimension);
            if (undergardenLevel == null) {
                return Vec3.f_82478_;
            }
            BlockPos rawPos = playerSpawnServerEvents.getSpawnCoordinates(undergardenLevel);
            BlockPos adjustedPos = rawPos.m_7918_(-5, 1, 3);
            return Vec3.m_82512_((Vec3i)adjustedPos);
        }
        return Vec3.m_82512_((Vec3i)player.m_8961_());
    }
}

