/*
 * Decompiled with CFR 0.152.
 */
package com.jkdr.abyssalascentdimensionpatcher.mixins.feature.blockRules;

import com.jkdr.abyssalascentdimensionpatcher.data.dimensionRoofData;
import com.jkdr.abyssalascentdimensionpatcher.interfaces.ServerLevelDataAccessor;
import com.jkdr.abyssalascentdimensionpatcher.util.IDimStackCacheAccessor;
import com.jkdr.abyssalascentdimensionpatcher.util.ServerDimStackLevelLoaded;
import java.util.List;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.ticks.LevelTicks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLevel.class})
public abstract class MixinServerLevel
implements ServerLevelDataAccessor,
IDimStackCacheAccessor {
    @Shadow
    private boolean f_8557_;
    @Shadow
    @Final
    private SleepStatus f_143245_;
    @Shadow
    @Final
    private List<ServerPlayer> f_8546_;
    @Shadow
    @Final
    private PersistentEntitySectionManager<Entity> f_143244_;
    @Shadow
    @Final
    private LevelTicks<Block> f_8553_;
    @Shadow
    @Final
    private LevelTicks<Fluid> f_184047_;
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"AbyssalAscentPatcher");
    private int dimensionStackAssociatedId = -1;
    @Unique
    private dimensionRoofData roofData;

    @Shadow
    protected abstract void m_8809_();

    @Invoker(value="advanceWeatherCycle")
    abstract void invokeAdvanceWeatherCycle();

    @Invoker(value="runBlockEvents")
    abstract void invokeRunBlockEvents();

    @Invoker(value="tickBlock")
    abstract void invokeTickBlock(BlockPos var1, Block var2);

    @Invoker(value="tickFluid")
    abstract void invokeTickFluid(BlockPos var1, Fluid var2);

    @Override
    public void setIndexForImmersivePortalsDimstackCache(int i) {
        this.dimensionStackAssociatedId = i;
    }

    @Override
    public int getIndexForImmersivePortalsDimstackCache() {
        return this.dimensionStackAssociatedId;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void onServerLevelTick(CallbackInfo ci) {
        ServerLevel level = (ServerLevel)this;
        this.f_8557_ = true;
        if (!ServerDimStackLevelLoaded.shouldDimensionBeTicking(level)) {
            ProfilerFiller profiler = level.m_46473_();
            this.f_8557_ = true;
            BooleanSupplier tickLimiter = () -> false;
            this.m_8809_();
            profiler.m_6182_("tickPending");
            long gameTime = level.m_46467_();
            profiler.m_7238_();
            ci.cancel();
        }
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initRoofData(CallbackInfo ci) {
        ServerLevel self = (ServerLevel)this;
        ResourceKey dim = self.m_46472_();
        if (dim.m_135782_().equals((Object)new ResourceLocation("infinite_abyss", "first_layer"))) {
            LOGGER.info("INIT BLOCK BREAKING ACTIONS FOR {}", (Object)dim);
            this.roofData = new dimensionRoofData(self, List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "tectonic_abyssal_pickaxe"))), List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "obsidian"))), 123);
        } else if (dim.m_135782_().equals((Object)new ResourceLocation("deeperdarker", "otherside"))) {
            LOGGER.info("INIT BLOCK BREAKING ACTIONS FOR {}", (Object)dim);
            this.roofData = new dimensionRoofData(self, List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "tectonic_abyssal_pickaxe"))), List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "obsidian"))), 123);
        } else if (dim.m_135782_().equals((Object)new ResourceLocation("infernalcross", "dimension"))) {
            LOGGER.info("INIT BLOCK BREAKING ACTIONS FOR {}", (Object)dim);
            this.roofData = new dimensionRoofData(self, List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("cataclysm", "black_steel_pickaxe")), ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "tectonic_abyssal_pickaxe"))), List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "packed_mud")), ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("alexscaves", "coprolith")), ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("alexscaves", "guanostone")), ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "obsidian"))), 59);
        } else if (dim.m_135782_().equals((Object)new ResourceLocation("dimension_of_caves", "cave"))) {
            LOGGER.info("INIT BLOCK BREAKING ACTIONS FOR {}", (Object)dim);
            this.roofData = new dimensionRoofData(self, List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("cataclysm", "black_steel_pickaxe")), ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "tectonic_abyssal_pickaxe"))), List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "obsidian"))), 59);
        } else if (dim.m_135782_().equals((Object)new ResourceLocation("oceanworld", "deepsea"))) {
            LOGGER.info("INIT BLOCK BREAKING ACTIONS FOR {}", (Object)dim);
            this.roofData = new dimensionRoofData(self, List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("cataclysm", "black_steel_pickaxe")), ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "tectonic_abyssal_pickaxe"))), List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "obsidian"))), 59);
        } else if (dim.m_135782_().equals((Object)new ResourceLocation("minecraft", "the_nether"))) {
            LOGGER.info("INIT BLOCK BREAKING ACTIONS FOR {}", (Object)dim);
            this.roofData = new dimensionRoofData(self, List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "ignitium_pickaxe")), ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("cataclysm", "black_steel_pickaxe")), ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "tectonic_abyssal_pickaxe"))), List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "obsidian"))), 250);
        } else if (dim.m_135782_().equals((Object)new ResourceLocation("undergarden", "undergarden"))) {
            LOGGER.info("INIT BLOCK BREAKING ACTIONS FOR {}", (Object)dim);
            this.roofData = new dimensionRoofData(self, List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "arcane_steel_pickaxe")), ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("minecraft", "netherite_pickaxe")), ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "ignitium_pickaxe")), ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("cataclysm", "black_steel_pickaxe")), ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("kubejs", "tectonic_abyssal_pickaxe"))), List.of(ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("kubejs", "hard_depthrock")), ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("minecraft", "obsidian"))), null);
        } else {
            this.roofData = new dimensionRoofData(self, List.of(), List.of(), 999);
        }
    }

    @Override
    @Unique
    public dimensionRoofData getRoofData() {
        return this.roofData;
    }
}

