/*
 * Decompiled with CFR 0.152.
 */
package com.jkdr.abyssalascentdimensionpatcher.events;

import com.google.common.collect.ImmutableSet;
import com.jkdr.abyssalascentdimensionpatcher.data.SpawnPosData;
import com.jkdr.abyssalascentdimensionpatcher.util.ModInternalConfig;
import com.jkdr.abyssalascentdimensionpatcher.util.ServerDimStackLevelLoaded;
import com.jkdr.abyssalascentdimensionpatcher.util.ServerMessages;
import com.jkdr.abyssalascentdimensionpatcher.util.StructureSpawning;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="abyssalascentdimensionpatcher", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class playerSpawnServerEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static Set<Block> VALID_GROUND_BLOCKS = null;
    private static final ResourceKey<Biome> FORCESPAWNINBIOME = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("undergarden", "gronglegrowth"));

    private static Set<Block> getValidGroundBlocks() {
        if (VALID_GROUND_BLOCKS == null) {
            VALID_GROUND_BLOCKS = (Set)ImmutableSet.of((Object)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("undergarden", "deepturf_block"))), (Object)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("undergarden", "frozen_deepturf_block"))), (Object)((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("undergarden", "deepsoil")))).stream().filter(Objects::nonNull).filter(block -> block != Blocks.f_50016_).collect(ImmutableSet.toImmutableSet());
            LOGGER.info("Built the valid ground blocks set. Found {} blocks.", (Object)VALID_GROUND_BLOCKS.size());
        }
        return VALID_GROUND_BLOCKS;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerDimStackLevelLoaded.resetDimensionTickingFlags();
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        LOGGER.info("Initated server level optimsations, will not tick any dimensions surrounding the player");
        ServerDimStackLevelLoaded.initDimensionStackKeysinitDimensionStackKeys(event.getServer());
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerDimStackLevelLoaded.resetDimensionTickingFlags();
    }

    @SubscribeEvent
    public static void onPlayerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MinecraftServer server = player.m_20194_();
        ResourceKey toDim = event.getTo();
        ServerLevel toWorld = server.m_129880_(toDim);
        LOGGER.info("Server level {} has {} players", (Object)toWorld, (Object)toWorld.m_6907_().size());
        ServerDimStackLevelLoaded.resetDimensionTickingFlags();
    }

    @SubscribeEvent
    public static void onPlayerFirstJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerDimStackLevelLoaded.resetDimensionTickingFlags();
        ServerPlayer player = (ServerPlayer)event.getEntity();
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        ServerLevel undergardenLevel = server.m_129880_(ModInternalConfig.playerSpawnDimension);
        if (undergardenLevel == null) {
            LOGGER.error("Undergarden dimension not found! Cannot set spawn.");
            return;
        }
        playerSpawnServerEvents.spawnStructure(player, undergardenLevel);
        CompoundTag persistent = player.getPersistentData().m_128469_("PlayerPersisted");
        if (persistent.m_128471_("abyssal_ascent_first_join")) {
            return;
        }
        persistent.m_128379_("abyssal_ascent_first_join", true);
        player.getPersistentData().m_128365_("PlayerPersisted", (Tag)persistent);
        ServerMessages.welcome(player);
        Advancement advancement = player.m_20194_().m_129889_().m_136041_(new ResourceLocation("minecraft", "story/enter_the_nether"));
        if (advancement == null) {
            LOGGER.error("Why don't we have vanilla achievements? Abyssal Ascent Error: Most likely a modified instance");
        }
        AdvancementProgress progress = player.m_8960_().m_135996_(advancement);
        if (player.m_9236_().m_46472_() != Level.f_46428_ || progress.m_8193_()) {
            LOGGER.info("Returning player has joined from before 0.2.2, saying hello! :)");
            ServerMessages.spawnStructureNew(player, playerSpawnServerEvents.getSpawnCoordinates(undergardenLevel));
        } else if (player.m_8961_() == null) {
            BlockPos rawPos = playerSpawnServerEvents.getSpawnCoordinates(undergardenLevel);
            BlockPos adjustedPos = rawPos.m_7918_(0, 4, 0);
            player.m_8999_(undergardenLevel, (double)adjustedPos.m_123341_() + 0.5, (double)adjustedPos.m_123342_(), (double)adjustedPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
            player.m_9158_(ModInternalConfig.playerSpawnDimension, adjustedPos, 0.0f, true, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        if (player.m_8961_() != null || player.m_9236_().m_46472_() != Level.f_46428_) {
            return;
        }
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return;
        }
        ServerLevel undergardenLevel = server.m_129880_(ModInternalConfig.playerSpawnDimension);
        if (undergardenLevel == null) {
            return;
        }
        if (player.m_9236_() == undergardenLevel) {
            return;
        }
        BlockPos rawPos = playerSpawnServerEvents.getSpawnCoordinates(undergardenLevel);
        BlockPos adjustedPos = rawPos.m_7918_(0, 4, 0);
        player.m_8999_(undergardenLevel, (double)adjustedPos.m_123341_() + 0.5, (double)adjustedPos.m_123342_(), (double)adjustedPos.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
        player.m_9158_(ModInternalConfig.playerSpawnDimension, adjustedPos, 0.0f, true, false);
    }

    private static void spawnStructure(ServerPlayer player, ServerLevel level) {
        SpawnPosData spawnData = SpawnPosData.get(level);
        if (spawnData.getSpawnPos() != null) {
            return;
        }
        LOGGER.info("Building spawn structure, didn't exist before");
        BlockPos spawnBlockData = playerSpawnServerEvents.getSpawnCoordinates(level);
        BlockPos offsetStructure = spawnBlockData.m_7918_(-11, -2, -11);
        LOGGER.info("Structure offset: {}, ORIGINAL {}", (Object)offsetStructure, (Object)spawnBlockData);
        StructureSpawning.createSpawnStructure(level, offsetStructure);
    }

    public static BlockPos getSpawnCoordinates(ServerLevel level) {
        SpawnPosData spawnData = SpawnPosData.get(level);
        BlockPos customSpawnPos = spawnData.getSpawnPos();
        if (customSpawnPos == null) {
            BlockPos bedCompatibleSpawn = level.m_220360_();
            Predicate<Holder> biomePredicate = biomeHolder -> biomeHolder.m_203565_(FORCESPAWNINBIOME);
            BiomeSource biomeSource = level.m_7726_().m_8481_().m_62218_();
            RandomState randomState = level.m_7726_().m_214994_();
            Climate.Sampler sampler = randomState.m_224579_();
            RandomSource random = level.m_213780_();
            int searchRadiusInQuarts = 800;
            Pair biomeResult = biomeSource.m_220570_(bedCompatibleSpawn.m_123341_() / 4, bedCompatibleSpawn.m_123342_(), bedCompatibleSpawn.m_123343_() / 4, searchRadiusInQuarts, biomePredicate, random, sampler);
            if (biomeResult != null) {
                bedCompatibleSpawn = (BlockPos)biomeResult.getFirst();
            }
            BlockPos finalSpawnPos = playerSpawnServerEvents.findSafeSpotNearby(level, bedCompatibleSpawn, 16).m_7494_();
            spawnData.setSpawnPos(finalSpawnPos);
            return finalSpawnPos;
        }
        return customSpawnPos;
    }

    public static BlockPos findSafeSpotNearby(ServerLevel level, BlockPos initialPos, int radiusChunks) {
        int baseX = initialPos.m_123341_();
        int baseZ = initialPos.m_123343_();
        for (int dx = -radiusChunks; dx <= radiusChunks; ++dx) {
            for (int dz = -radiusChunks; dz <= radiusChunks; ++dz) {
                int chunkX = (baseX >> 4) + dx;
                int chunkZ = (baseZ >> 4) + dz;
                ChunkAccess chunk = level.m_6522_(chunkX, chunkZ, ChunkStatus.f_62326_, true);
                if (chunk == null) continue;
                int x = (chunkX << 4) + 8;
                int z = (chunkZ << 4) + 8;
                BlockPos candidate = playerSpawnServerEvents.findValidSpawn(level, new BlockPos(x, level.m_151558_() - 15, z));
                if (candidate == null) continue;
                return candidate;
            }
        }
        LOGGER.warn("No safe spawn found nearby, falling back to initialPos, NOT RECOMMENDED (CAN SPAWN IN WALLS)");
        return initialPos;
    }

    public static BlockPos findValidSpawn(ServerLevel level, BlockPos pos) {
        int x = pos.m_123341_();
        int z = pos.m_123343_();
        int airLength = 0;
        BlockPos lastRecordedAir = null;
        for (int y = pos.m_123342_(); y > level.m_141937_() + 30; y -= 4) {
            BlockPos current = new BlockPos(x, y, z);
            if (!level.m_8055_(current).m_60795_()) {
                airLength = 0;
            }
            if (++airLength < 3) continue;
            if (level.m_8055_(pos).m_280296_()) break;
            lastRecordedAir = current;
        }
        if (lastRecordedAir != null) {
            int maxSearchDown = 0;
            for (int y = lastRecordedAir.m_123342_(); y > level.m_141937_() + 30; --y) {
                BlockPos current = new BlockPos(x, y, z);
                BlockPos below = current.m_7495_();
                if (!level.m_8055_(current).m_280296_()) continue;
                ++maxSearchDown;
                Block currentBlock = level.m_8055_(current).m_60734_();
                boolean isSpawnableBlock = playerSpawnServerEvents.getValidGroundBlocks().contains(currentBlock);
                if (isSpawnableBlock) {
                    return current;
                }
                if (maxSearchDown >= 3) break;
            }
        }
        return null;
    }
}

