/*
 * Decompiled with CFR 0.152.
 */
package com.jkdr.abyssalascentdimensionpatcher.events;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.jkdr.abyssalascentdimensionpatcher.AbyssalAscentDimensionPatcher;
import com.jkdr.abyssalascentdimensionpatcher.util.AAExternalConfig;
import com.jkdr.abyssalascentdimensionpatcher.util.RefreshDH;
import com.mojang.logging.LogUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="abyssalascentdimensionpatcher", value={Dist.CLIENT})
public class playerSpawnClientEvents {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static ClientLevel lastWorld = null;

    @SubscribeEvent
    public static void onClientLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        if (((Boolean)AAExternalConfig.WARN_DH_COMPAT.get()).booleanValue() && AbyssalAscentDimensionPatcher.getIsDistantHorizonsInstalled().booleanValue()) {
            Minecraft.m_91087_().f_91074_.m_213846_((Component)Component.m_237113_((String)"Distant Horizons compatibility in Abyssal Ascent is in early stages and if any issues arise please report to @cobster in the discord."));
            AAExternalConfig.WARN_DH_COMPAT.set((Object)false);
            AAExternalConfig.CLIENT_SPEC.save();
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel currentWorld = mc.f_91073_;
        if (currentWorld != null && currentWorld != lastWorld) {
            ClientLevel oldWorld = lastWorld;
            ClientLevel newWorld = currentWorld;
            if (lastWorld != null && AbyssalAscentDimensionPatcher.getIsDistantHorizonsInstalled().booleanValue()) {
                RefreshDH.refreshDh(oldWorld, newWorld);
            }
            lastWorld = newWorld;
        }
    }

    @Mod.EventBusSubscriber(modid="abyssalascentdimensionpatcher", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void onConfigLoad(ModConfigEvent event) {
            ModBusEvents.forceAlexsCavesConfig();
        }

        @SubscribeEvent
        public static void onConfigReload(ModConfigEvent.Reloading event) {
            ModBusEvents.forceAlexsCavesConfig();
        }

        private static void forceAlexsCavesConfig() {
            if (ModList.get().isLoaded("alexscaves") && AbyssalAscentDimensionPatcher.getIsDistantHorizonsInstalled().booleanValue()) {
                try {
                    if (((Boolean)AlexsCaves.CLIENT_CONFIG.biomeAmbientLightColoring.get()).booleanValue()) {
                        LOGGER.warn("The alexscaves biomeAmbientLightColouring parameter was set to true (usually on first load), auto disabling to prevent OpenGL error at runtime");
                        AlexsCaves.CLIENT_CONFIG.biomeAmbientLightColoring.set((Object)false);
                        AlexsCaves.CLIENT_CONFIG.biomeAmbientLightColoring.save();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Abyssal Ascent Patcher: Failed to force Alex's Caves config. " + e.getMessage());
                }
            }
        }
    }
}

