/*
 * Decompiled with CFR 0.152.
 */
package com.jkdr.abyssalascentdimensionpatcher.config;

import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.config.SpellDiscovery;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.common.ForgeConfigSpec;

public class IronSpellbookExpandedConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec SPEC;
    public static final Map<String, SpellConfigEntries> SPELL_ADDED_CONFIGS;

    public static void addSpellCategory(AbstractSpell spell) {
        String spellId = spell.getSpellId();
        if (SPELL_ADDED_CONFIGS.containsKey(spellId)) {
            return;
        }
        BUILDER.push(IronSpellbookExpandedConfig.sanitizeCategory(spellId));
        ForgeConfigSpec.ConfigValue bcIS = BUILDER.define("baseCooldownInSeconds", (Object)0.0);
        BUILDER.pop();
        SPELL_ADDED_CONFIGS.put(spellId, new SpellConfigEntries((ForgeConfigSpec.ConfigValue<Double>)bcIS));
    }

    public static SpellConfigEntries getSpellConfig(AbstractSpell abstractSpell) {
        return SPELL_ADDED_CONFIGS.getOrDefault(abstractSpell.getSpellId(), null);
    }

    private static String sanitizeCategory(String spellId) {
        return spellId.replace(':', '_');
    }

    static {
        SPELL_ADDED_CONFIGS = new HashMap<String, SpellConfigEntries>();
        SpellDiscovery.getSpellsForConfig().stream().collect(Collectors.groupingBy(x -> x.getDefaultConfig().schoolResource)).forEach((school, spells) -> {
            BUILDER.push(school.toString());
            spells.forEach(IronSpellbookExpandedConfig::addSpellCategory);
            BUILDER.pop();
        });
        SPEC = BUILDER.build();
    }

    public record SpellConfigEntries(ForgeConfigSpec.ConfigValue<Double> baseCooldownInSeconds) {
    }
}

