/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.particle;

import com.cerbon.cerbons_api.api.general.particle.SimpleParticle;
import com.cerbon.cerbons_api.api.general.particle.SimpleParticleProvider;
import com.cerbon.cerbons_api.api.static_utilities.Geometries;
import com.cerbon.cerbons_api.api.static_utilities.MathUtils;
import com.cerbon.cerbons_api.api.static_utilities.RandomUtils;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class BMDParticles {
    public static final DeferredRegister<ParticleType<?>> PARTICLE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"bosses_of_mass_destruction");
    public static final RegistryObject<SimpleParticleType> DISAPPEARING_SWIRL = PARTICLE_TYPES.register("disappearing_swirl", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> SOUL_FLAME = PARTICLE_TYPES.register("soul_flame", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> MAGIC_CIRCLE = PARTICLE_TYPES.register("magic_circle", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_BURST = PARTICLE_TYPES.register("obsidilith_burst", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> ENCHANT = PARTICLE_TYPES.register("enchant", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_BURST_INDICATOR = PARTICLE_TYPES.register("obsidilith_burst_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_WAVE = PARTICLE_TYPES.register("obsidilith_wave", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_WAVE_INDICATOR = PARTICLE_TYPES.register("obsidilith_wave_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> DOWNSPARKLE = PARTICLE_TYPES.register("downsparkle", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_SPIKE_INDICATOR = PARTICLE_TYPES.register("obsidilith_spike_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_SPIKE = PARTICLE_TYPES.register("obsidilith_spike", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> PILLAR_RUNE = PARTICLE_TYPES.register("pillar_rune", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> PILLAR_SPAWN_INDICATOR = PARTICLE_TYPES.register("pillar_spawn_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> PILLAR_SPAWN_INDICATOR_2 = PARTICLE_TYPES.register("pillar_spawn_indicator_2", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> OBSIDILITH_ANVIL_INDICATOR = PARTICLE_TYPES.register("obsidilith_anvil_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> SPARKLES = PARTICLE_TYPES.register("sparkles", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> GAUNTLET_REVIVE_SPARKLES = PARTICLE_TYPES.register("gauntlet_revive_sparkles", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> EYE_OPEN = PARTICLE_TYPES.register("eye_open", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> LINE = PARTICLE_TYPES.register("line", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> VOID_BLOSSOM_SPIKE_INDICATOR = PARTICLE_TYPES.register("void_blossom_spike_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> VOID_BLOSSOM_SPIKE_WAVE_INDICATOR = PARTICLE_TYPES.register("void_blossom_spike_wave_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> PETAL = PARTICLE_TYPES.register("petal", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> SPORE = PARTICLE_TYPES.register("spore", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> SPORE_INDICATOR = PARTICLE_TYPES.register("spore_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> FLUFF = PARTICLE_TYPES.register("fluff", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> POLLEN = PARTICLE_TYPES.register("pollen", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> EARTHDIVE_INDICATOR = PARTICLE_TYPES.register("earthdive_indicator", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> ROD = PARTICLE_TYPES.register("rod", () -> new SimpleParticleType(true));
    public static final RegistryObject<SimpleParticleType> GROUND_ROD = PARTICLE_TYPES.register("ground_rod", () -> new SimpleParticleType(true));
    public static final int FULL_BRIGHT = 0xF000F0;

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)DISAPPEARING_SWIRL.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)SOUL_FLAME.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.COMET_BLUE);
            particle.setBrightnessOverride(f -> 0xF000F0);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)MAGIC_CIRCLE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 40, Geometries::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.m_6569_(4.0f);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)OBSIDILITH_BURST.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)7, (int)15), Geometries::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.m_6569_(4.0f);
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.ORANGE, (Vec3)Vec3Colors.RUNIC_BROWN));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)ENCHANT.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)30, (int)50), Geometries::buildBillBoardGeometry, false, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((float)((Math.sin((double)f.floatValue() * Math.PI) + 1.0) * (double)0.1f)));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)OBSIDILITH_BURST_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 30 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ORANGE);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)OBSIDILITH_WAVE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)7, (int)15), Geometries::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.m_6569_(4.0f);
            particle.setColorVariation(0.25);
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.RED, (Vec3)Vec3Colors.DARK_RED));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)OBSIDILITH_WAVE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 20 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.RED);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)DOWNSPARKLE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)OBSIDILITH_SPIKE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 20 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.COMET_BLUE);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)OBSIDILITH_SPIKE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true);
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.WHITE, (Vec3)Vec3Colors.COMET_BLUE));
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setColorVariation(0.25);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)PILLAR_RUNE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 10, Geometries::buildBillBoardGeometry, false, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((float)((Math.sin((double)f.floatValue() * Math.PI) + 1.0) * (double)0.1f)));
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.WHITE, (Vec3)Vec3Colors.ENDER_PURPLE));
            particle.setColorVariation(0.2);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)PILLAR_SPAWN_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 40, Geometries::buildBillBoardGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ENDER_PURPLE);
            particle.m_6569_(2.0f);
            particle.setColorVariation(0.25);
            particle.setBrightnessOverride(f -> 0xF000F0);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)PILLAR_SPAWN_INDICATOR_2.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 40, Geometries::buildBillBoardGeometry, false, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((float)((Math.sin((double)f.floatValue() * Math.PI) + 1.0) * (double)0.1f)));
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.WHITE, (Vec3)Vec3Colors.ENDER_PURPLE));
            particle.setColorVariation(0.2);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)OBSIDILITH_ANVIL_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)25, (int)27), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ENDER_PURPLE);
            particle.setColorVariation(0.3);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)SPARKLES.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)GAUNTLET_REVIVE_SPARKLES.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.LASER_RED);
            particle.setColorVariation(0.25);
            particle.setBrightnessOverride(f -> 0xF000F0);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)EYE_OPEN.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)60, (int)70), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)LINE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)20, (int)30), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)ROD.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)8, (int)10), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)GROUND_ROD.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)8, (int)10), Geometries::buildFlatGeometry, true, true)));
        event.registerSpriteSet((ParticleType)VOID_BLOSSOM_SPIKE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 20 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ENDER_PURPLE);
            particle.setColorVariation(0.2);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)VOID_BLOSSOM_SPIKE_WAVE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 30 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.ENDER_PURPLE);
            particle.setColorVariation(0.2);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)PETAL.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, false, true)));
        event.registerSpriteSet((ParticleType)POLLEN.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, false, true);
            particle.setColorOverride(f -> new Vec3(1.0, 0.9, 0.4));
            particle.setColorVariation(0.15);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf(0.05f * (1.0f - f.floatValue() * 0.25f)));
            int randomRot = RandomUtils.range((int)0, (int)360);
            float angularMomentum = (float)RandomUtils.randSign() * 4.0f;
            particle.setRotationOverride(particle1 -> Float.valueOf((float)randomRot + (float)particle1.getAge() * angularMomentum));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)SPORE.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)7, (int)15), Geometries::buildBillBoardGeometry, true, true);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.m_6569_(4.0f);
            particle.setColorOverride(age -> MathUtils.lerpVec((float)age.floatValue(), (Vec3)Vec3Colors.GREEN, (Vec3)Vec3Colors.DARK_GREEN));
            particle.setColorVariation(0.25);
            return particle;
        }));
        event.registerSpriteSet((ParticleType)SPORE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, 30 + RandomUtils.range((int)-1, (int)2), Geometries::buildFlatGeometry, true, true);
            particle.setColorOverride(f -> Vec3Colors.GREEN);
            particle.setColorVariation(0.35);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f + f.floatValue()) * 0.25f));
            return particle;
        }));
        event.registerSpriteSet((ParticleType)FLUFF.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, true)));
        event.registerSpriteSet((ParticleType)EARTHDIVE_INDICATOR.get(), spriteSet -> new SimpleParticleProvider(spriteSet, particleContext -> {
            SimpleParticle particle = new SimpleParticle(particleContext, RandomUtils.range((int)15, (int)20), Geometries::buildBillBoardGeometry, true, false);
            particle.setColorOverride(f -> Vec3Colors.RUNIC_BROWN);
            particle.setColorVariation(0.25);
            particle.setBrightnessOverride(f -> 0xF000F0);
            particle.setScaleOverride(f -> Float.valueOf((1.0f - f.floatValue() * 0.25f) * 0.35f));
            return particle;
        }));
    }

    public static void register(IEventBus eventBus) {
        PARTICLE_TYPES.register(eventBus);
    }
}

