/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom;

import com.cerbon.bosses_of_mass_destruction.client.render.IRenderer;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomClientSpikeHandler;
import com.cerbon.bosses_of_mass_destruction.entity.custom.void_blossom.VoidBlossomEntity;
import com.cerbon.bosses_of_mass_destruction.util.VanillaCopies;
import com.cerbon.cerbons_api.api.static_utilities.Vec3Colors;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class VoidBlossomSpikeRenderer
implements IRenderer<VoidBlossomEntity> {
    private final ResourceLocation spikeTexture = new ResourceLocation("bosses_of_mass_destruction", "textures/entity/void_blossom_spike.png");
    private final RenderType type = RenderType.m_110458_((ResourceLocation)this.spikeTexture);

    @Override
    public void render(VoidBlossomEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int light) {
        for (Map.Entry<BlockPos, VoidBlossomClientSpikeHandler.Spike> kv : entity.clientSpikeHandler.getSpikes().entrySet()) {
            this.renderBeam((LivingEntity)entity, kv.getValue(), partialTicks, poseStack, buffer, this.type);
        }
    }

    private void renderBeam(LivingEntity actor, VoidBlossomClientSpikeHandler.Spike spike, float tickDelta, PoseStack poseStack, MultiBufferSource bufferSource, RenderType type) {
        float numTextures = 8.0f;
        float lifeRatio = 2.0f;
        float textureProgress = Math.max(0.0f, ((float)spike.age() + tickDelta) * lifeRatio / (float)spike.maxAge() - lifeRatio + 1.0f);
        if (textureProgress >= 1.0f) {
            return;
        }
        float spikeHeight = spike.height();
        float textureRatio = 0.34375f;
        float spikeWidth = textureRatio * spikeHeight * 0.5f;
        double upProgress = (Math.sin(Math.min((double)((float)spike.age() + tickDelta) / ((double)spike.maxAge() * 0.4), 1.0) * Math.PI * 0.5) - 1.0) * (double)spikeHeight;
        Function<Float, Float> texTransformer = this.textureMultiplier(Float.valueOf(1.0f / numTextures), (float)(Math.floor(textureProgress * numTextures) / (double)numTextures));
        poseStack.m_85836_();
        Vec3 offset = VanillaCopies.fromLerpedPosition(actor, 0.0, tickDelta).m_82546_(spike.pos());
        poseStack.m_85837_(-offset.f_82479_, upProgress - offset.f_82480_, -offset.f_82481_);
        Vec3 bottomPos = spike.offset();
        float n = (float)Math.acos(bottomPos.f_82480_);
        float o = (float)Math.atan2(bottomPos.f_82481_, bottomPos.f_82479_);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((1.5707964f - o) * 57.295776f));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(n * 57.295776f));
        float q = 0.0f;
        int red = (int)(Vec3Colors.WHITE.f_82479_ * 255.0);
        int green = (int)(Vec3Colors.WHITE.f_82480_ * 255.0);
        int blue = (int)(Vec3Colors.WHITE.f_82481_ * 255.0);
        float af = Mth.m_14089_((float)(q + (float)Math.PI)) * spikeWidth;
        float ag = Mth.m_14031_((float)(q + (float)Math.PI)) * spikeWidth;
        float ah = Mth.m_14089_((float)(q + 0.0f)) * spikeWidth;
        float ai = Mth.m_14031_((float)(q + 0.0f)) * spikeWidth;
        float aj = Mth.m_14089_((float)(q + 1.5707964f)) * spikeWidth;
        float ak = Mth.m_14031_((float)(q + 1.5707964f)) * spikeWidth;
        float al = Mth.m_14089_((float)(q + 4.712389f)) * spikeWidth;
        float am = Mth.m_14031_((float)(q + 4.712389f)) * spikeWidth;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(type);
        PoseStack.Pose entry = poseStack.m_85850_();
        Matrix4f matrix4f = entry.m_252922_();
        Matrix3f matrix3f = entry.m_252943_();
        float c0 = texTransformer.apply(Float.valueOf(0.4999f)).floatValue();
        float c2 = texTransformer.apply(Float.valueOf(0.0f)).floatValue();
        float c1 = texTransformer.apply(Float.valueOf(1.0f)).floatValue();
        VanillaCopies.vertex(vertexConsumer, matrix4f, matrix3f, af, spikeHeight, ag, red, green, blue, c0, 0.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, matrix3f, af, 0.0f, ag, red, green, blue, c0, 1.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, matrix3f, ah, 0.0f, ai, red, green, blue, c2, 1.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, matrix3f, ah, spikeHeight, ai, red, green, blue, c2, 0.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, matrix3f, aj, spikeHeight, ak, red, green, blue, c1, 0.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, matrix3f, aj, 0.0f, ak, red, green, blue, c1, 1.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, matrix3f, al, 0.0f, am, red, green, blue, c0, 1.0f);
        VanillaCopies.vertex(vertexConsumer, matrix4f, matrix3f, al, spikeHeight, am, red, green, blue, c0, 0.0f);
        poseStack.m_85849_();
    }

    public Function<Float, Float> textureMultiplier(Float multiplier, float adjustment) {
        return texCoord -> Float.valueOf(texCoord.floatValue() * multiplier.floatValue() + adjustment);
    }
}

