/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.world.level.material;

import com.stereowalker.unionlib.util.math.Funcs;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public abstract class FluidProperties {
    public static final Map<Fluid, FluidProperties> fluidProps = new HashMap<Fluid, FluidProperties>();

    public static FluidProperties fromFluid(Fluid fluid) {
        return fluidProps.getOrDefault(fluid, null);
    }

    public static <T> T or(Fluid fluid, Function<FluidProperties, T> func, T or) {
        if (fluidProps.containsKey(fluid)) {
            return func.apply(fluidProps.get(fluid));
        }
        return or;
    }

    public static Builder create(ResourceLocation name) {
        Builder b = new Builder();
        b.name = name;
        return b;
    }

    public abstract ResourceLocation name();

    public ResourceLocation stillTexture() {
        return null;
    }

    public ResourceLocation flowingTexture() {
        return null;
    }

    public ResourceLocation overlayTexture() {
        return null;
    }

    public int tintColor() {
        return -1;
    }

    public int tintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
        return this.tintColor();
    }

    public double motionScale(Entity entity) {
        return 0.014;
    }

    public boolean canPushEntity(Entity entity) {
        return true;
    }

    public boolean canSwim(Entity entity) {
        return true;
    }

    public float fallDistanceModifier(Entity entity) {
        return 0.5f;
    }

    public boolean canExtinguish(Entity entity) {
        return false;
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        return false;
    }

    public boolean canDrownIn(LivingEntity entity) {
        return true;
    }

    public void itemMovement(ItemEntity entity) {
        Vec3 vec3 = entity.m_20184_();
        entity.m_20334_(vec3.f_82479_ * (double)0.99f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.99f);
    }

    public boolean supportsBoats(Boat boat) {
        return false;
    }

    public boolean supportsBoats(FluidState state, Boat boat) {
        return this.supportsBoats(boat);
    }

    public static class Builder {
        int tint = -1;
        float fallDistanceModifier = 0.5f;
        double motionScale = 0.014;
        boolean supportsBoats = false;
        boolean canPushEntity = true;
        boolean canSwim = true;
        boolean canDrownIn = true;
        boolean canExtinguish = true;
        ResourceLocation name;
        ResourceLocation stillTexture = null;
        ResourceLocation flowingTexture = null;
        ResourceLocation overlayTexture = null;
        Funcs._3<FluidState, BlockAndTintGetter, BlockPos, Integer> tint2 = (a, b, c) -> this.tint;
        Funcs._4<FluidState, LivingEntity, Vec3, Double, Boolean> move = (a, b, c, d) -> false;
        Consumer<ItemEntity> itemMovement = entity -> {
            Vec3 vec3 = entity.m_20184_();
            entity.m_20334_(vec3.f_82479_ * (double)0.99f, vec3.f_82480_ + (double)(vec3.f_82480_ < (double)0.06f ? 5.0E-4f : 0.0f), vec3.f_82481_ * (double)0.99f);
        };

        private Builder() {
        }

        public Builder stillTexture(ResourceLocation tex) {
            this.stillTexture = tex;
            return this;
        }

        public Builder flowingTexture(ResourceLocation tex) {
            this.flowingTexture = tex;
            return this;
        }

        public Builder overlayTexture(ResourceLocation text) {
            this.overlayTexture = text;
            return this;
        }

        public Builder motionScale(double motionScale) {
            this.motionScale = motionScale;
            return this;
        }

        public Builder canPushEntity(boolean canPushEntity) {
            this.canPushEntity = canPushEntity;
            return this;
        }

        public Builder canSwim(boolean canSwim) {
            this.canSwim = canSwim;
            return this;
        }

        public Builder canExtinguish(boolean val) {
            this.canExtinguish = val;
            return this;
        }

        public Builder canDrownIn(boolean val) {
            this.canDrownIn = val;
            return this;
        }

        public Builder tint(int tint) {
            this.tint = tint;
            return this;
        }

        public Builder supportsBoats(boolean val) {
            this.supportsBoats = val;
            return this;
        }

        public Builder tint(Funcs._3<FluidState, BlockAndTintGetter, BlockPos, Integer> tint) {
            this.tint2 = tint;
            return this;
        }

        public Builder customMovement(Funcs._4<FluidState, LivingEntity, Vec3, Double, Boolean> move) {
            this.move = move;
            return this;
        }

        public Builder fallDistanceModifier(float val) {
            this.fallDistanceModifier = val;
            return this;
        }

        public FluidProperties toProperties() {
            return new FluidProperties(){

                @Override
                public ResourceLocation name() {
                    return name;
                }

                @Override
                public ResourceLocation stillTexture() {
                    return stillTexture;
                }

                @Override
                public ResourceLocation flowingTexture() {
                    return flowingTexture;
                }

                @Override
                public ResourceLocation overlayTexture() {
                    return overlayTexture;
                }

                @Override
                public boolean canPushEntity(Entity entity) {
                    return canPushEntity;
                }

                @Override
                public boolean canSwim(Entity entity) {
                    return canSwim;
                }

                @Override
                public boolean canExtinguish(Entity entity) {
                    return canExtinguish;
                }

                @Override
                public boolean canDrownIn(LivingEntity entity) {
                    return canDrownIn;
                }

                @Override
                public double motionScale(Entity entity) {
                    return motionScale;
                }

                @Override
                public float fallDistanceModifier(Entity entity) {
                    return fallDistanceModifier;
                }

                @Override
                public int tintColor() {
                    return tint;
                }

                @Override
                public int tintColor(FluidState state, BlockAndTintGetter getter, BlockPos pos) {
                    return tint2.apply(state, getter, pos);
                }

                @Override
                public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
                    return move.apply(state, entity, movementVector, gravity);
                }

                @Override
                public void itemMovement(ItemEntity entity) {
                    itemMovement.accept(entity);
                }

                @Override
                public boolean supportsBoats(Boat boat) {
                    return supportsBoats;
                }
            };
        }
    }
}

