/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.stereowalker.unionlib.util.math.Color;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.model.Model;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VersionHelper {
    public static BlockPos posFromDouble(double x, double y, double z) {
        return BlockPos.m_274561_((double)x, (double)y, (double)z);
    }

    public static boolean isEquippableInSlot(ArmorItem item, EquipmentSlot slot) {
        return item.m_266204_().m_266308_().equals((Object)slot);
    }

    public static Level entityLevel(Entity entity) {
        return entity.m_9236_();
    }

    public static <E extends Mob> BehaviorControl<E> createStopAttackingIfTargetInvalid(BiConsumer<E, LivingEntity> onStopAttacking) {
        return StopAttackingIfTargetInvalid.m_257940_(onStopAttacking);
    }

    public static BehaviorControl<Mob> createSetWalkTargetFromAttackTargetIfTargetOutOfReach(float speedModifier) {
        return SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)speedModifier);
    }

    public static OneShot<Mob> createMeleeAttack(int cooldownBetweenAttacks) {
        return MeleeAttack.m_257733_((int)cooldownBetweenAttacks);
    }

    public static <E extends LivingEntity> BehaviorControl<E> createEraseMemoryIf(Predicate<E> shouldEraseMemory, MemoryModuleType<?> erasingMemory) {
        return EraseMemoryIf.m_258093_(shouldEraseMemory, erasingMemory);
    }

    public static <E extends Mob> BehaviorControl<E> createStartAttacking(Function<E, Optional<? extends LivingEntity>> targetFinder) {
        return StartAttacking.m_257710_(targetFinder);
    }

    public static ResourceLocation toLoc(String namespace, String path) {
        return new ResourceLocation(namespace, path);
    }

    public static ResourceLocation toLoc(String location) {
        return new ResourceLocation(location);
    }

    public static void writeComponent(FriendlyByteBuf packetBuffer, Component component) {
        packetBuffer.m_130083_(component);
    }

    public static Component readComponent(FriendlyByteBuf packetBuffer) {
        return packetBuffer.m_130238_();
    }

    public static void setupForEntityInInventory(Quaternionf quaternion) {
        RenderSystem.setShaderLights((Vector3f)quaternion.transform((Vector3fc)Lighting.f_166381_, new Vector3f()), (Vector3f)quaternion.transform((Vector3fc)Lighting.f_166382_, new Vector3f()));
    }

    public static ItemStack transmuteCopy(ItemStack original, Item toTransmute, int count) {
        ItemStack newStack = new ItemStack((ItemLike)toTransmute);
        newStack.m_41721_(original.m_41773_());
        if (original.m_41788_()) {
            newStack.m_41714_(original.m_41786_());
        }
        if (original.m_41782_()) {
            newStack.m_41751_(original.m_41783_());
        }
        newStack.m_41764_(count);
        return newStack;
    }

    public static class Data<T> {
        private Predicate<ItemStack> has;
        private Function<ItemStack, T> get;
        private BiConsumer<ItemStack, T> set;
        private Consumer<ItemStack> remove;

        public Data(Predicate<ItemStack> has, Function<ItemStack, T> get, BiConsumer<ItemStack, T> set, Consumer<ItemStack> remove) {
            this.has = has;
            this.get = get;
            this.set = set;
        }

        public boolean hasData(ItemStack stack) {
            return this.has.test(stack);
        }

        public T getData(ItemStack stack) {
            return this.get.apply(stack);
        }

        public void setData(ItemStack stack, T data) {
            this.set.accept(stack, (ItemStack)data);
        }

        public void editData(ItemStack stack, Function<T, T> func) {
            this.setData(stack, func.apply(this.getData(stack)));
        }

        public void removeData(ItemStack stack) {
            this.remove.accept(stack);
        }
    }

    public static class Client {
        public static void renderToBuffer(Model model, PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, Color color) {
            model.m_7695_(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, color.r, color.g, color.b, color.a);
        }

        public static void renderToBuffer(Model model, PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay) {
            Client.renderToBuffer(model, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, new Color(1.0f, 1.0f, 1.0f));
        }
    }
}

