/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.supporter;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.stereowalker.unionlib.UnionLib;
import com.stereowalker.unionlib.supporter.Cosmetic;
import com.stereowalker.unionlib.supporter.CosmeticSelection;
import com.stereowalker.unionlib.supporter.OwnedCosmetic;
import com.stereowalker.unionlib.util.LoaderHelper;
import com.stereowalker.unionlib.util.math.Color;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;

public class Cosmetics {
    private static final int timeout = 20000;
    protected static TextureCache cosmeticTextures;
    protected static Cosmetic NONE;
    private static volatile Instant lastPoll;
    private static int pollingTicks;
    private static CompletableFuture<Void> recheckThread;
    private static List<OwnedCosmetic> OWNED_COSMETICS;
    private static Map<String, Cosmetic> ALL_COSMETICS;
    private static Map<UUID, CosmeticSelection> EQUIPPED_COSMETICS;

    public static Map<String, Cosmetic> allCosmetics() {
        return ALL_COSMETICS;
    }

    public static Map<UUID, CosmeticSelection> equippedCosmetics() {
        return EQUIPPED_COSMETICS;
    }

    public static List<OwnedCosmetic> ownedCosmetics() {
        return OWNED_COSMETICS;
    }

    public static boolean isEmpty(Cosmetic cosmetic) {
        return cosmetic == NONE;
    }

    public static boolean ownsCosmetic(CosmeticSelection cosmetic) {
        for (OwnedCosmetic owned : OWNED_COSMETICS) {
            if (!cosmetic.cosmeticId().equals(owned.cosmeticId())) continue;
            if (cosmetic.isDefault()) {
                return true;
            }
            if (cosmetic.isCustom() && owned.can_color()) {
                return true;
            }
            if (!List.of(owned.permitted_variants()).contains(cosmetic.variant())) continue;
            return true;
        }
        return false;
    }

    public Cosmetics(Minecraft mc) {
        cosmeticTextures = new TextureCache(mc.f_90987_, mc.f_91069_.toPath().resolve("cosmetics"));
        mc.f_91069_.toPath().resolve("cosmetics").toFile().mkdir();
        Cosmetics.obtainAllCosmetics(new File(mc.f_91069_.toPath().resolve("cosmetics").toFile(), "cm.db"), new File(mc.f_91069_.toPath().resolve("cosmetics").toFile(), "cmv.db"), new File(mc.f_91069_.toPath().resolve("cosmetics").toFile(), "cms.db"), true);
    }

    private static void debug(Object message) {
        UnionLib.debug(message);
    }

    private static void populateHeaders(HttpURLConnection connection) {
        String an = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpc3MiOiJzdXBhYmFzZSIsInJlZiI6ImpvY2h6Z3RweWlha2RlaXZmeGVxIiwicm9sZSI6ImFub24iLCJpYXQiOjE3NDcwODk3OTYsImV4cCI6MjA2MjY2NTc5Nn0.PxbO7ns1oSfrHd9FsyRyPlOeXof3_9a6VFgo7sqgB9I";
        connection.setRequestProperty("apikey", an);
        connection.setRequestProperty("Authorization", "Bearer " + an);
    }

    private static void cacheFile(BufferedReader store, File cache) throws IOException {
        store.mark(100000);
        if (!cache.exists()) {
            cache.createNewFile();
        }
        try (PrintWriter printwriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(cache), StandardCharsets.UTF_8));){
            store.lines().forEach(line -> printwriter.println((String)line));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        store.reset();
    }

    public static void onConnectToCosmeticDB(Runnable run) {
        CompletableFuture.supplyAsync(() -> {
            boolean fetched = true;
            try {
                URL url = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_eligibility").toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setConnectTimeout(20000);
                connection.connect();
                Cosmetics.debug("Testing Connection");
            }
            catch (Exception e) {
                fetched = false;
                e.printStackTrace();
            }
            return fetched;
        }).whenComplete((fetched, x) -> {
            if (fetched.booleanValue()) {
                run.run();
            }
        });
    }

    public static void fetchOwnedCosmetics(UUID player, Runnable onFetched) {
        CompletableFuture.supplyAsync(() -> {
            BufferedReader read = null;
            BufferedReader readColors = null;
            try {
                URL url = new URI(String.format("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_eligibility?select=cosmetic_id,can_color,permitted_variants&expires_at=is.null,gt.now()&player_uuid=eq.%s", player.toString())).toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                Cosmetics.populateHeaders(connection);
                connection.setRequestProperty("x-player-uuid", player.toString());
                connection.setConnectTimeout(20000);
                connection.connect();
                read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                URL urlColor = new URI(String.format("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/user_cosmetic_colors?select=cosmetic_id,segment_names,color_hexes&player_uuid=eq.%s", player.toString())).toURL();
                HttpURLConnection connectionColor = (HttpURLConnection)urlColor.openConnection();
                connectionColor.setRequestMethod("GET");
                Cosmetics.populateHeaders(connectionColor);
                connectionColor.setRequestProperty("x-player-uuid", player.toString());
                connectionColor.setConnectTimeout(20000);
                connectionColor.connect();
                readColors = new BufferedReader(new InputStreamReader(connectionColor.getInputStream()));
                Cosmetics.debug("Fetching owned cosmetics");
            }
            catch (IOException e) {
                Cosmetics.debug("Internet might not be connected");
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            return List.of(read, readColors);
        }).whenComplete((read, x) -> {
            if (read.get(0) != null && read.get(1) != null) {
                try {
                    HashMap colorBuilder = new HashMap();
                    JsonElement colorElement = JsonParser.parseReader((Reader)((Reader)read.get(1)));
                    colorElement.getAsJsonArray().forEach(elem -> {
                        for (int i = 0; i < elem.getAsJsonObject().get("color_hexes").getAsJsonArray().size(); ++i) {
                            colorBuilder.computeIfAbsent(elem.getAsJsonObject().get("cosmetic_id").getAsString(), k -> ImmutableMap.builder()).put((Object)elem.getAsJsonObject().get("segment_names").getAsJsonArray().get(i).getAsString(), (Object)Color.parse(elem.getAsJsonObject().get("color_hexes").getAsJsonArray().get(i).getAsString()));
                        }
                    });
                    ImmutableList.Builder builder = ImmutableList.builder();
                    JsonElement element = JsonParser.parseReader((Reader)((Reader)read.get(0)));
                    element.getAsJsonArray().forEach(elem -> builder.add((Object)new OwnedCosmetic(elem.getAsJsonObject().get("cosmetic_id").getAsString(), elem.getAsJsonObject().get("can_color").getAsBoolean(), (String[])elem.getAsJsonObject().get("permitted_variants").getAsJsonArray().asList().stream().map(JsonElement::getAsString).toArray(String[]::new), (Map<String, Color>)colorBuilder.getOrDefault(elem.getAsJsonObject().get("cosmetic_id").getAsString(), new ImmutableMap.Builder()).build())));
                    OWNED_COSMETICS = builder.build();
                    onFetched.run();
                    for (BufferedReader buff : read) {
                        buff.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            x.printStackTrace();
        });
    }

    public static void pollCosmetics() {
        if (recheckThread != null && !recheckThread.isDone()) {
            return;
        }
        if (++pollingTicks > 1200) {
            pollingTicks = 0;
            recheckThread = CompletableFuture.runAsync(() -> {
                BufferedReader read = null;
                try {
                    URL url = new URI(String.format("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_selection?select=player_uuid,headwear_id,variant,colors_json,updated_at&updated_at=gt.%s", lastPoll.toString())).toURL();
                    HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                    connection.setRequestMethod("GET");
                    Cosmetics.populateHeaders(connection);
                    connection.setConnectTimeout(20000);
                    connection.connect();
                    read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    Cosmetics.debug("Rechecking everyone's cosmetics");
                }
                catch (IOException e) {
                    Cosmetics.debug("Internet is not connected");
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                if (read != null) {
                    ImmutableMap.Builder builder = ImmutableMap.builder();
                    builder.putAll(EQUIPPED_COSMETICS);
                    JsonElement element = JsonParser.parseReader(read);
                    element.getAsJsonArray().forEach(elem -> {
                        JsonObject object_2 = elem.getAsJsonObject();
                        ImmutableMap.Builder colors = new ImmutableMap.Builder();
                        Cosmetics.allCosmetics().get((Object)object_2.get((String)"headwear_id").getAsString()).segments.forEach(segment -> {
                            if (object_2.get("colors_json").getAsJsonObject().has(segment)) {
                                colors.put(segment, (Object)Color.parse(object_2.get("colors_json").getAsJsonObject().get(segment).getAsString()));
                            }
                        });
                        CosmeticSelection selection = new CosmeticSelection(object_2.get("headwear_id").getAsString(), object_2.get("variant").getAsString(), (Map<String, Color>)colors.build());
                        builder.put((Object)UUID.fromString(object_2.get("player_uuid").getAsString()), (Object)selection);
                    });
                    EQUIPPED_COSMETICS = builder.build();
                    lastPoll = Instant.now();
                    try {
                        read.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).whenComplete((v, x) -> {
                recheckThread = null;
            });
        }
    }

    public static void obtainCosmetics(File cache, boolean createCache) {
        CompletableFuture.runAsync(() -> {
            BufferedReader read = null;
            try {
                URL url = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_selection").toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                Cosmetics.populateHeaders(connection);
                connection.setConnectTimeout(20000);
                connection.connect();
                read = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                Cosmetics.debug("We now know who's wearing what");
                if (createCache) {
                    Cosmetics.cacheFile(read, cache);
                }
            }
            catch (IOException e) {
                Cosmetics.debug("Internet is not connected");
                e.printStackTrace();
                if (cache.exists()) {
                    try {
                        FileInputStream stream = new FileInputStream(cache);
                        InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);
                        read = new BufferedReader(reader);
                    }
                    catch (FileNotFoundException e1) {
                        Cosmetics.debug("Cosmetic Cache file not found");
                    }
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (read != null) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                JsonElement element = JsonParser.parseReader(read);
                element.getAsJsonArray().forEach(elem -> {
                    JsonObject object_2 = elem.getAsJsonObject();
                    ImmutableMap.Builder colors = new ImmutableMap.Builder();
                    Cosmetics.allCosmetics().get((Object)object_2.get((String)"headwear_id").getAsString()).segments.forEach(segment -> {
                        if (object_2.get("colors_json").getAsJsonObject().has(segment)) {
                            colors.put(segment, (Object)Color.parse(object_2.get("colors_json").getAsJsonObject().get(segment).getAsString()));
                        }
                    });
                    CosmeticSelection selection = new CosmeticSelection(object_2.get("headwear_id").getAsString(), object_2.get("variant").getAsString(), (Map<String, Color>)colors.build());
                    builder.put((Object)UUID.fromString(object_2.get("player_uuid").getAsString()), (Object)selection);
                });
                EQUIPPED_COSMETICS = builder.build();
                try {
                    read.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Cosmetics.debug("No cache to load, skipping cosmetics. For now");
            }
        }).whenComplete((v, e) -> e.printStackTrace());
    }

    public static void updateCosmetic(UUID player, CosmeticSelection newHeadwear, Runnable onComplete) {
        CompletableFuture.supplyAsync(() -> {
            try {
                URL url = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/functions/v1/equip-cosmetic").toURL();
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setDoOutput(true);
                Cosmetics.populateHeaders(connection);
                if (LoaderHelper.isDevEnvironment() && System.getenv("UNIONLIBCOSMETICDEVKEY") != null) {
                    connection.setRequestProperty("x-player-uuid", player.toString());
                    connection.setRequestProperty("x-dev-secret", System.getenv("UNIONLIBCOSMETICDEVKEY"));
                } else {
                    connection.setRequestProperty("mc-ac-token", "Bearer " + Minecraft.m_91087_().m_91094_().m_92547_());
                }
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setRequestProperty("Prefer", "resolution=merge-duplicates");
                String payload = "{\"player_uuid\": \"%s\",\"cosmetic_id\": \"%s\",\"variant\": \"%s\"}".formatted(player, newHeadwear.cosmeticId(), newHeadwear.variant());
                try (OutputStream os = connection.getOutputStream();){
                    os.write(payload.getBytes(StandardCharsets.UTF_8));
                }
                int code = connection.getResponseCode();
                boolean success = false;
                if (code >= 200 && code < 300) {
                    success = true;
                } else {
                    Cosmetics.debug("Failed to change headwear (" + code + ") [" + new String(connection.getErrorStream().readAllBytes(), StandardCharsets.UTF_8) + "]");
                }
                connection.disconnect();
                return success;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    Cosmetics.debug("Internet is not connected");
                }
                e.printStackTrace();
                return false;
            }
        }).whenComplete((success, e) -> {
            onComplete.run();
            e.printStackTrace();
        });
    }

    public static boolean updateCosmeticColors(UUID player, CosmeticSelection newHeadwear) {
        try {
            URL url = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/functions/v1/set-cosmetic-color").toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            Cosmetics.populateHeaders(connection);
            if (LoaderHelper.isDevEnvironment() && System.getenv("UNIONLIBCOSMETICDEVKEY") != null) {
                connection.setRequestProperty("x-player-uuid", player.toString());
                connection.setRequestProperty("x-dev-secret", System.getenv("UNIONLIBCOSMETICDEVKEY"));
            } else {
                connection.setRequestProperty("mc-ac-token", "Bearer " + Minecraft.m_91087_().m_91094_().m_92547_());
            }
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Prefer", "resolution=merge-duplicates");
            String payload = "{\"player_uuid\": \"%s\",\"cosmetic_id\": \"%s\",\"segment_names\": %s,\"color_hexes\": %s}".formatted(player, newHeadwear.cosmeticId(), newHeadwear.colors().keySet().stream().map(x -> "\"" + x + "\"").collect(Collectors.toList()), newHeadwear.colors().values().stream().map(Color::toHexRGBString).map(x -> "\"" + x + "\"").collect(Collectors.toList()));
            try (OutputStream os = connection.getOutputStream();){
                os.write(payload.getBytes(StandardCharsets.UTF_8));
            }
            int code = connection.getResponseCode();
            boolean success = false;
            if (code >= 200 && code < 300) {
                success = true;
            } else {
                Cosmetics.debug("Failed to change color (" + code + ") [" + new String(connection.getErrorStream().readAllBytes(), StandardCharsets.UTF_8) + "]");
            }
            connection.disconnect();
            return success;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                Cosmetics.debug("Internet is not connected");
            }
            e.printStackTrace();
            return false;
        }
    }

    public static void obtainAllCosmetics(File cache, File variantCache, File segmentCache, boolean createCache) {
        CompletableFuture.runAsync(() -> {
            BufferedReader readVariants;
            BufferedReader readCosmetics;
            BufferedReader read;
            block20: {
                read = null;
                readCosmetics = null;
                readVariants = null;
                try {
                    Cosmetics.debug("Obtained all cosmetics");
                    URL urlCos = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetics?select=cosmetic_id,show_with_helmet,height_blocks,model_dsl&order=cosmetic_id.asc").toURL();
                    HttpURLConnection connCos = (HttpURLConnection)urlCos.openConnection();
                    connCos.setRequestMethod("GET");
                    Cosmetics.populateHeaders(connCos);
                    connCos.setConnectTimeout(20000);
                    connCos.connect();
                    readCosmetics = new BufferedReader(new InputStreamReader(connCos.getInputStream(), StandardCharsets.UTF_8));
                    if (createCache) {
                        Cosmetics.cacheFile(readCosmetics, cache);
                    }
                    URL urlVar = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_variants?select=cosmetic_id,variant_name,texture_url,is_default&order=cosmetic_id.asc,variant_name.asc").toURL();
                    HttpURLConnection connVar = (HttpURLConnection)urlVar.openConnection();
                    connVar.setRequestMethod("GET");
                    Cosmetics.populateHeaders(connVar);
                    connVar.setConnectTimeout(20000);
                    connVar.connect();
                    readVariants = new BufferedReader(new InputStreamReader(connVar.getInputStream(), StandardCharsets.UTF_8));
                    if (createCache) {
                        Cosmetics.cacheFile(readVariants, variantCache);
                    }
                    URL urlCus = new URI("https://jochzgtpyiakdeivfxeq.supabase.co/rest/v1/cosmetic_segments?select=cosmetic_id,segment_name,mask_texture_url&order=cosmetic_id.asc,segment_name.asc").toURL();
                    HttpURLConnection connCus = (HttpURLConnection)urlCus.openConnection();
                    connCus.setRequestMethod("GET");
                    Cosmetics.populateHeaders(connCus);
                    connCus.setConnectTimeout(20000);
                    connCus.connect();
                    read = new BufferedReader(new InputStreamReader(connCus.getInputStream(), StandardCharsets.UTF_8));
                    if (createCache) {
                        Cosmetics.cacheFile(read, segmentCache);
                    }
                }
                catch (IOException e) {
                    Cosmetics.debug("Internet is not connected");
                    e.printStackTrace();
                    if (!variantCache.exists() || !segmentCache.exists() || !cache.exists()) break block20;
                    try {
                        FileInputStream stream = new FileInputStream(cache);
                        InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);
                        readCosmetics = new BufferedReader(reader);
                    }
                    catch (FileNotFoundException e1) {
                        Cosmetics.debug("Cosmetic Cache file not found");
                    }
                    try {
                        FileInputStream stream1 = new FileInputStream(variantCache);
                        readVariants = new BufferedReader(new InputStreamReader((InputStream)stream1, StandardCharsets.UTF_8));
                    }
                    catch (FileNotFoundException e1) {
                        Cosmetics.debug("Cosmetic variant cache file not found");
                    }
                    try {
                        FileInputStream stream2 = new FileInputStream(segmentCache);
                        read = new BufferedReader(new InputStreamReader((InputStream)stream2, StandardCharsets.UTF_8));
                    }
                    catch (FileNotFoundException e1) {
                        Cosmetics.debug("Cosmetic segment cache file not found");
                    }
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
            if (read != null) {
                JsonElement varElem = JsonParser.parseReader(readVariants);
                HashMap<String, Map> variantsByCosmetic = new HashMap<String, Map>();
                JsonArray varArray = varElem.getAsJsonArray();
                for (JsonElement el : varArray) {
                    JsonObject obj = el.getAsJsonObject();
                    String cId = obj.get("cosmetic_id").getAsString();
                    String vName = obj.get("variant_name").getAsString();
                    String tex = obj.get("texture_url").getAsString();
                    variantsByCosmetic.computeIfAbsent(cId, k -> new HashMap()).put(vName, tex);
                }
                JsonElement cusElem = JsonParser.parseReader(read);
                HashMap<String, List> segments = new HashMap<String, List>();
                JsonArray cusArray = cusElem.getAsJsonArray();
                for (JsonElement el : cusArray) {
                    JsonObject obj = el.getAsJsonObject();
                    String cId = obj.get("cosmetic_id").getAsString();
                    String sName = obj.get("segment_name").getAsString();
                    String tex = obj.get("mask_texture_url").getAsString();
                    variantsByCosmetic.computeIfAbsent(cId, k -> new HashMap()).put("custom_" + sName, tex);
                    segments.computeIfAbsent(cId, k -> new ArrayList()).add(sName);
                }
                ImmutableMap.Builder builder = ImmutableMap.builder();
                JsonElement element = JsonParser.parseReader((Reader)readCosmetics);
                element.getAsJsonArray().forEach(elem -> {
                    JsonObject object_2 = elem.getAsJsonObject();
                    builder.put((Object)object_2.get("cosmetic_id").getAsString(), (Object)new Cosmetic(object_2.get("cosmetic_id").getAsString(), object_2.get("show_with_helmet").getAsBoolean(), object_2.get("height_blocks").getAsInt(), object_2.get("model_dsl").getAsString(), (Map)variantsByCosmetic.get(object_2.get("cosmetic_id").getAsString()), segments.getOrDefault(object_2.get("cosmetic_id").getAsString(), new ArrayList())));
                });
                ALL_COSMETICS = builder.build();
                try {
                    read.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                Cosmetics.debug("No cache to load, skipping cosmetics. For now");
            }
            if (ALL_COSMETICS.isEmpty()) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                ALL_COSMETICS = builder.put((Object)"", (Object)NONE).build();
            } else {
                NONE = ALL_COSMETICS.get("");
            }
        }).whenComplete((v, x) -> {
            x.printStackTrace();
            Cosmetics.obtainCosmetics(new File(Minecraft.m_91087_().f_91069_, "ucache.db"), true);
        });
    }

    static {
        NONE = new Cosmetic("", false, 0, "0,0,0><0,0,0,0,0,0,0,0,0", (Map<String, String>)new ImmutableMap.Builder().put((Object)"base", (Object)"").build(), (List<String>)new ImmutableList.Builder().add((Object)"base").build());
        lastPoll = Instant.now().minusSeconds(60L);
        recheckThread = null;
        OWNED_COSMETICS = new ImmutableList.Builder().add((Object)new OwnedCosmetic("", false, new String[0], Map.of("", new Color(0, 0, 0)))).build();
        ALL_COSMETICS = new ImmutableMap.Builder().build();
        EQUIPPED_COSMETICS = new HashMap<UUID, CosmeticSelection>();
    }

    static class TextureCache {
        private final TextureManager textureManager;
        private final Path root;
        private final Map<String, CompletableFuture<ResourceLocation>> textures = new Object2ObjectOpenHashMap();

        TextureCache(TextureManager pTextureManager, Path pRoot) {
            this.textureManager = pTextureManager;
            this.root = pRoot;
        }

        public CompletableFuture<ResourceLocation> getOrLoad(MinecraftProfileTexture pTexture) {
            String s = pTexture.getHash();
            CompletableFuture<ResourceLocation> completablefuture = this.textures.get(s);
            if (completablefuture == null) {
                completablefuture = this.registerTexture(pTexture);
                this.textures.put(s, completablefuture);
            }
            return completablefuture;
        }

        private CompletableFuture<ResourceLocation> registerTexture(MinecraftProfileTexture pTexture) {
            String s = Hashing.sha1().hashUnencodedChars((CharSequence)pTexture.getHash()).toString();
            ResourceLocation resourcelocation = this.getTextureLocation(s);
            Path path = this.root.resolve(s.length() > 2 ? s.substring(0, 2) : "xx").resolve(s);
            CompletableFuture<ResourceLocation> completablefuture = new CompletableFuture<ResourceLocation>();
            HttpTexture httptexture = new HttpTexture(path.toFile(), pTexture.getUrl(), DefaultPlayerSkin.m_118626_(), false, () -> completablefuture.complete(resourcelocation));
            this.textureManager.m_118495_(resourcelocation, (AbstractTexture)httptexture);
            return completablefuture;
        }

        private ResourceLocation getTextureLocation(String pName) {
            return ResourceLocation.withDefaultNamespace((String)("cosmetic/" + pName));
        }
    }
}

