/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.supporter;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.util.VersionHelper;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CapeHandler {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private static final Logger logger = LogManager.getLogger((String)"unionlib");

    public static void queuePlayerCapeReplacement(AbstractClientPlayer player) {
        if (CapeHandler.doesPlayerNeedCapeClient(player)) {
            String displayName = player.m_5446_().getString();
            if (CapeHandler.willPlayerShowCape(player)) {
                THREAD_POOL.submit(() -> {
                    logger.info("Queueing cape replacement for " + displayName);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        logger.fatal("Cape delay thread for " + displayName + " interrupted");
                        return;
                    }
                    Minecraft.m_91087_().m_18689_(() -> CapeHandler.replacePlayerCape(player));
                });
            } else {
                logger.info(displayName + " has decided to not display their custom cape");
            }
        }
    }

    private static void replacePlayerCape(AbstractClientPlayer player) {
        String displayName = player.m_5446_().getString();
        PlayerInfo playerInfo = player.m_108558_();
        if (playerInfo == null) {
            logger.info("PlayerInfo of " + displayName + " is null. Cannot add cape");
            return;
        }
        Map playerTextures = playerInfo.f_105299_;
        playerTextures.put(MinecraftProfileTexture.Type.CAPE, VersionHelper.toLoc("unionlib", "textures/cape/" + Cosmetics.equippedCosmetics().get(player.m_20148_()) + ".png"));
        logger.info("Looking for cape texture at " + VersionHelper.toLoc("unionlib", "textures/cape/" + Cosmetics.equippedCosmetics().get(player.m_20148_()) + ".png").m_135815_());
        logger.info("Replaced cape of " + displayName);
    }

    public static boolean doesPlayerNeedCapeClient(AbstractClientPlayer player) {
        return Cosmetics.equippedCosmetics().containsKey(player.m_20148_());
    }

    public static boolean willPlayerShowCape(AbstractClientPlayer player) {
        return false;
    }
}

