/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.mixin;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.stereowalker.unionlib.hook.AccessoryStack;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.entity.player.CustomInventoryGetter;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    private final NonNullList<ItemStack> lastAccessoryItemStacks = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);

    @Shadow
    public AttributeMap m_21204_() {
        return null;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;detectEquipmentUpdates()V")})
    public void tick_inject(CallbackInfo ci) {
        this.detectAccessoryUpdates();
    }

    private void detectAccessoryUpdates() {
        Map<AccessorySlot, ItemStack> map = this.collectAccesssoryChanges();
        if (map != null && !map.isEmpty()) {
            this.handleAccessoryChanges(map);
        }
    }

    @Nullable
    private Map<AccessorySlot, ItemStack> collectAccesssoryChanges() {
        EnumMap map = null;
        for (AccessorySlot accessoryslot : AccessorySlot.values()) {
            ItemStack itemstackR;
            boolean hasModifier;
            AccessoryStack itemstack1;
            AccessoryStack itemstack = (AccessoryStack)this.getLastAccessoryItem(accessoryslot);
            AttributeMap attributemap = this.m_21204_();
            if (!(this instanceof CustomInventoryGetter) || ItemStack.m_41728_((ItemStack)(itemstack1 = (AccessoryStack)((CustomInventoryGetter)((Object)this)).getUnionInventory().getAccessory(accessoryslot)).self(), (ItemStack)itemstack.self())) continue;
            if (map == null) {
                map = Maps.newEnumMap(AccessorySlot.class);
            }
            map.put(accessoryslot, itemstack1.self());
            if (!itemstack.self().m_41619_() && itemstack.self().m_41720_() instanceof AccessoryItem) {
                attributemap.m_22161_(itemstack.getAttributeModifiers(accessoryslot));
                hasModifier = false;
                for (AccessorySlot accessoryslotR : AccessorySlot.values()) {
                    if (accessoryslot == accessoryslotR || accessoryslot.getGroup() != accessoryslotR.getGroup() || !((AccessoryStack)(itemstackR = ((CustomInventoryGetter)((Object)this)).getUnionInventory().getAccessory(accessoryslotR))).getAttributeModifiers(accessoryslot.getGroup()).equals(itemstack.getAttributeModifiers(accessoryslot.getGroup()))) continue;
                    hasModifier = true;
                    break;
                }
                if (!hasModifier) {
                    attributemap.m_22161_(itemstack.getAttributeModifiers(accessoryslot.getGroup()));
                }
            }
            if (itemstack1.self().m_41619_() || !(itemstack1.self().m_41720_() instanceof AccessoryItem)) continue;
            attributemap.m_22178_(itemstack1.getAttributeModifiers(accessoryslot));
            hasModifier = false;
            for (AccessorySlot accessoryslotR : AccessorySlot.values()) {
                if (accessoryslot == accessoryslotR || accessoryslot.getGroup() != accessoryslotR.getGroup() || !((AccessoryStack)(itemstackR = ((CustomInventoryGetter)((Object)this)).getUnionInventory().getAccessory(accessoryslotR))).getAttributeModifiers(accessoryslot.getGroup()).equals(itemstack1.getAttributeModifiers(accessoryslot.getGroup()))) continue;
                hasModifier = true;
                break;
            }
            if (hasModifier) continue;
            attributemap.m_22178_(itemstack1.getAttributeModifiers(accessoryslot.getGroup()));
        }
        return map;
    }

    private void handleAccessoryChanges(Map<AccessorySlot, ItemStack> p_21143_) {
        ArrayList list = Lists.newArrayListWithCapacity((int)p_21143_.size());
        p_21143_.forEach((p_147204_, p_147205_) -> {
            ItemStack itemstack = p_147205_.m_41777_();
            list.add(Pair.of((Object)p_147204_, (Object)itemstack));
            this.setLastAccessoryItem((AccessorySlot)((Object)p_147204_), itemstack);
        });
    }

    private ItemStack getLastAccessoryItem(AccessorySlot pSlot) {
        return (ItemStack)this.lastAccessoryItemStacks.get(pSlot.getIndex());
    }

    private void setLastAccessoryItem(AccessorySlot pSlot, ItemStack pStack) {
        this.lastAccessoryItemStacks.set(pSlot.getIndex(), (Object)pStack);
    }
}

