/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.hook;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.stereowalker.unionlib.hook.AccessoryStack;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.world.entity.AccessorySlot;
import com.stereowalker.unionlib.world.item.AccessoryItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class AccessoryStackCalls {
    static final UUID BASE_ATTACK_DAMAGE_UUID = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    static final UUID BASE_ATTACK_SPEED_UUID = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");

    protected static void gatherAttributes(ItemStack stack, @Nullable Player pPlayer, Multimap<Attribute, AttributeModifier> multimap, List<Component> list, String name) {
        if (!multimap.isEmpty()) {
            list.add((Component)Component.m_237119_());
            list.add((Component)Component.m_237115_((String)("item.modifiers." + name)).m_130940_(ChatFormatting.GRAY));
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.m_22218_();
                boolean flag = false;
                if (pPlayer != null) {
                    if (attributemodifier.m_22209_() == BASE_ATTACK_DAMAGE_UUID) {
                        d0 += pPlayer.m_21172_(Attributes.f_22281_);
                        d0 += (double)EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)MobType.f_21640_);
                        flag = true;
                    } else if (attributemodifier.m_22209_() == BASE_ATTACK_SPEED_UUID) {
                        d0 += pPlayer.m_21172_(Attributes.f_22283_);
                        flag = true;
                    }
                }
                double d1 = attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && attributemodifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (((Attribute)entry.getKey()).equals(Attributes.f_22278_) ? d0 * 10.0 : d0) : d0 * 100.0;
                if (flag) {
                    list.add((Component)Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())})).m_130940_(ChatFormatting.DARK_GREEN));
                    continue;
                }
                if (d0 > 0.0) {
                    list.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.add((Component)Component.m_237110_((String)("attribute.modifier.take." + attributemodifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(d1 *= -1.0), Component.m_237115_((String)((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    private static Multimap<Attribute, AttributeModifier> getCustomAttributeModifiers(ListTag listtag, String name) {
        HashMultimap multimap = HashMultimap.create();
        for (int i = 0; i < listtag.size(); ++i) {
            AttributeModifier attributemodifier;
            Optional optional;
            CompoundTag compoundtag = listtag.m_128728_(i);
            if (compoundtag.m_128425_("Slot", 8) && !compoundtag.m_128461_("Slot").equals(name) || !(optional = RegistryHelper.attributes().m_6612_(ResourceLocation.m_135820_((String)compoundtag.m_128461_("AttributeName")))).isPresent() || (attributemodifier = AttributeModifier.m_22212_((CompoundTag)compoundtag)) == null || attributemodifier.m_22209_().getLeastSignificantBits() == 0L || attributemodifier.m_22209_().getMostSignificantBits() == 0L) continue;
            multimap.put((Object)((Attribute)optional.get()), (Object)attributemodifier);
        }
        return multimap;
    }

    protected static Multimap<Attribute, AttributeModifier> getAttributeModifiers(AccessoryStack stack, AccessorySlot slot) {
        Multimap<Attribute, AttributeModifier> multimap = stack.self().m_41782_() && stack.self().m_41783_().m_128425_("AccessoryAttributeModifiers", 9) ? AccessoryStackCalls.getCustomAttributeModifiers(stack.self().m_41783_().m_128437_("AccessoryAttributeModifiers", 10), "Slot") : (stack.self().m_41720_() instanceof AccessoryItem ? stack.getAccessory().getAttributeModifiers(slot, stack.self()) : ImmutableMultimap.of());
        return multimap;
    }

    protected static Multimap<Attribute, AttributeModifier> getAttributeModifiersForGroup(AccessoryStack stack, AccessorySlot.Group group) {
        Multimap<Attribute, AttributeModifier> multimap = stack.self().m_41782_() && stack.self().m_41783_().m_128425_("AccessoryAttributeModifiers", 9) ? AccessoryStackCalls.getCustomAttributeModifiers(stack.self().m_41783_().m_128437_("AccessoryAttributeModifiers", 10), "Group") : (stack.self().m_41720_() instanceof AccessoryItem ? stack.getAccessory().getAttributeModifiers(group, stack.self()) : ImmutableMultimap.of());
        return multimap;
    }
}

