/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ConfigSide;
import com.stereowalker.unionlib.config.UnionConfig;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.util.LoaderHelper;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ConfigClassBuilder {
    static final Map<Class<?>, List<String>> configs = Maps.newHashMap();
    public static final Map<Class<?>, Boolean> config_initialization = Maps.newHashMap();

    public static MutableComponent getConfigName(Class<?> configClass) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            UnionConfig config = configClass.getAnnotation(UnionConfig.class);
            if (config.translatableName().isEmpty()) {
                return Component.m_237115_((String)config.name());
            }
            return Component.m_237115_((String)config.translatableName());
        }
        return Component.m_237115_((String)"");
    }

    public static void reloadAll(Map<String, String> values) {
        configs.keySet().forEach(cla -> ConfigBuilder.read(cla, null, values, ConfigSide.Shared));
    }

    public static boolean hasConfigType(Class<?> configClass, ConfigSide side) {
        if (configClass.isAnnotationPresent(UnionConfig.class)) {
            for (Field field : configClass.getFields()) {
                UnionConfig.Entry configEntry = field.getAnnotation(UnionConfig.Entry.class);
                if (configEntry == null || configEntry.side() != side) continue;
                return true;
            }
        }
        return false;
    }

    public static void registerConfigurations(MinecraftMod mod, Class<?> configClass) {
        UnionConfig con = configClass.getAnnotation(UnionConfig.class);
        String name = con.folder().isEmpty() ? con.name() : con.folder() + File.separator + con.name();
        ConfigBuilder.Init client = new ConfigBuilder.Init(name, con, "client");
        ConfigBuilder.Init common = new ConfigBuilder.Init(name, con, "common");
        ConfigBuilder.Init server = new ConfigBuilder.Init(name, con, "server");
        ConfigBuilder.init(configClass, null, server, common, client, () -> config_initialization.put(configClass, true));
        ArrayList aliases = Lists.newArrayList();
        if (ConfigClassBuilder.hasConfigType(configClass, ConfigSide.Client)) {
            aliases.add(client.filename);
            if (!client.writer.fileExists()) {
                client.writer.buildToFile();
            }
        }
        if (ConfigClassBuilder.hasConfigType(configClass, ConfigSide.Shared)) {
            aliases.add(common.filename);
            if (!common.writer.fileExists()) {
                common.writer.buildToFile();
            }
        }
        if (ConfigClassBuilder.hasConfigType(configClass, ConfigSide.Server)) {
            aliases.add(server.filename);
            if (!server.writer.fileExists()) {
                server.writer.buildToFile();
            }
        }
        configs.put(configClass, aliases);
    }

    public static void loadConfigs(Class<?> configClass) {
        UnionConfig con = configClass.getAnnotation(UnionConfig.class);
        if (ConfigClassBuilder.hasConfigType(configClass, ConfigSide.Client)) {
            ConfigBuilder.loadConfig(LoaderHelper.configPath().toString() + (String)(con.folder().isEmpty() ? "" : File.separator + con.folder()), con.name() + (con.appendWithType() ? "-client" : "") + ".toml");
        }
        if (ConfigClassBuilder.hasConfigType(configClass, ConfigSide.Shared)) {
            ConfigBuilder.loadConfig(LoaderHelper.configPath().toString() + (String)(con.folder().isEmpty() ? "" : File.separator + con.folder()), con.name() + (con.appendWithType() ? "-common" : "") + ".toml");
        }
        if (ConfigClassBuilder.hasConfigType(configClass, ConfigSide.Server)) {
            ConfigBuilder.loadConfig(LoaderHelper.configPath().toString() + (String)(con.folder().isEmpty() ? "" : File.separator + con.folder()), con.name() + (con.appendWithType() ? "-server" : "") + ".toml");
        }
    }
}

