/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.cosmetics;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.stereowalker.unionlib.api.gui.GuiRenderer;
import com.stereowalker.unionlib.client.gui.components.CosmeticButton;
import com.stereowalker.unionlib.client.gui.screens.DefaultScreen;
import com.stereowalker.unionlib.client.gui.screens.cosmetics.CosmeticList;
import com.stereowalker.unionlib.client.gui.widget.button.Slider;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.supporter.CosmeticHandler;
import com.stereowalker.unionlib.supporter.CosmeticSelection;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.supporter.OwnedCosmetic;
import com.stereowalker.unionlib.util.ScreenHelper;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.util.math.Color;
import com.stereowalker.unionlib.util.newclasses.LinearLayout;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.PlayerModelPart;

public class CosmeticsScreen
extends DefaultScreen {
    CosmeticSelection initialHeadwear;
    CosmeticSelection currentHeadwear;
    Map<String, Color> col = new HashMap<String, Color>();
    protected Map<CosmeticSelection, CosmeticButton> buttons = new HashMap<CosmeticSelection, CosmeticButton>();
    CosmeticList list;
    protected UUID currentUser = Minecraft.m_91087_().m_91094_().m_92548_().getId();
    Button saveAndClose;
    Slider r;
    Slider g;
    Slider b;
    String segment;
    boolean isSaving = false;

    public CosmeticsScreen(Screen screen) {
        super((Component)Component.m_237115_((String)"Cosmetics"), screen);
        this.currentHeadwear = this.initialHeadwear = CosmeticHandler.getHat(this.currentUser);
        Cosmetics.fetchOwnedCosmetics(this.currentUser, () -> {
            List<String> segments = Cosmetics.allCosmetics().get(this.currentHeadwear.cosmeticId()).segments();
            if (segments.size() > 0) {
                List<OwnedCosmetic> owned = Cosmetics.ownedCosmetics().stream().filter(own -> this.currentHeadwear.cosmeticId().equals(own.cosmeticId())).toList();
                segments.forEach(seg -> this.col.put((String)seg, owned.size() > 0 ? ((OwnedCosmetic)owned.get(0)).colors().getOrDefault(seg, new Color(0.0f, 0.0f, 0.0f)) : new Color(0.0f, 0.0f, 0.0f)));
                this.r.m_93611_(this.col.get((Object)this.segment).r);
                this.g.m_93611_(this.col.get((Object)this.segment).g);
                this.b.m_93611_(this.col.get((Object)this.segment).b);
            }
            this.list.createButtons();
        });
        List<String> segments = Cosmetics.allCosmetics().get(this.currentHeadwear.cosmeticId()).segments();
        if (segments.size() > 0) {
            this.segment = segments.get(0);
            segments.forEach(seg -> this.col.put((String)seg, new Color(0.0f, 0.0f, 0.0f)));
        }
    }

    @Override
    protected void initialize() {
        this.saveAndClose = ScreenHelper.buttonBuilder(CommonComponents.f_130655_, button -> {
            button.m_93666_((Component)Component.m_237113_((String)"Saving..."));
            if (this.currentHeadwear.isCustom()) {
                Cosmetics.updateCosmeticColors(Minecraft.m_91087_().m_91094_().m_92548_().getId(), this.currentHeadwear);
            }
            this.isSaving = true;
            if (this.initialHeadwear != this.currentHeadwear) {
                Cosmetics.obtainCosmetics(new File(this.f_96541_.f_91069_, "ucache.db"), false);
                Cosmetics.updateCosmetic(Minecraft.m_91087_().m_91094_().m_92548_().getId(), this.currentHeadwear, () -> {});
                this.m_7379_();
            }
        }).m_253136_();
        this.r = (Slider)this.m_142416_((GuiEventListener)new Slider(20, this.layout.m_269355_() + (this.f_96544_ - 32) - 45, 100, 10, this.col.getOrDefault((Object)this.segment, (Color)Color.BLACK).r, (Component)Component.m_237113_((String)"Red"), d -> {
            if (this.col.containsKey(this.segment)) {
                this.col.get((Object)this.segment).r = d.floatValue();
            }
        }));
        this.g = (Slider)this.m_142416_((GuiEventListener)new Slider(20, this.layout.m_269355_() + (this.f_96544_ - 32) - 30, 100, 10, this.col.getOrDefault((Object)this.segment, (Color)Color.BLACK).g, (Component)Component.m_237113_((String)"Green"), d -> {
            if (this.col.containsKey(this.segment)) {
                this.col.get((Object)this.segment).g = d.floatValue();
            }
        }));
        this.b = (Slider)this.m_142416_((GuiEventListener)new Slider(20, this.layout.m_269355_() + (this.f_96544_ - 32) - 15, 100, 10, this.col.getOrDefault((Object)this.segment, (Color)Color.BLACK).b, (Component)Component.m_237113_((String)"Blue"), d -> {
            if (this.col.containsKey(this.segment)) {
                this.col.get((Object)this.segment).b = d.floatValue();
            }
        }));
        this.list = (CosmeticList)this.m_142416_((GuiEventListener)new CosmeticList(this.f_96541_, this));
    }

    @Override
    public void drawOnScreen(GuiRenderer guiRenderer, int mouseX, int mouseY) {
        this.r.f_93624_ = this.currentHeadwear.isCustom();
        this.g.f_93624_ = this.currentHeadwear.isCustom();
        this.b.f_93624_ = this.currentHeadwear.isCustom();
        if (this.col.containsKey(this.segment)) {
            this.r.m_93666_((Component)Component.m_237113_((String)("Red : " + this.col.get(this.segment).getRedInt())));
            this.g.m_93666_((Component)Component.m_237113_((String)("Green : " + this.col.get(this.segment).getGreenInt())));
            this.b.m_93666_((Component)Component.m_237113_((String)("Blue : " + this.col.get(this.segment).getBlueInt())));
        }
        this.saveAndClose.f_93623_ = !this.isSaving && Cosmetics.ownsCosmetic(this.currentHeadwear) && this.initialHeadwear != this.currentHeadwear;
        float x = 100.0f;
        float y = 150.0f;
        float width = 85.0f;
        float height = 120.0f;
        float rotationX = ((float)mouseY / (float)guiRenderer.guiGraphics().m_280206_() * 2.0f - 1.0f) * 11.0f;
        float rotationY = ((float)mouseX / (float)guiRenderer.guiGraphics().m_280182_() * 2.0f - 1.0f) * -50.0f;
        guiRenderer.poseStack().m_85836_();
        guiRenderer.poseStack().m_252880_(x, y, 100.0f);
        float f = height / 2.125f;
        guiRenderer.poseStack().m_85841_(f, f, f);
        guiRenderer.poseStack().m_252880_(0.0f, -0.0625f, 0.0f);
        guiRenderer.poseStack().m_272245_(Axis.f_252529_.m_252977_(rotationX), 0.0f, -1.0625f, 0.0f);
        guiRenderer.poseStack().m_252781_(Axis.f_252436_.m_252977_(rotationY));
        guiRenderer.guiGraphics().m_280262_();
        VersionHelper.setupForEntityInInventory(Axis.f_252529_.m_252977_(rotationX));
        MinecraftProfileTexture mpt = (MinecraftProfileTexture)Minecraft.m_91087_().m_91109_().m_118815_(Minecraft.m_91087_().m_91094_().m_92548_()).get(MinecraftProfileTexture.Type.SKIN);
        ResourceLocation skin = Minecraft.m_91087_().m_91109_().m_240306_(Minecraft.m_91087_().m_91094_().m_92548_());
        boolean slim = mpt == null ? false : mpt.getMetadata("model") != "default";
        PlayerModel playermodel = new PlayerModel(this.f_96541_.m_167973_().m_171103_(ModelLayers.f_171162_), slim);
        playermodel.m_8009_(true);
        playermodel.f_102610_ = false;
        playermodel.f_102809_.f_104207_ = this.f_96541_.f_91066_.m_168416_(PlayerModelPart.HAT);
        playermodel.f_103378_.f_104207_ = this.f_96541_.f_91066_.m_168416_(PlayerModelPart.JACKET);
        playermodel.f_103376_.f_104207_ = this.f_96541_.f_91066_.m_168416_(PlayerModelPart.LEFT_PANTS_LEG);
        playermodel.f_103377_.f_104207_ = this.f_96541_.f_91066_.m_168416_(PlayerModelPart.RIGHT_PANTS_LEG);
        playermodel.f_103374_.f_104207_ = this.f_96541_.f_91066_.m_168416_(PlayerModelPart.LEFT_SLEEVE);
        playermodel.f_103375_.f_104207_ = this.f_96541_.f_91066_.m_168416_(PlayerModelPart.RIGHT_SLEEVE);
        HatModel hat = new HatModel(this.currentHeadwear);
        hat.attach(playermodel);
        guiRenderer.poseStack().m_85836_();
        guiRenderer.poseStack().m_85841_(1.0f, 1.0f, -1.0f);
        guiRenderer.poseStack().m_252880_(0.0f, -1.5f, 0.0f);
        VertexConsumer vertexConsumer = guiRenderer.guiGraphics().m_280091_().m_6299_(RenderType.m_110473_((ResourceLocation)skin));
        VersionHelper.Client.renderToBuffer((Model)playermodel, guiRenderer.poseStack(), vertexConsumer, 0xF000F0, OverlayTexture.f_118083_);
        if (!Cosmetics.isEmpty(hat.getCosmetic())) {
            if (hat.getHat().isCustom()) {
                hat.getCosmetic().segments().forEach(segment -> {
                    VertexConsumer vertexConsumer2 = guiRenderer.guiGraphics().m_280091_().m_6299_(RenderType.m_110473_((ResourceLocation)hat.getCosmetic().texture("custom_" + segment)));
                    VersionHelper.Client.renderToBuffer((Model)hat, guiRenderer.poseStack(), vertexConsumer2, 0xF000F0, OverlayTexture.f_118083_, hat.getHat().colors().get(segment));
                });
            } else {
                VertexConsumer vertexConsumer2 = guiRenderer.guiGraphics().m_280091_().m_6299_(RenderType.m_110473_((ResourceLocation)hat.getCosmetic().texture(hat.getHat().variant())));
                VersionHelper.Client.renderToBuffer(hat, guiRenderer.poseStack(), vertexConsumer2, 0xF000F0, OverlayTexture.f_118083_);
            }
        }
        guiRenderer.poseStack().m_85849_();
        guiRenderer.guiGraphics().m_280262_();
        Lighting.m_84931_();
        guiRenderer.poseStack().m_85849_();
    }

    @Override
    protected void addFooter() {
        LinearLayout linearlayout = (LinearLayout)this.layout.m_269281_((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearlayout.addChild(ScreenHelper.buttonBuilder((Component)Component.m_237113_((String)"Cancel"), p_325377_ -> this.m_7379_()).m_253136_());
        linearlayout.addChild(this.saveAndClose);
    }

    @Override
    protected void m_267719_() {
        this.layout.m_264036_();
        ScreenHelper.setWidgetY((AbstractWidget)this.r, this.layout.m_269355_() + (this.f_96544_ - 32) - 45);
        ScreenHelper.setWidgetY((AbstractWidget)this.g, this.layout.m_269355_() + (this.f_96544_ - 32) - 30);
        ScreenHelper.setWidgetY((AbstractWidget)this.b, this.layout.m_269355_() + (this.f_96544_ - 32) - 15);
    }

    public void removeChild(GuiEventListener e) {
        this.m_169411_(e);
    }

    public <T extends GuiEventListener & NarratableEntry> T addChild(T e) {
        return (T)this.m_7787_(e);
    }
}

