/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.screens.config;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stereowalker.unionlib.client.gui.components.OverflowTextButton;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.config.lists.ListScreen;
import com.stereowalker.unionlib.client.gui.widget.button.Slider;
import com.stereowalker.unionlib.config.ConfigBuilder;
import com.stereowalker.unionlib.config.ConfigHolder;
import com.stereowalker.unionlib.config.ConfigSide;
import com.stereowalker.unionlib.config.UnionConfig;
import com.stereowalker.unionlib.util.RegistryHelper;
import com.stereowalker.unionlib.util.ScreenHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ConfigList
extends ContainerObjectSelectionList<Entry> {
    protected ConfigScreen screen;
    protected List<Component> tooltip = null;
    protected int tooltipX = 0;
    protected int tooltipY = 0;
    private static final Splitter DOT_SPLITTER = Splitter.on((String)".");

    public ConfigList(Minecraft mcIn, ConfigScreen screen, UnionConfig config) {
        super(mcIn, screen.f_96543_, screen.f_96544_, 43, screen.f_96544_ - 32, 25);
        this.screen = screen;
        List<String> c = Arrays.asList(ConfigBuilder.getValues(config).keySet().toArray(new String[0]));
        Collections.sort(c);
        String currentCategory = "";
        for (String configValue : c) {
            Object name = "";
            for (int i = 1; i < configValue.split("=").length; ++i) {
                name = (String)name + configValue.split("=")[i];
            }
            if (ConfigList.split((String)name).size() > 1 && !ConfigList.split((String)name).get(0).equals(currentCategory)) {
                this.m_7085_((AbstractSelectionList.Entry)new CategoryEntry((Component)Component.m_237113_((String)ConfigList.split((String)name).get(0))));
                currentCategory = ConfigList.split((String)name).get(0);
            }
            Object name2 = "";
            if (ConfigList.split((String)name).size() > 1) {
                for (int i = 1; i < ConfigList.split((String)name).size(); ++i) {
                    name2 = (String)name2 + ConfigList.split((String)name).get(i);
                }
            } else {
                name2 = name;
            }
            ConfigHolder<Boolean> holder = ConfigBuilder.getValues(config).get(configValue);
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Boolean) {
                this.m_7085_((AbstractSelectionList.Entry)new BooleanEntry((Component)Component.m_237113_((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof String) {
                this.m_7085_((AbstractSelectionList.Entry)new StringEntry((Component)Component.m_237113_((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Enum) {
                this.m_7085_((AbstractSelectionList.Entry)new EnumEntry((Component)Component.m_237113_((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Number) {
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Double) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237113_((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Float) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237113_((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Long) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237113_((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Short) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237113_((String)name2), holder));
                    continue;
                }
                if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof Byte) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237113_((String)name2), holder));
                    continue;
                }
                this.m_7085_((AbstractSelectionList.Entry)new NumberedEntry<Boolean>((Component)Component.m_237113_((String)name2), holder));
                continue;
            }
            if (ConfigBuilder.getValues(config).get(configValue).getDefaultValue() instanceof List) {
                this.m_7085_((AbstractSelectionList.Entry)new ListEntry((Component)Component.m_237113_((String)name2), holder));
                continue;
            }
            this.m_7085_((AbstractSelectionList.Entry)new ConfigEntry<Boolean>((Component)Component.m_237113_((String)name2), holder));
        }
    }

    private static List<String> split(String path) {
        return Lists.newArrayList((Iterable)DOT_SPLITTER.split((CharSequence)path));
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2 + this.m_5759_() + 10;
    }

    public int m_5759_() {
        return 400;
    }

    public void tick() {
        for (Entry ent : this.m_6702_()) {
            if (!(ent instanceof ConfigEntry)) continue;
            ((ConfigEntry)ent).tick();
        }
    }

    public class CategoryEntry
    extends Entry {
        private final Component labelText;
        private final int labelWidth;

        public CategoryEntry(Component p_i232280_2_) {
            this.labelText = p_i232280_2_;
            this.labelWidth = ((ConfigList)ConfigList.this).f_93386_.f_91062_.m_92852_((FormattedText)this.labelText);
        }

        public void m_6311_(GuiGraphics p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            p_230432_1_.m_280614_(((ConfigList)ConfigList.this).f_93386_.f_91062_, this.labelText, ((ConfigList)ConfigList.this).f_93386_.f_91080_.f_96543_ / 2 - this.labelWidth / 2, p_230432_3_ + p_230432_6_ - 9 - 1, 0xFFFFFF, false);
        }

        public boolean changeFocus(boolean focus) {
            return false;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return Collections.emptyList();
        }
    }

    public class BooleanEntry
    extends ConfigEntry<Boolean> {
        private BooleanEntry(Component name, ConfigHolder<Boolean> config) {
            super(name, config);
        }

        @Override
        public void reset(Component name) {
            this.configInteractable = ScreenHelper.buttonBuilder(name, onPress -> {
                this.config.setValue((Boolean)this.config.get() == false);
                ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
            }).m_252987_(0, 0, this.interactionWidth, 20).m_253136_();
        }

        @Override
        public void m_6311_(GuiGraphics p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.m_6311_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.configInteractable.m_93666_(CommonComponents.m_130666_((boolean)((Boolean)this.config.get())));
        }
    }

    public class StringEntry
    extends ConfigEntry<String> {
        private StringEntry(Component name, ConfigHolder<String> config) {
            super(name, config);
        }

        @Override
        public void reset(Component name) {
            if (this.configInteractable instanceof EditBox) {
                ((EditBox)this.configInteractable).m_94144_((String)this.config.get());
            } else {
                this.configInteractable = new EditBox(((ConfigList)ConfigList.this).f_93386_.f_91062_, 0, 0, this.interactionWidth, 20, (Component)Component.m_237115_((String)"config.editBox"));
                ((EditBox)this.configInteractable).m_94144_((String)this.config.get());
                ((EditBox)this.configInteractable).m_94151_(p_214319_1_ -> {
                    this.config.setValue(p_214319_1_);
                    ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
                });
            }
        }

        @Override
        public void tick() {
        }
    }

    public class EnumEntry
    extends ConfigEntry<Enum<?>> {
        private EnumEntry(Component name, ConfigHolder<Enum<?>> config) {
            super(name, config);
        }

        @Override
        public void reset(Component name) {
            this.configInteractable = ScreenHelper.buttonBuilder(name, onPress -> {
                this.config.setValue(RegistryHelper.rotateEnumForward((Enum)((Enum)this.config.get()), (Enum[])((Enum[])((Enum)this.config.get()).getDeclaringClass().getEnumConstants())));
                ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
            }).m_252987_(0, 0, this.interactionWidth, 20).m_253136_();
        }

        @Override
        public void m_6311_(GuiGraphics p_230432_1_, int p_230432_2_, int p_230432_3_, int p_230432_4_, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            super.m_6311_(p_230432_1_, p_230432_2_, p_230432_3_, p_230432_4_, p_230432_5_, p_230432_6_, p_230432_7_, p_230432_8_, p_230432_9_, p_230432_10_);
            this.configInteractable.m_93666_((Component)Component.m_237115_((String)((Enum)this.config.get()).name()));
        }
    }

    public class NumberedEntry<V extends Number>
    extends ConfigEntry<V> {
        private NumberedEntry(Component name, ConfigHolder<V> config) {
            super(name, config);
        }

        @Override
        public void reset(Component name) {
            double shiftedMax = ((Number)this.config.getMax()).doubleValue() - ((Number)this.config.getMin()).doubleValue();
            if (this.config.isUsingSlider()) {
                if (this.configInteractable instanceof Slider) {
                    ((Slider)this.configInteractable).m_93611_(((Number)this.config.get()).doubleValue() / shiftedMax);
                } else {
                    this.configInteractable = new Slider(0, 0, this.interactionWidth, 20, ((Number)this.config.get()).doubleValue() / shiftedMax, (Component)Component.m_237113_((String)((Number)this.config.get()).toString()));
                    ((Slider)this.configInteractable).setResponder(val -> {
                        if (this.config.isUsingSlider()) {
                            Number oldValue = (Number)this.config.get();
                            Double newValue = val * shiftedMax + ((Number)this.config.getMin()).doubleValue();
                            try {
                                if (this.config.get() instanceof Double) {
                                    this.config.setValue(newValue);
                                } else if (this.config.get() instanceof Float) {
                                    this.config.setValue(Float.valueOf(newValue.floatValue()));
                                } else if (this.config.get() instanceof Long) {
                                    this.config.setValue(newValue.longValue());
                                } else if (this.config.get() instanceof Short) {
                                    this.config.setValue(newValue.shortValue());
                                } else if (this.config.get() instanceof Byte) {
                                    this.config.setValue(newValue.byteValue());
                                } else {
                                    this.config.setValue(newValue.intValue());
                                }
                            }
                            catch (NumberFormatException e) {
                                this.config.setValue(oldValue);
                            }
                            ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
                            ((Slider)this.configInteractable).m_93666_((Component)Component.m_237113_((String)((Number)this.config.get()).toString()));
                        }
                    });
                }
            } else if (this.configInteractable instanceof EditBox) {
                ((EditBox)this.configInteractable).m_94144_(((Number)this.config.get()).toString());
            } else {
                this.configInteractable = new EditBox(((ConfigList)ConfigList.this).f_93386_.f_91062_, 0, 0, this.interactionWidth, 20, (Component)Component.m_237115_((String)"config.editNumberBox"));
                ((EditBox)this.configInteractable).m_94144_(((Number)this.config.get()).toString());
                ((EditBox)this.configInteractable).m_94153_(text -> {
                    Number oldValue = (Number)this.config.get();
                    Number newValue = null;
                    try {
                        newValue = oldValue instanceof Double ? (Number)Double.parseDouble(text) : (Number)(oldValue instanceof Float ? (Number)Float.valueOf(Float.parseFloat(text)) : (Number)(oldValue instanceof Long ? (Number)Long.parseLong(text) : (Number)(oldValue instanceof Short ? (Number)Short.parseShort(text) : (Number)(oldValue instanceof Byte ? (Number)Byte.parseByte(text) : (Number)Integer.parseInt(text)))));
                        return newValue != null;
                    }
                    catch (NumberFormatException e) {
                        return false;
                    }
                });
                ((EditBox)this.configInteractable).m_94151_(text -> {
                    Number oldValue = (Number)this.config.get();
                    Number newValue = null;
                    try {
                        newValue = oldValue instanceof Double ? (Number)Double.parseDouble(text) : (Number)(oldValue instanceof Float ? (Number)Float.valueOf(Float.parseFloat(text)) : (Number)(oldValue instanceof Long ? (Number)Long.parseLong(text) : (Number)(oldValue instanceof Short ? (Number)Short.parseShort(text) : (Number)(oldValue instanceof Byte ? (Number)Byte.parseByte(text) : (Number)Integer.parseInt(text)))));
                        this.config.setValue(newValue);
                        ConfigBuilder.reload(this.config.getParentFile(), new ConfigSide[0]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
            }
        }

        @Override
        public void tick() {
        }
    }

    public class ListEntry
    extends ConfigEntry<List<?>> {
        private ListEntry(Component name, ConfigHolder<List<?>> config) {
            super(name, config);
        }

        @Override
        public void reset(Component name) {
            this.configInteractable = ScreenHelper.buttonBuilder((Component)Component.m_237115_((String)"needle.gui.list"), onPress -> ConfigList.this.f_93386_.m_91152_((Screen)new ListScreen(name, ConfigList.this.screen, this.config))).m_252987_(0, 0, this.interactionWidth, 20).m_253136_();
        }
    }

    public class ConfigEntry<T>
    extends Entry {
        protected final ConfigHolder<T> config;
        protected final Button configButton;
        protected AbstractWidget configInteractable;
        protected final Button resetButton;
        protected final int interactionWidth;

        public void tick() {
        }

        public void reset(Component name) {
            this.configInteractable = null;
        }

        private ConfigEntry(Component name, ConfigHolder<T> config) {
            this.config = config;
            this.interactionWidth = 140;
            Component translatableOr = config.getTranslatable().isEmpty() ? name : Component.m_237115_((String)config.getTranslatable());
            this.configButton = new OverflowTextButton(0, 0, 195, 20, translatableOr, onPress -> {});
            MutableComponent c = Component.m_237119_();
            List<Component> translatableCommentOr = config.getTranslatableComments().isEmpty() ? config.getComments() : config.getTranslatableComments();
            translatableCommentOr.subList(0, translatableCommentOr.size() - 1).forEach(el -> c.m_7220_(el).m_130946_("\n"));
            c.m_7220_(translatableCommentOr.get(translatableCommentOr.size() - 1));
            this.configButton.m_257544_(Tooltip.m_257550_((Component)c));
            this.reset(name);
            this.resetButton = new OverflowTextButton(0, 0, 40, 20, (Component)Component.m_237115_((String)"controls.reset"), onPress -> {
                this.config.setValue(this.config.getDefaultValue());
                this.reset(name);
            });
            ConfigList.this.screen.addChild(this.configInteractable);
            ConfigList.this.screen.addChild(this.resetButton);
        }

        public void m_6311_(GuiGraphics pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
            int i = ConfigList.this.m_5756_() - this.resetButton.m_5711_() - 10;
            ScreenHelper.setWidgetPosition((AbstractWidget)this.resetButton, i, pTop);
            this.resetButton.m_88315_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            boolean bl = this.resetButton.f_93623_ = !this.config.get().equals(this.config.getDefaultValue());
            if (this.configInteractable != null) {
                int k = i - 5 - this.configInteractable.m_5711_();
                ScreenHelper.setWidgetPosition(this.configInteractable, k, pTop);
                this.configInteractable.m_88315_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            }
            ScreenHelper.setWidgetPosition((AbstractWidget)this.configButton, pLeft, pTop);
            this.configButton.m_88315_(pPoseStack, pMouseX, pMouseY, pPartialTick);
            this.configButton.f_93623_ = false;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.configInteractable == null ? ImmutableList.of((Object)this.configButton, (Object)this.resetButton) : ImmutableList.of((Object)this.configButton, (Object)this.resetButton, (Object)this.configInteractable);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.configInteractable == null ? ImmutableList.of((Object)this.configButton, (Object)this.resetButton) : ImmutableList.of((Object)this.configButton, (Object)this.resetButton, (Object)this.configInteractable);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.resetButton.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.configInteractable != null && this.configInteractable.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            return this.configButton.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            return this.resetButton.m_6348_(mouseX, mouseY, button) || this.configInteractable != null && this.configInteractable.m_6348_(mouseX, mouseY, button) || this.configButton.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.configInteractable != null) {
                return this.configInteractable.m_7933_(keyCode, scanCode, modifiers);
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.configInteractable != null && this.configInteractable.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            if (this.resetButton.m_7979_(mouseX, mouseY, button, dragX, dragY)) {
                return true;
            }
            return this.configButton.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

