/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.stereowalker.unionlib.client.model.HatModel;
import com.stereowalker.unionlib.supporter.CosmeticSelection;
import com.stereowalker.unionlib.supporter.Cosmetics;
import com.stereowalker.unionlib.util.VersionHelper;
import com.stereowalker.unionlib.util.math.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class CosmeticButton
extends Button {
    HatModel<Player> hat;
    PlayerModel<Player> playerModel;
    boolean darken;

    public CosmeticButton(int pX, int pY, int pWidth, int pHeight, CosmeticSelection model, Button.OnPress pOnPress) {
        super(pX, pY, pWidth, pHeight, (Component)Component.m_237119_(), pOnPress, Button.f_252438_);
        Minecraft minecraft = Minecraft.m_91087_();
        this.hat = new HatModel(model);
        this.playerModel = new PlayerModel(minecraft.m_167973_().m_171103_(ModelLayers.f_171162_), false);
        this.playerModel.f_102610_ = false;
        this.playerModel.f_102808_.f_104201_ = 24.0f;
        this.hat.attach((HumanoidModel<Player>)this.playerModel);
    }

    public boolean isCosmetic(CosmeticSelection model, String segment) {
        if (model.isCustom()) {
            if (this.hat.getHat().colors().getOrDefault(segment, Color.BLACK).equals(model.colors().getOrDefault(segment, Color.WHITE))) {
                return this.hat.getHat().equalsNoColor(model);
            }
            return false;
        }
        return this.hat.getHat().equalsNoColor(model);
    }

    public void update(boolean isEquipped, boolean isOwned) {
        this.f_93623_ = !isEquipped;
        this.darken = !isOwned;
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float pPartialTicks) {
        float b;
        float g;
        float r;
        float f = this.darken ? 1.0f : (r = this.hat.getHat().isCustom() ? 0.7f : 0.9f);
        float f2 = this.darken ? 0.7f : (g = this.hat.getHat().isCustom() ? 1.0f : 1.0f);
        float f3 = this.darken ? 0.7f : (b = this.hat.getHat().isCustom() ? 0.7f : 0.9f);
        float c = this.darken ? 0.8f : (this.hat.getHat().isCustom() ? 1.0f : 1.0f);
        guiGraphics.m_280246_(r, g, b, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.m_280027_(f_93617_, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.m_274533_());
        guiGraphics.m_280246_(c, c, c, this.f_93625_);
        float height = (float)this.m_93694_() - 6.0f;
        float width = (float)this.m_5711_() - 6.0f;
        float x = (float)this.m_252754_() + 3.0f;
        float y = (float)this.m_252907_() + 6.0f;
        float rotationX = ((float)mouseY / (float)guiGraphics.m_280206_() * 2.0f - 1.0f) * 11.0f;
        float rotationY = ((float)mouseX / (float)guiGraphics.m_280182_() * 2.0f - 1.0f) * -50.0f;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(x + width / 2.0f, y + height, 100.0f);
        float f4 = height / 2.125f;
        f4 = height / ((8.5f + (float)this.hat.centerHead()) / 16.0f);
        guiGraphics.m_280168_().m_85841_(f4, f4, f4);
        guiGraphics.m_280168_().m_252880_(0.0f, -0.0625f, 0.0f);
        guiGraphics.m_280168_().m_272245_(Axis.f_252529_.m_252977_(rotationX), 0.0f, -1.0625f, 0.0f);
        guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(rotationY));
        guiGraphics.m_280262_();
        VersionHelper.setupForEntityInInventory(Axis.f_252529_.m_252977_(rotationX));
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85841_(1.0f, 1.0f, -1.0f);
        guiGraphics.m_280168_().m_252880_(0.0f, -1.5f, 0.0f);
        VertexConsumer vertexConsumer = guiGraphics.m_280091_().m_6299_(RenderType.m_110473_((ResourceLocation)VersionHelper.toLoc("unionlib", "textures/cosmetics/head_preview.png")));
        VersionHelper.Client.renderToBuffer(this.playerModel, guiGraphics.m_280168_(), vertexConsumer, 0xF000F0, OverlayTexture.f_118083_);
        if (!Cosmetics.isEmpty(this.hat.getCosmetic())) {
            if (this.hat.getHat().isCustom()) {
                this.hat.getCosmetic().segments().forEach(segment -> {
                    VertexConsumer vertexConsumer2 = guiGraphics.m_280091_().m_6299_(RenderType.m_110473_((ResourceLocation)this.hat.getCosmetic().texture("custom_" + segment)));
                    VersionHelper.Client.renderToBuffer(this.hat, guiGraphics.m_280168_(), vertexConsumer2, 0xF000F0, OverlayTexture.f_118083_, this.hat.getHat().colors().get(segment));
                });
            } else {
                VertexConsumer vertexConsumer2 = guiGraphics.m_280091_().m_6299_(RenderType.m_110473_((ResourceLocation)this.hat.getCosmetic().texture(this.hat.getHat().variant())));
                VersionHelper.Client.renderToBuffer(this.hat, guiGraphics.m_280168_(), vertexConsumer2, 0xF000F0, OverlayTexture.f_118083_);
            }
        }
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280262_();
        Lighting.m_84931_();
        guiGraphics.m_280168_().m_85849_();
    }

    private int m_274533_() {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }
        return 46 + i * 20;
    }
}

