/*
 * Decompiled with CFR 0.152.
 */
package com.dragn0007.deepblue.entities;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FollowBoatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.TropicalFish;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractShark
extends WaterAnimal
implements NeutralMob,
Bucketable {
    private static final EntityDataAccessor<Boolean> FROM_BUCKET = SynchedEntityData.m_135353_(AbstractShark.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)50);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;

    public boolean m_8023_() {
        return super.m_8023_() || this.m_27487_();
    }

    public boolean m_6785_(double p_27492_) {
        return !this.m_27487_() && !this.m_8077_();
    }

    public boolean m_6040_() {
        return true;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FROM_BUCKET, (Object)false);
    }

    public boolean m_27487_() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BUCKET);
    }

    public void m_27497_(boolean p_27498_) {
        this.f_19804_.m_135381_(FROM_BUCKET, (Object)p_27498_);
    }

    public void m_7380_(CompoundTag p_27485_) {
        super.m_7380_(p_27485_);
        p_27485_.m_128379_("FromBucket", this.m_27487_());
    }

    public void m_7378_(CompoundTag p_27465_) {
        super.m_7378_(p_27465_);
        this.m_27497_(p_27465_.m_128471_("FromBucket"));
    }

    public void m_6872_(ItemStack p_27494_) {
        Bucketable.m_148822_((Mob)this, (ItemStack)p_27494_);
    }

    public void m_142278_(CompoundTag p_148708_) {
        Bucketable.m_148825_((Mob)this, (CompoundTag)p_148708_);
    }

    public SoundEvent m_142623_() {
        return SoundEvents.f_11782_;
    }

    protected InteractionResult m_6071_(Player p_27477_, InteractionHand p_27478_) {
        return Bucketable.m_148828_((Player)p_27477_, (InteractionHand)p_27478_, (LivingEntity)this).orElse(super.m_6071_(p_27477_, p_27478_));
    }

    public AbstractShark(EntityType<? extends AbstractShark> p_27461_, Level p_27462_) {
        super(p_27461_, p_27462_);
        this.f_21342_ = new FishMoveControl(this);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public int m_5792_() {
        return 4;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SharkMeleeAttackGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Dolphin.class, 8.0f, 1.6, 1.4, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(4, (Goal)new SharkSwimGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new SharkHurtByTargetGoal());
        this.f_21345_.m_25352_(0, (Goal)new TryFindWaterGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new FollowBoatGoal((PathfinderMob)this));
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, TropicalFish.class, false));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_, Items.f_42579_, Items.f_42581_}), false));
        this.f_21345_.m_25352_(4, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((AbstractShark)this).m_21674_(arg_0)));
    }

    protected PathNavigation m_6037_(Level p_27480_) {
        return new WaterBoundPathNavigation((Mob)this, p_27480_);
    }

    public void m_7023_(Vec3 p_27490_) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(0.01f, p_27490_);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(p_27490_);
        }
    }

    public void m_8107_() {
        if (!this.m_20069_() && this.m_20096_() && this.f_19863_) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.f_19796_.m_188501_() * 2.0f - 1.0f) * 0.05f)));
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
        super.m_8107_();
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12360_;
    }

    protected SoundEvent getFlopSound() {
        return SoundEvents.f_11883_;
    }

    protected boolean canRandomSwim() {
        return true;
    }

    protected SoundEvent m_5501_() {
        return SoundEvents.f_11938_;
    }

    protected void m_7355_(BlockPos p_27482_, BlockState p_27483_) {
    }

    public boolean m_7327_(Entity p_28319_) {
        boolean flag = p_28319_.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, p_28319_);
        }
        return flag;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public void m_7870_(int p_29543_) {
        this.remainingPersistentAngerTime = p_29543_;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_6925_(@Nullable UUID p_29539_) {
        this.persistentAngerTarget = p_29539_;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    static class FishMoveControl
    extends MoveControl {
        private final AbstractShark fish;

        FishMoveControl(AbstractShark p_27501_) {
            super((Mob)p_27501_);
            this.fish = p_27501_;
        }

        public void m_8126_() {
            if (this.fish.m_204029_(FluidTags.f_13131_)) {
                this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, 0.005, 0.0));
            }
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !this.fish.m_21573_().m_26571_()) {
                float f = (float)(this.f_24978_ * this.fish.m_21133_(Attributes.f_22279_));
                this.fish.m_7910_(Mth.m_14179_((float)0.125f, (float)this.fish.m_6113_(), (float)f));
                double d0 = this.f_24975_ - this.fish.m_20185_();
                double d1 = this.f_24976_ - this.fish.m_20186_();
                double d2 = this.f_24977_ - this.fish.m_20189_();
                if (d1 != 0.0) {
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    this.fish.m_20256_(this.fish.m_20184_().m_82520_(0.0, (double)this.fish.m_6113_() * (d1 / d3) * 0.1, 0.0));
                }
                if (d0 != 0.0 || d2 != 0.0) {
                    float f1 = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.fish.m_146922_(this.m_24991_(this.fish.m_146908_(), f1, 90.0f));
                    this.fish.f_20883_ = this.fish.m_146908_();
                }
            } else {
                this.fish.m_7910_(0.0f);
            }
        }
    }

    class SharkMeleeAttackGoal
    extends MeleeAttackGoal {
        public SharkMeleeAttackGoal() {
            super((PathfinderMob)AbstractShark.this, 5.0, true);
        }

        protected void m_6739_(LivingEntity p_29589_, double p_29590_) {
            double d0 = this.m_6639_(p_29589_);
            if (p_29590_ <= d0 && this.m_25564_()) {
                this.m_25563_();
                this.f_25540_.m_7327_((Entity)p_29589_);
            } else if (p_29590_ <= d0 * 2.0) {
                if (this.m_25564_()) {
                    this.m_25563_();
                }
                if (this.m_25565_() <= 10) {
                    // empty if block
                }
            } else {
                this.m_25563_();
            }
        }
    }

    static class SharkSwimGoal
    extends RandomSwimmingGoal {
        private final AbstractShark fish;

        public SharkSwimGoal(AbstractShark p_27505_) {
            super((PathfinderMob)p_27505_, 1.0, 40);
            this.fish = p_27505_;
        }

        public boolean m_8036_() {
            return this.fish.canRandomSwim() && super.m_8036_();
        }
    }

    class SharkHurtByTargetGoal
    extends HurtByTargetGoal {
        public SharkHurtByTargetGoal() {
            super((PathfinderMob)AbstractShark.this, new Class[0]);
        }

        protected void m_5766_(Mob p_29580_, LivingEntity p_29581_) {
            if (p_29580_ instanceof AbstractShark && !p_29580_.m_6162_()) {
                super.m_5766_(p_29580_, p_29581_);
            }
        }
    }

    class SharkAttackPlayersGoal
    extends NearestAttackableTargetGoal<Player> {
        public SharkAttackPlayersGoal() {
            super((Mob)AbstractShark.this, Player.class, 20, true, true, (Predicate)null);
        }

        protected double m_7623_() {
            return super.m_7623_() * 1.5;
        }
    }

    class SharkEatFishGoal
    extends NearestAttackableTargetGoal<AbstractFish> {
        public SharkEatFishGoal() {
            super((Mob)AbstractShark.this, AbstractFish.class, 40, true, true, (Predicate)null);
        }

        protected double m_7623_() {
            return super.m_7623_() * 0.5;
        }
    }
}

